/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.mixin.cilent;

import com.ytgld.chest_item.items.ItemBase;
import com.ytgld.chest_item.items.Terror;
import com.ytgld.chest_item.renderer.MRender;
import com.ytgld.chest_item.renderer.RendererFarm;
import com.ytgld.chest_item.renderer.i.IAbstractContainerScreen;
import com.ytgld.chest_item.renderer.i.IGuiGraphics;
import com.ytgld.chest_item.renderer.light.Light;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2ic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
public abstract class GuiGraphicsMixin
implements IGuiGraphics {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private GuiRenderState guiRenderState;
    @Shadow
    @Final
    private Matrix3x2fStack pose;

    @Shadow
    public abstract int guiWidth();

    @Shadow
    public abstract int guiHeight();

    @Override
    public GuiRenderState cI1_21_9$guiRenderState() {
        return this.guiRenderState;
    }

    @Override
    public void chest_item$addW(ItemStack stack) {
        GuiGraphics guiGraphics = (GuiGraphics)this;
        Item item = stack.getItem();
        if (item instanceof Terror) {
            IAbstractContainerScreen iAbstractContainerScreen;
            List<Vec2> xy;
            Terror terror = (Terror)item;
            guiGraphics.pose().pushMatrix();
            Screen screen = this.minecraft.screen;
            if (screen instanceof IAbstractContainerScreen && (xy = (iAbstractContainerScreen = (IAbstractContainerScreen)screen).chest_item$xy()) != null) {
                for (int i = 1; i < xy.size(); ++i) {
                    Vec2 prevPos = xy.get(i - 1);
                    Vec2 currPos = xy.get(i);
                    if (prevPos.x == 0.0f || prevPos.y == 0.0f || currPos.x == 0.0f || currPos.y == 0.0f) continue;
                    float alpha = (float)i / (float)xy.size();
                    Vec2 adjustedPrevPos = new Vec2(prevPos.x, prevPos.y);
                    Vec2 adjustedCurrPos = new Vec2(currPos.x, currPos.y);
                    this.pose.pushMatrix();
                    this.pose.translate(prevPos.x, prevPos.y);
                    this.pose.scale(alpha * 1.55f);
                    this.pose.translate(-prevPos.x, -prevPos.y);
                    int color = terror.color(stack);
                    int as = color >> 24 & 0xFF;
                    int rs = color >> 16 & 0xFF;
                    int gs = color >> 8 & 0xFF;
                    int bs = color & 0xFF;
                    new RendererFarm(this.pose, this.guiRenderState, Light.ARGB.color((int)(alpha * (float)as), rs, gs, (int)((float)bs * alpha))).chest_item$blit(MRender.RenderPs.GUI_TEXTURED, ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"textures/gui/tooltip/fire.png"), (int)adjustedCurrPos.x - 8, (int)adjustedCurrPos.y - 8, 0.0f, 0.0f, 16, 16, 16, 16);
                    new RendererFarm(this.pose, this.guiRenderState, Light.ARGB.color((int)(alpha * (float)as), rs, gs, (int)((float)bs * alpha))).chest_item$blit(MRender.RenderPs.GUI_TEXTURED, ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"textures/gui/tooltip/small_fire.png"), (int)adjustedPrevPos.x - 8, (int)adjustedPrevPos.y - 8, 0.0f, 0.0f, 16, 16, 16, 16);
                    this.pose.popMatrix();
                }
            }
            guiGraphics.pose().popMatrix();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"renderTooltip(Lnet/minecraft/client/gui/Font;Ljava/util/List;IILnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/world/item/ItemStack;)V"})
    public void ytgld$ClientTooltipPositioner(Font font, List<ClientTooltipComponent> components, int x, int y, ClientTooltipPositioner positioner, ResourceLocation background, ItemStack tooltipStack, CallbackInfo ci) {
        RenderTooltipEvent.Pre preEvent;
        if (tooltipStack.getItem() instanceof ItemBase && !(preEvent = ClientHooks.onRenderTooltipPre((ItemStack)tooltipStack, (GuiGraphics)((GuiGraphics)this), (int)x, (int)y, (int)this.guiWidth(), (int)this.guiHeight(), components, (Font)font, (ClientTooltipPositioner)positioner)).isCanceled()) {
            font = preEvent.getFont();
            x = preEvent.getX();
            y = preEvent.getY();
            int i = 0;
            int j = components.size() == 1 ? -2 : 0;
            for (ClientTooltipComponent clienttooltipcomponent : components) {
                int k = clienttooltipcomponent.getWidth(font);
                if (k > i) {
                    i = k;
                }
                j += clienttooltipcomponent.getHeight(font);
            }
            Vector2ic vector2ic = positioner.positionTooltip(this.guiWidth(), this.guiHeight(), x, y, i, j);
            int l = vector2ic.x();
            int i1 = vector2ic.y();
            this.pose.pushMatrix();
            this.chest_item$renderTooltipBackground((GuiGraphics)this, l, i1, i, j);
            this.pose.popMatrix();
        }
    }

    @Unique
    private void chest_item$renderTooltipBackground(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        int i = x - 3 - 9;
        int j = y - 3 - 9;
        int k = width + 3 + 3 + 18;
        int l = height + 3 + 3 + 18;
        guiGraphics.blitSprite(MRender.RenderPs.GUI_TEXTURED, ResourceLocation.fromNamespaceAndPath((String)"chest_item", (String)"tooltip/frame"), i, j, k, l);
    }
}

