/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.meet;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.chest_item.Handler;
import com.ytgld.chest_item.effect.Effects;
import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.ItemBase;
import com.ytgld.chest_item.items.Meat;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.renderer.light.Light;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import org.jetbrains.annotations.Nullable;

public class SelfIncreasingHeart
extends ItemBase
implements Meat {
    public SelfIncreasingHeart(Item.Properties properties) {
        super(properties);
    }

    public static void tick(LivingEntityUseItemEvent.Finish event) {
        Player player;
        ChestInventory chestInventory;
        LivingEntity living = event.getEntity();
        if (living instanceof Player && (chestInventory = Handler.getItem(player = (Player)living)) != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (!stack.is(InitItems.Self_Increasing_Heart) || event.getItem().getUseAnimation() != UseAnim.EAT) continue;
                player.addEffect(new MobEffectInstance(Effects.IncreasingMeat_, 1800, 0));
                MobEffectInstance mobEffectInstance = player.getEffect(Effects.IncreasingMeat_);
                if (mobEffectInstance == null) continue;
                if (mobEffectInstance.getAmplifier() < 9) {
                    player.addEffect(new MobEffectInstance(mobEffectInstance.getEffect(), mobEffectInstance.getDuration() + 1800, mobEffectInstance.getAmplifier() + 1, false, false));
                    break;
                }
                player.addEffect(new MobEffectInstance(mobEffectInstance.getEffect(), 18000, 10, false, false));
                break;
            }
        }
    }

    public static void tick(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (!player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (stack.is(InitItems.Self_Increasing_Heart)) {
                    player.getAttributes().addTransientAttributeModifiers(SelfIncreasingHeart.attributeModifierMultimap());
                    break;
                }
                player.getAttributes().removeAttributeModifiers(SelfIncreasingHeart.attributeModifierMultimap());
            }
        }
    }

    @Override
    @Nullable
    public Multimap<Holder<Attribute>, AttributeModifier> muAttribute(Player player) {
        return SelfIncreasingHeart.attributeModifierMultimap();
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> attributeModifierMultimap() {
        HashMultimap modifiers = HashMultimap.create();
        modifiers.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.Self_Increasing_Heart.asItem().getDescriptionId())), -0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        return modifiers;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipAdder, flag);
        tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.self_increasing_heart.string.0").withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.ITALIC));
        tooltipAdder.add((Component)Component.literal((String)""));
        tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.self_increasing_heart.string.1").withStyle(ChatFormatting.GOLD));
        tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.self_increasing_heart.string.2").withStyle(ChatFormatting.GOLD));
        tooltipAdder.add((Component)Component.translatable((String)"item.chest_item.self_increasing_heart.string.3").withStyle(ChatFormatting.GOLD));
    }

    @Override
    public int color(ItemStack stack) {
        return Light.ARGB.color(255, 255, 135, 105);
    }
}

