/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.black;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.AttReg;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.ItemBlackShadow;
import com.ytgld.chest_item.other.ChestInventory;
import com.ytgld.chest_item.renderer.light.Light;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import org.jetbrains.annotations.Nullable;

public class CorruptionCrystal
extends ItemBlackShadow {
    public CorruptionCrystal(Item.Properties properties) {
        super(properties);
    }

    public static void tick(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (!player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (stack.is(InitItems.CorruptionCrystal_)) {
                    player.getAttributes().addTransientAttributeModifiers(CorruptionCrystal.attributeModifierMultimap());
                    break;
                }
                player.getAttributes().removeAttributeModifiers(CorruptionCrystal.attributeModifierMultimap());
            }
        }
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> attributeModifierMultimap() {
        HashMultimap modifiers = HashMultimap.create();
        modifiers.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.CorruptionCrystal_.asItem().getDescriptionId())), 6.0, AttributeModifier.Operation.ADD_VALUE));
        modifiers.put(AttReg.shadow_shield, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.CorruptionCrystal_.asItem().getDescriptionId())), 6.0, AttributeModifier.Operation.ADD_VALUE));
        modifiers.put(AttReg.fortune, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.CorruptionCrystal_.asItem().getDescriptionId())), 1.0, AttributeModifier.Operation.ADD_VALUE));
        modifiers.put(AttReg.looting, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.CorruptionCrystal_.asItem().getDescriptionId())), 1.0, AttributeModifier.Operation.ADD_VALUE));
        return modifiers;
    }

    @Override
    @Nullable
    public Multimap<Holder<Attribute>, AttributeModifier> muAttribute(Player player, ItemStack stack) {
        return CorruptionCrystal.attributeModifierMultimap();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        if (flag.hasShiftDown()) {
            tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.corruption_crystal.string.2").withStyle(ChatFormatting.ITALIC).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
            tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.corruption_crystal.string.3").withStyle(ChatFormatting.ITALIC).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
            tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.corruption_crystal.string.4").withStyle(ChatFormatting.ITALIC).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2140513587))));
        } else {
            tooltipAdder.accept((Component)Component.translatable((String)"options.key.hold").append((Component)Component.translatable((String)"key.keyboard.left.shift")).withStyle(ChatFormatting.GOLD));
        }
    }

    @Override
    public int color(ItemStack stack) {
        return Light.ARGB.color(255, 255, 0, 0);
    }
}

