/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.chest_item.items.iron;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.chest_item.event.activated.ci.ItemStackTickEvent;
import com.ytgld.chest_item.items.AttReg;
import com.ytgld.chest_item.items.InitItems;
import com.ytgld.chest_item.items.ItemBase;
import com.ytgld.chest_item.other.ChestInventory;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import org.jetbrains.annotations.Nullable;

public class IronCube
extends ItemBase {
    public IronCube(Item.Properties properties) {
        super(properties);
    }

    public static void ItemStackTickEvent(ItemStackTickEvent event) {
        ChestInventory chestInventory = event.chestInventory;
        Player player = event.player;
        if (player != null && !player.level().isClientSide()) {
            for (int i = 0; i < chestInventory.getContainerSize(); ++i) {
                ItemStack stack = chestInventory.getItem(i);
                if (stack.is(InitItems.IronCube_)) {
                    player.getAttributes().addTransientAttributeModifiers(IronCube.attributeModifierMultimap(player));
                    break;
                }
                player.getAttributes().removeAttributeModifiers(IronCube.attributeModifierMultimap(player));
            }
        }
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> attributeModifierMultimap(Player player) {
        HashMultimap modifiers = HashMultimap.create();
        modifiers.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.IronCube_.asItem().getDescriptionId())), -0.45, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        float lv = player.getHealth() / player.getMaxHealth();
        int now = (int)(100.0f - (lv *= 100.0f));
        float apply = 0.01f * (float)now;
        modifiers.put(AttReg.instability, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.IronCube_.asItem().getDescriptionId())), (double)(-0.1f * (apply += 1.0f)), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        modifiers.put(AttReg.instability_low, (Object)new AttributeModifier(ResourceLocation.parse((String)("chest_item" + InitItems.IronCube_.asItem().getDescriptionId())), (double)(-0.15f * apply), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return modifiers;
    }

    @Override
    @Nullable
    public Multimap<Holder<Attribute>, AttributeModifier> muAttribute(Player player, ItemStack stack) {
        return IronCube.attributeModifierMultimap(player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.iron_cube.string.1").withStyle(ChatFormatting.GOLD));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.iron_cube.string.2").withStyle(ChatFormatting.GOLD));
        tooltipAdder.accept((Component)Component.translatable((String)"item.chest_item.iron_cube.string.3").withStyle(ChatFormatting.GOLD));
    }
}

