/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.crowmap.craftful;

import agency.highlysuspect.crowmap.craftful.CrowmapMcOpts;
import agency.highlysuspect.crowmap.craftful.api.TickableMap;
import agency.highlysuspect.crowmap.craftful.compat.PackagesTicker;
import agency.highlysuspect.crowmap.craftful.compat.YesPackagesTicker;
import agency.highlysuspect.crowmap.craftless.CrowmapBase;
import agency.highlysuspect.quatlib.craftful.QuatlibMc;
import agency.highlysuspect.quatlib.craftless.QuatlibBase;
import agency.highlysuspect.quatlib.craftless.config.ConfigSection;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class CrowmapMc
extends CrowmapBase {
    @Nullable
    protected PackagesTicker packagesCompatTicker;

    @Override
    public void init() {
        super.init();
        QuatlibMc.inst().addServerTicker(this::onServerTick);
        if (QuatlibBase.inst().isModLoaded("packages")) {
            this.packagesCompatTicker = FragilePackagesClassloadGuard.initPackagesCompat();
        }
    }

    @Override
    public ConfigSection visitConfigSchema(ConfigSection root) {
        return CrowmapMcOpts.visit(super.visitConfigSchema(root));
    }

    protected void onServerTick(MinecraftServer server) {
        Iterator levels = server.method_3738().iterator();
        if (!levels.hasNext()) {
            return;
        }
        server.method_16044().method_15396("crowmap");
        class_3218 first = (class_3218)levels.next();
        long time = first.method_8510();
        int interval = (Integer)CrowmapBase.inst().config.get(CrowmapMcOpts.tickContainerInterval);
        if (time % (long)interval != 0L) {
            return;
        }
        this.onLevelTick(first);
        while (levels.hasNext()) {
            this.onLevelTick((class_3218)levels.next());
        }
        server.method_16044().method_15407();
    }

    protected void onLevelTick(class_3218 slevel) {
        for (class_3222 player : slevel.method_18456()) {
            this.onPlayerTick(player);
        }
    }

    protected void onPlayerTick(class_3222 sp) {
        class_1661 inv = sp.method_31548();
        int size = inv.method_5439();
        int selected = inv.field_7545;
        for (int slot = 0; slot < size; ++slot) {
            this.processStack(inv.method_5438(slot), sp, slot == 40 || slot == selected);
        }
    }

    public void processStack(class_1799 stack, class_3222 sp, boolean heldInMainhandOrOffhand) {
        class_9288 icc;
        if (stack.method_7960()) {
            return;
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof TickableMap) {
            TickableMap tm = (TickableMap)class_17922;
            if (!heldInMainhandOrOffhand) {
                tm.crowmap$issueExtraMapTick(stack, sp.method_51469(), (class_1657)sp);
            }
            return;
        }
        if (!((Boolean)CrowmapMc.inst().config.get(CrowmapMcOpts.tickContainers)).booleanValue()) {
            return;
        }
        class_9276 bc = (class_9276)stack.method_57824(class_9334.field_49650);
        if (bc != null) {
            int bundleSize = bc.method_57426();
            for (int i = 0; i < bundleSize; ++i) {
                this.processStack(bc.method_57422(i), sp, false);
            }
        }
        if ((icc = (class_9288)stack.method_57824(class_9334.field_49622)) != null) {
            for (class_1799 iccStack : icc.method_59714()) {
                this.processStack(iccStack, sp, false);
            }
        }
        if (this.packagesCompatTicker != null && ((Boolean)this.config.get(CrowmapMcOpts.packagesCompat)).booleanValue()) {
            this.packagesCompatTicker.processPackage(stack, sp);
        }
    }

    public static CrowmapMc inst() {
        return (CrowmapMc)Objects.requireNonNull(CrowmapBase.INST, "CrowmapMc is null");
    }

    static class FragilePackagesClassloadGuard {
        FragilePackagesClassloadGuard() {
        }

        static PackagesTicker initPackagesCompat() {
            try {
                return new YesPackagesTicker();
            }
            catch (Throwable e) {
                CrowmapBase.inst().failures.context().detail("Failed to initialize Packages compat").cause(e).sneakyReportError();
                return null;
            }
        }
    }
}

