/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.crowmap.craftful;

import agency.highlysuspect.crowmap.craftful.CrowmapMcOpts;
import agency.highlysuspect.crowmap.craftful.api.TickableMap;
import agency.highlysuspect.crowmap.craftful.compat.PackagesTicker;
import agency.highlysuspect.crowmap.craftful.compat.YesPackagesTicker;
import agency.highlysuspect.crowmap.craftless.CrowmapBase;
import agency.highlysuspect.quatlib.craftful.QuatlibMc;
import agency.highlysuspect.quatlib.craftless.QuatlibBase;
import agency.highlysuspect.quatlib.craftless.config.ConfigSection;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ItemContainerContents;
import org.jetbrains.annotations.Nullable;

public abstract class CrowmapMc
extends CrowmapBase {
    @Nullable
    protected PackagesTicker packagesCompatTicker;

    @Override
    public void init() {
        super.init();
        QuatlibMc.inst().addServerTicker(this::onServerTick);
        if (QuatlibBase.inst().isModLoaded("packages")) {
            this.packagesCompatTicker = FragilePackagesClassloadGuard.initPackagesCompat();
        }
    }

    @Override
    public ConfigSection visitConfigSchema(ConfigSection root) {
        return CrowmapMcOpts.visit(super.visitConfigSchema(root));
    }

    protected void onServerTick(MinecraftServer server) {
        Iterator levels = server.getAllLevels().iterator();
        if (!levels.hasNext()) {
            return;
        }
        server.getProfiler().push("crowmap");
        ServerLevel first = (ServerLevel)levels.next();
        long time = first.getGameTime();
        int interval = (Integer)CrowmapBase.inst().config.get(CrowmapMcOpts.tickContainerInterval);
        if (time % (long)interval != 0L) {
            return;
        }
        this.onLevelTick(first);
        while (levels.hasNext()) {
            this.onLevelTick((ServerLevel)levels.next());
        }
        server.getProfiler().pop();
    }

    protected void onLevelTick(ServerLevel slevel) {
        for (ServerPlayer player : slevel.players()) {
            this.onPlayerTick(player);
        }
    }

    protected void onPlayerTick(ServerPlayer sp) {
        Inventory inv = sp.getInventory();
        int size = inv.getContainerSize();
        int selected = inv.selected;
        for (int slot = 0; slot < size; ++slot) {
            this.processStack(inv.getItem(slot), sp, slot == 40 || slot == selected);
        }
    }

    public void processStack(ItemStack stack, ServerPlayer sp, boolean heldInMainhandOrOffhand) {
        ItemContainerContents icc;
        if (stack.isEmpty()) {
            return;
        }
        Item item = stack.getItem();
        if (item instanceof TickableMap) {
            TickableMap tm = (TickableMap)item;
            if (!heldInMainhandOrOffhand) {
                tm.crowmap$issueExtraMapTick(stack, sp.serverLevel(), (Player)sp);
            }
            return;
        }
        if (!((Boolean)CrowmapMc.inst().config.get(CrowmapMcOpts.tickContainers)).booleanValue()) {
            return;
        }
        BundleContents bc = (BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS);
        if (bc != null) {
            int bundleSize = bc.size();
            for (int i = 0; i < bundleSize; ++i) {
                this.processStack(bc.getItemUnsafe(i), sp, false);
            }
        }
        if ((icc = (ItemContainerContents)stack.get(DataComponents.CONTAINER)) != null) {
            for (ItemStack iccStack : icc.nonEmptyItems()) {
                this.processStack(iccStack, sp, false);
            }
        }
        if (this.packagesCompatTicker != null && ((Boolean)this.config.get(CrowmapMcOpts.packagesCompat)).booleanValue()) {
            this.packagesCompatTicker.processPackage(stack, sp);
        }
    }

    public static CrowmapMc inst() {
        return (CrowmapMc)Objects.requireNonNull(CrowmapBase.INST, "CrowmapMc is null");
    }

    static class FragilePackagesClassloadGuard {
        FragilePackagesClassloadGuard() {
        }

        static PackagesTicker initPackagesCompat() {
            try {
                return new YesPackagesTicker();
            }
            catch (Throwable e) {
                CrowmapBase.inst().failures.context().detail("Failed to initialize Packages compat").cause(e).sneakyReportError();
                return null;
            }
        }
    }
}

