/*
 * Decompiled with CFR 0.152.
 */
package draylar.gofish.loot.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import draylar.gofish.loot.biome.BiomePredicate;
import draylar.gofish.loot.biome.BiomeTagPredicate;
import draylar.gofish.registry.GoFishLoot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_181;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_5342;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public record MatchBiomeLootCondition(Optional<BiomeTagPredicate> category, Optional<BiomePredicate> biome) implements class_5341
{
    public static final MapCodec<MatchBiomeLootCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeTagPredicate.CODEC.optionalFieldOf("category").forGetter(MatchBiomeLootCondition::category), (App)BiomePredicate.CODEC.optionalFieldOf("biome").forGetter(MatchBiomeLootCondition::biome)).apply((Applicative)instance, MatchBiomeLootCondition::new));

    public class_5342 method_29325() {
        return GoFishLoot.MATCH_BIOME;
    }

    public boolean test(class_47 lootContext) {
        class_243 origin = (class_243)lootContext.method_65013(class_181.field_24424);
        if (origin != null) {
            class_6880 fisherBiome = lootContext.method_299().method_23753(new class_2338((int)Math.floor(origin.field_1352), (int)Math.floor(origin.field_1351), (int)Math.floor(origin.field_1350)));
            if (this.category.isEmpty() || this.category.get().getValid().isEmpty()) {
                if (this.biome.isPresent() && !this.biome.get().getValid().isEmpty()) {
                    return this.biome.get().test((class_6880<class_1959>)fisherBiome);
                }
            } else {
                return this.category.get().test((class_6880<class_1959>)fisherBiome);
            }
        }
        return false;
    }

    public static class_5341.class_210 builder(class_5321<class_1959> ... biomes) {
        return MatchBiomeLootCondition.builder(Collections.emptyList(), List.of(biomes));
    }

    public static class_5341.class_210 builder(class_6862<class_1959> ... categories) {
        return MatchBiomeLootCondition.builder(Arrays.asList(categories), Collections.emptyList());
    }

    public static class_5341.class_210 builder(List<class_6862<class_1959>> categories, List<class_5321<class_1959>> biomes) {
        ArrayList<String> stringCats = new ArrayList<String>();
        ArrayList<String> stringBiomes = new ArrayList<String>();
        categories.forEach(category -> stringCats.add(category.comp_327().toString()));
        biomes.forEach(biome -> stringBiomes.add(biome.method_29177().toString()));
        return MatchBiomeLootCondition.builder(BiomeTagPredicate.Builder.create().setValidByString(stringCats), BiomePredicate.Builder.create().setValidFromString(stringBiomes));
    }

    public static class_5341.class_210 builder(String category, String biome) {
        return MatchBiomeLootCondition.builder(BiomeTagPredicate.Builder.create().add(category), BiomePredicate.Builder.create().add(biome));
    }

    public static class_5341.class_210 builder(BiomeTagPredicate.Builder categoryBuilder) {
        return MatchBiomeLootCondition.builder(categoryBuilder, BiomePredicate.Builder.create());
    }

    public static class_5341.class_210 builder(BiomePredicate.Builder biomeBuilder) {
        return MatchBiomeLootCondition.builder(BiomeTagPredicate.Builder.create(), biomeBuilder);
    }

    public static class_5341.class_210 builder(BiomeTagPredicate.Builder categoryBuilder, BiomePredicate.Builder biomeBuilder) {
        return () -> new MatchBiomeLootCondition(Optional.of(categoryBuilder.build()), Optional.of(biomeBuilder.build()));
    }
}

