/*
 * Decompiled with CFR 0.152.
 */
package com.bungy.twindlingtweaks.block.custom.cake;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class ModCakeBlock
extends CakeBlock {
    public ModCakeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide) {
            if (ModCakeBlock.eat((LevelAccessor)level, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return ModCakeBlock.eat((LevelAccessor)level, pos, state, player);
    }

    protected static InteractionResult eat(LevelAccessor level, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(false)) {
            return InteractionResult.PASS;
        }
        player.awardStat(Stats.EAT_CAKE_SLICE);
        player.getFoodData().eat(2, 0.1f);
        int bites = (Integer)state.getValue((Property)BITES);
        if (!level.isClientSide()) {
            if (bites < 6) {
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 300, 0));
                level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
            } else {
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 3600, 2));
                level.removeBlock(pos, false);
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
            }
        }
        level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext ptooltipContext, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Component.literal((String)"Make sure to finish your food for a bonus!"));
        super.appendHoverText(pStack, ptooltipContext, pTooltip, pFlag);
    }
}

