/*
 * Decompiled with CFR 0.152.
 */
package com.bungy.twindlingtweaks.block.custom.farmland;

import com.bungy.twindlingtweaks.block.ModBlocks;
import com.bungy.twindlingtweaks.block.entity.custom.farmland.ModFarmlandBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModFarmlandBlock
extends FarmBlock
implements EntityBlock {
    public static final IntegerProperty MOISTURE = BlockStateProperties.MOISTURE;
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public ModFarmlandBlock(BlockBehaviour.Properties properties, @NotNull Block block) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return !this.defaultBlockState().canSurvive((LevelReader)pContext.getLevel(), pContext.getClickedPos()) ? ((Block)ModBlocks.BLUE_DIRT.get()).defaultBlockState() : super.getStateForPlacement(pContext);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter level, BlockPos pos, Direction facing, IPlantable plantable) {
        return true;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pState.canSurvive((LevelReader)pLevel, pPos)) {
            ModFarmlandBlock.turnToDirt(null, pState, (Level)pLevel, pPos);
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity be;
        CropBlock cropBlock;
        int moisture = (Integer)state.getValue((Property)MOISTURE);
        if (!ModFarmlandBlock.isNearWater((LevelReader)level, pos) && !level.isRainingAt(pos.above())) {
            if (moisture > 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(moisture - 1)), 2);
            } else if (!ModFarmlandBlock.shouldMaintainFarmland((BlockGetter)level, pos)) {
                ModFarmlandBlock.turnToDirt(null, state, (Level)level, pos);
            }
        } else if (moisture < 7) {
            level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
        BlockPos above = pos.above();
        BlockState cropState = level.getBlockState(above);
        Block block = cropState.getBlock();
        if (block instanceof CropBlock && !(cropBlock = (CropBlock)block).isMaxAge(cropState) && (be = level.getBlockEntity(pos)) instanceof ModFarmlandBlockEntity) {
            ModFarmlandBlockEntity farmlandBe = (ModFarmlandBlockEntity)be;
            Block lastCrop = farmlandBe.getLastCrop();
            Block currentCrop = cropState.getBlock();
            farmlandBe.setLastCrop(currentCrop);
            float speedMultiplier = 1.2f;
            if (lastCrop != null && lastCrop != currentCrop) {
                speedMultiplier = 1.4f;
            }
            if (random.nextFloat() < 0.25f * speedMultiplier) {
                cropBlock.growCrops((Level)level, above, cropState);
            }
        }
    }

    public static void turnToDirt(@javax.annotation.Nullable Entity pEntity, @NotNull BlockState pState, Level pLevel, BlockPos pPos) {
        BlockState blockstate = ModFarmlandBlock.pushEntitiesUp((BlockState)pState, (BlockState)((Block)ModBlocks.BLUE_DIRT.get()).defaultBlockState(), (LevelAccessor)pLevel, (BlockPos)pPos);
        pLevel.setBlockAndUpdate(pPos, blockstate);
        pLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((Entity)pEntity, (BlockState)blockstate));
    }

    private static boolean shouldMaintainFarmland(BlockGetter pLevel, BlockPos pPos) {
        IPlantable plantable;
        BlockState plant = pLevel.getBlockState(pPos.above());
        BlockState state = pLevel.getBlockState(pPos);
        Block block = plant.getBlock();
        return block instanceof IPlantable && state.canSustainPlant(pLevel, pPos, Direction.UP, plantable = (IPlantable)block);
    }

    private static boolean hasCrops(BlockState state) {
        return state.getBlock() instanceof CropBlock;
    }

    private static boolean isNearWater(LevelReader level, BlockPos pos) {
        for (BlockPos nearby : BlockPos.betweenClosed((BlockPos)pos.offset(-4, 0, -4), (BlockPos)pos.offset(4, 1, 4))) {
            if (!level.getFluidState(nearby).is((Fluid)Fluids.WATER)) continue;
            return true;
        }
        return false;
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!level.isClientSide && ForgeHooks.onFarmlandTrample((Level)level, (BlockPos)pos, (BlockState)((Block)ModBlocks.BLUE_DIRT.get()).defaultBlockState(), (float)fallDistance, (Entity)entity)) {
            ModFarmlandBlock.turnToDirt(entity, state, level, pos);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MOISTURE});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ModFarmlandBlockEntity(pos, state);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext tooltipContext, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Component.literal((String)"Increases crop growth by 25 percent!"));
        super.appendHoverText(pStack, tooltipContext, pTooltip, pFlag);
    }
}

