/*
 * Decompiled with CFR 0.152.
 */
package com.bungy.twindlingtweaks.block.entity.custom.block_entity;

import com.bungy.twindlingtweaks.block.entity.ModBlockEntities;
import com.bungy.twindlingtweaks.recipes.ModRecipeTypes;
import com.bungy.twindlingtweaks.recipes.be_recipes.FiltererRecipe;
import com.bungy.twindlingtweaks.recipes.be_recipes.input.FiltererRecipeInput;
import com.bungy.twindlingtweaks.screen.filterer.FiltererMenu;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class FiltererBlockEntity
extends BlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            FiltererBlockEntity.this.setChanged();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> FiltererBlockEntity.this.progress;
                case 1 -> FiltererBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    FiltererBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    FiltererBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;

    public FiltererBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.FILTERER_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public ContainerData getData() {
        return this.data;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.twindlingtweaks.filterer");
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        if (this.itemHandler.serializeNBT(provider) != null) {
            tag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        }
        tag.putInt("filterer.progress", this.progress);
        super.saveAdditional(tag, provider);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.itemHandler.deserializeNBT(provider, nbt);
        this.progress = nbt.getInt("filterer.progress");
    }

    public void openMenu(ServerPlayer serverPlayer) {
        serverPlayer.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return FiltererBlockEntity.this.getDisplayName();
            }

            public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
                return new FiltererMenu(containerId, inventory, FiltererBlockEntity.this, FiltererBlockEntity.this.data);
            }
        }, buf -> buf.writeBlockPos(this.getBlockPos()));
    }

    public boolean interact(ServerPlayer player) {
        this.openMenu(player);
        return true;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, FiltererBlockEntity pBlockEntity) {
        if (FiltererBlockEntity.hasRecipe(pBlockEntity)) {
            ++pBlockEntity.progress;
            if (pBlockEntity.progress > pBlockEntity.maxProgress) {
                FiltererBlockEntity.craftItem(pBlockEntity);
            }
            FiltererBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        } else if (pBlockEntity.progress != 0) {
            pBlockEntity.resetProgress();
            FiltererBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private Optional<FiltererRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        FiltererRecipeInput input = new FiltererRecipeInput((Container)inventory);
        assert (this.level != null);
        return this.level.getRecipeManager().getRecipeFor((RecipeType)FiltererRecipe.Type.INSTANCE, (RecipeInput)input, this.level).map(RecipeHolder::value);
    }

    private static boolean hasRecipe(FiltererBlockEntity entity) {
        Level level = entity.level;
        SimpleContainer inventory = new SimpleContainer(new ItemStack[]{entity.itemHandler.getStackInSlot(0)});
        FiltererRecipeInput input = new FiltererRecipeInput((Container)inventory);
        assert (level != null);
        Optional<FiltererRecipe> match = level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.FILTERING.get(), (RecipeInput)input, level).map(RecipeHolder::value);
        return match.isPresent() && FiltererBlockEntity.canInsertAmountIntoOutputSlot(entity.itemHandler) && FiltererBlockEntity.canInsertItemIntoOutputSlot(entity.itemHandler, match.get().getResultItem((HolderLookup.Provider)level.registryAccess()));
    }

    private static void craftItem(FiltererBlockEntity entity) {
        Level level = entity.level;
        SimpleContainer inventory = new SimpleContainer(new ItemStack[]{entity.itemHandler.getStackInSlot(0)});
        FiltererRecipeInput input = new FiltererRecipeInput((Container)inventory);
        Optional<FiltererRecipe> match = level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.FILTERING.get(), (RecipeInput)input, level).map(RecipeHolder::value);
        if (match.isPresent()) {
            entity.itemHandler.extractItem(0, 1, false);
            entity.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)match.get().getResultItem((HolderLookup.Provider)level.registryAccess()).getItem(), entity.itemHandler.getStackInSlot(1).getCount() + 1));
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static boolean canInsertItemIntoOutputSlot(ItemStackHandler handler, ItemStack output) {
        return handler.getStackInSlot(1).isEmpty() || handler.getStackInSlot(1).getItem() == output.getItem();
    }

    private static boolean canInsertAmountIntoOutputSlot(ItemStackHandler handler) {
        return handler.getStackInSlot(1).getCount() < handler.getStackInSlot(1).getMaxStackSize();
    }
}

