/*
 * Decompiled with CFR 0.152.
 */
package com.bungy.twindlingtweaks.block.entity.custom.block_entity;

import com.bungy.twindlingtweaks.block.entity.ModBlockEntities;
import com.bungy.twindlingtweaks.recipes.ModRecipeTypes;
import com.bungy.twindlingtweaks.recipes.be_recipes.ObsidianForgerRecipe;
import com.bungy.twindlingtweaks.recipes.be_recipes.input.ObsidianForgerRecipeInput;
import com.bungy.twindlingtweaks.screen.obsidian_forger.ObsidianForgerMenu;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ObsidianForgerBlockEntity
extends BlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            ObsidianForgerBlockEntity.this.setChanged();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return ObsidianForgerBlockEntity.this.progress;
                }
                case 1: {
                    return ObsidianForgerBlockEntity.this.maxProgress;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    ObsidianForgerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    ObsidianForgerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 3;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;

    public ObsidianForgerBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.OBSIDIAN_FORGER_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public ContainerData getData() {
        return this.data;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        if (this.itemHandler.serializeNBT(provider) != null) {
            tag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        }
        tag.putInt("obsidian_forger.progress", this.progress);
        super.saveAdditional(tag, provider);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.twindlingtweaks.obsidian_forger");
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.itemHandler.deserializeNBT(provider, nbt);
        this.progress = nbt.getInt("obsidian_forger.progress");
    }

    public void openMenu(ServerPlayer serverPlayer) {
        serverPlayer.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return ObsidianForgerBlockEntity.this.getDisplayName();
            }

            public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
                return new ObsidianForgerMenu(containerId, inventory, ObsidianForgerBlockEntity.this, ObsidianForgerBlockEntity.this.data);
            }
        }, buf -> buf.writeBlockPos(this.getBlockPos()));
    }

    public boolean interact(ServerPlayer player) {
        this.openMenu(player);
        return true;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, ObsidianForgerBlockEntity pBlockEntity) {
        if (ObsidianForgerBlockEntity.hasRecipe(pBlockEntity)) {
            ++pBlockEntity.progress;
            ObsidianForgerBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (pBlockEntity.progress > pBlockEntity.maxProgress) {
                ObsidianForgerBlockEntity.craftItem(pBlockEntity);
            }
        } else {
            pBlockEntity.resetProgress();
            ObsidianForgerBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private static boolean hasRecipe(ObsidianForgerBlockEntity entity) {
        Level level = entity.level;
        SimpleContainer inventory = new SimpleContainer(new ItemStack[]{entity.itemHandler.getStackInSlot(0), entity.itemHandler.getStackInSlot(1), entity.itemHandler.getStackInSlot(2)});
        ObsidianForgerRecipeInput input = new ObsidianForgerRecipeInput((Container)inventory);
        assert (level != null);
        Optional<ObsidianForgerRecipe> match = level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.FORGING.get(), (RecipeInput)input, level).map(RecipeHolder::value);
        return match.isPresent() && ObsidianForgerBlockEntity.canInsertAmountIntoOutputSlot(entity.itemHandler) && ObsidianForgerBlockEntity.canInsertItemIntoOutputSlot(entity.itemHandler, match.get().getResultItem((HolderLookup.Provider)level.registryAccess()));
    }

    private static void craftItem(ObsidianForgerBlockEntity entity) {
        ItemStack hammer;
        Level level = entity.level;
        SimpleContainer inventory = new SimpleContainer(new ItemStack[]{entity.itemHandler.getStackInSlot(0), entity.itemHandler.getStackInSlot(1), entity.itemHandler.getStackInSlot(2)});
        ObsidianForgerRecipeInput input = new ObsidianForgerRecipeInput((Container)inventory);
        assert (level != null);
        Optional<ObsidianForgerRecipe> match = level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.FORGING.get(), (RecipeInput)input, level).map(RecipeHolder::value);
        if (match.isPresent() && (hammer = entity.itemHandler.getStackInSlot(0)).isDamageableItem()) {
            hammer.setDamageValue(hammer.getDamageValue() + 80);
            if (hammer.getDamageValue() >= hammer.getMaxDamage()) {
                hammer.shrink(1);
            }
            entity.itemHandler.extractItem(1, 1, false);
            entity.itemHandler.extractItem(2, 1, false);
            entity.itemHandler.setStackInSlot(3, new ItemStack((ItemLike)match.get().getResultItem((HolderLookup.Provider)level.registryAccess()).getItem(), entity.itemHandler.getStackInSlot(3).getCount() + 1));
            entity.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static boolean canInsertItemIntoOutputSlot(ItemStackHandler handler, ItemStack output) {
        return handler.getStackInSlot(3).isEmpty() || handler.getStackInSlot(3).getItem() == output.getItem();
    }

    private static boolean canInsertAmountIntoOutputSlot(ItemStackHandler handler) {
        return handler.getStackInSlot(3).getCount() < handler.getStackInSlot(3).getMaxStackSize();
    }
}

