/*
 * Decompiled with CFR 0.152.
 */
package com.bungy.twindlingtweaks.block.entity.custom.special_block_entity;

import com.bungy.twindlingtweaks.block.entity.ModBlockEntities;
import com.bungy.twindlingtweaks.recipes.be_recipes.PasteurizerRecipe;
import com.bungy.twindlingtweaks.recipes.be_recipes.input.PasteurizerRecipeInput;
import com.bungy.twindlingtweaks.screen.pasteurizer.PasteurizerMenu;
import com.bungy.twindlingtweaks.util.block_entity_util.PasteurizerEffectMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class PasteurizerBlockEntity
extends BlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            PasteurizerBlockEntity.this.setChanged();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return PasteurizerBlockEntity.this.progress;
                }
                case 1: {
                    return PasteurizerBlockEntity.this.maxProgress;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    PasteurizerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    PasteurizerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;

    public PasteurizerBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.PASTEURIZER_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.twindlingtweaks.pasteurizer");
    }

    public ContainerData getData() {
        return this.data;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        if (this.itemHandler.serializeNBT(provider) != null) {
            tag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        }
        tag.putInt("pasteurizer.progress", this.progress);
        super.saveAdditional(tag, provider);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.itemHandler.deserializeNBT(provider, nbt);
        this.progress = nbt.getInt("pasteurizer.progress");
    }

    public void openMenu(ServerPlayer serverPlayer) {
        serverPlayer.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return PasteurizerBlockEntity.this.getDisplayName();
            }

            public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
                return new PasteurizerMenu(containerId, inventory, PasteurizerBlockEntity.this, PasteurizerBlockEntity.this.data);
            }
        }, buf -> buf.writeBlockPos(this.getBlockPos()));
    }

    public boolean interact(ServerPlayer player) {
        this.openMenu(player);
        return true;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, PasteurizerBlockEntity pBlockEntity) {
        if (PasteurizerBlockEntity.hasRecipe(pBlockEntity)) {
            ++pBlockEntity.progress;
            PasteurizerBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (pBlockEntity.progress > pBlockEntity.maxProgress) {
                PasteurizerBlockEntity.craftItem(pBlockEntity);
            }
        } else {
            pBlockEntity.resetProgress();
            PasteurizerBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private Optional<PasteurizerRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        PasteurizerRecipeInput input = new PasteurizerRecipeInput((Container)inventory);
        assert (this.level != null);
        return this.level.getRecipeManager().getRecipeFor((RecipeType)PasteurizerRecipe.Type.INSTANCE, (RecipeInput)input, this.level).map(RecipeHolder::value);
    }

    private static boolean hasRecipe(PasteurizerBlockEntity entity) {
        Optional<Item> effectBased;
        Optional<PasteurizerRecipe> recipe = entity.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        Level level = entity.level;
        assert (level != null);
        Player nearestPlayer = level.getNearestPlayer((double)entity.worldPosition.getX(), (double)entity.worldPosition.getY(), (double)entity.worldPosition.getZ(), 5.0, false);
        if (nearestPlayer != null && (effectBased = entity.getEffectBasedResult(nearestPlayer)).isPresent()) {
            ItemStack result = new ItemStack((ItemLike)effectBased.get());
            return entity.canInsertAmountIntoOutputSlot(result.getCount()) && entity.canInsertItemIntoOutputSlot(result.getItem());
        }
        ItemStack result = recipe.get().getResultItem((HolderLookup.Provider)Objects.requireNonNull(entity.getLevel()).registryAccess());
        return entity.canInsertAmountIntoOutputSlot(result.getCount()) && entity.canInsertItemIntoOutputSlot(result.getItem());
    }

    private static void craftItem(PasteurizerBlockEntity entity) {
        Optional<Item> effectBased;
        Optional<PasteurizerRecipe> recipe = entity.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return;
        }
        ItemStack input = entity.itemHandler.getStackInSlot(0);
        ItemStack resultStack = input.copy();
        Player nearestPlayer = entity.level.getNearestPlayer((double)entity.worldPosition.getX(), (double)entity.worldPosition.getY(), (double)entity.worldPosition.getZ(), 5.0, false);
        if (nearestPlayer != null && (effectBased = entity.getEffectBasedResult(nearestPlayer)).isPresent()) {
            resultStack = new ItemStack((ItemLike)effectBased.get(), 1);
        }
        entity.itemHandler.extractItem(0, 1, false);
        entity.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)resultStack.getItem(), entity.itemHandler.getStackInSlot(1).getCount() + resultStack.getCount()));
    }

    private Optional<Item> getEffectBasedResult(Player player) {
        List<Holder> matching = player.getActiveEffects().stream().map(MobEffectInstance::getEffect).filter(PasteurizerEffectMap.EFFECT_ITEM_MAP::containsKey).toList();
        if (matching.size() == 1) {
            return Optional.of(PasteurizerEffectMap.EFFECT_ITEM_MAP.get(matching.get(0)));
        }
        return Optional.empty();
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(1).isEmpty() || this.itemHandler.getStackInSlot(1).is(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(1).getCount() + count <= this.itemHandler.getStackInSlot(1).getMaxStackSize();
    }
}

