/*
 * Decompiled with CFR 0.152.
 */
package com.bungy.twindlingtweaks.datagen;

import com.bungy.twindlingtweaks.block.ModBlocks;
import com.bungy.twindlingtweaks.block.custom.bush.BlueberryBushBlock;
import com.bungy.twindlingtweaks.block.custom.crops.BroccoliPlantBlock;
import com.bungy.twindlingtweaks.block.custom.crops.CornPlantBlock;
import com.bungy.twindlingtweaks.block.custom.crops.CucumberPlantBlock;
import com.bungy.twindlingtweaks.block.custom.crops.LettucePlantBlock;
import com.bungy.twindlingtweaks.block.custom.crops.OrangePlantBlock;
import com.bungy.twindlingtweaks.block.custom.crops.TomatoPlantBlock;
import java.util.function.Function;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockStateProvider
extends BlockStateProvider {
    private final PackOutput packOutput;

    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "twindlingtweaks", exFileHelper);
        this.packOutput = output;
    }

    protected void registerStatesAndModels() {
        this.blockWithItem(ModBlocks.CATALPA_PLANKS);
        this.blockWithItem(ModBlocks.RED_MAPLE_PLANKS);
        this.blockWithItem(ModBlocks.ALLUMINITE_BLOCK);
        this.blockWithItem(ModBlocks.RAW_ALLUMINITE_BLOCK);
        this.blockWithItem(ModBlocks.LUMINIUM_BLOCK);
        this.blockWithItem(ModBlocks.RAW_LUMINIUM_BLOCK);
        this.blockWithItem(ModBlocks.MUD_BLOCK);
        this.blockWithItem(ModBlocks.DRIED_MUD_BLOCK);
        this.blockWithItem(ModBlocks.COMPRESSED_MUD_BLOCK);
        this.blockWithItem(ModBlocks.BLUE_DIRT);
        this.blockWithItem(ModBlocks.YELLOW_DIRT);
        this.blockWithItem(ModBlocks.RED_DIRT);
        this.blockWithItem(ModBlocks.ALLUMIN_LUMINIUM_DIRT);
        this.blockWithItem(ModBlocks.SUGAR_BLOCK);
        this.blockWithItem(ModBlocks.UNFILTERED_SUGAR_BLOCK);
        this.blockWithItem(ModBlocks.REINFORCED_OBSIDIAN);
        this.dirtPathBlock((Block)ModBlocks.BLUE_DIRT_PATH.get());
        this.dirtPathBlock((Block)ModBlocks.YELLOW_DIRT_PATH.get());
        this.dirtPathBlock((Block)ModBlocks.RED_DIRT_PATH.get());
        this.dirtPathBlock((Block)ModBlocks.ALLUMIN_LUMINIUM_DIRT_PATH.get());
        this.dirtPathBlock((Block)ModBlocks.COARSE_DIRT_PATH.get());
        this.dirtPathBlock((Block)ModBlocks.ROOTED_DIRT_PATH.get());
        this.dirtPathBlock((Block)ModBlocks.SOUL_SAND_PATH.get());
        this.dirtPathBlock((Block)ModBlocks.SOUL_SOIL_PATH.get());
        this.blockWithItem(ModBlocks.ALLUMINITE_ORE);
        this.blockWithItem(ModBlocks.DEEPSLATE_ALLUMINITE_ORE);
        this.blockWithItem(ModBlocks.LUMINIUM_ORE);
        this.blockWithItem(ModBlocks.DEEPSLATE_LUMINIUM_ORE);
        this.blockWithItem(ModBlocks.MUD_ORE);
        this.blockWithItem(ModBlocks.DEEPSLATE_MUD_ORE);
        this.blockWithItem(ModBlocks.SUGAR_ORE);
        this.blockWithItem(ModBlocks.DEEPSLATE_SUGAR_ORE);
        this.blockWithItem(ModBlocks.SALT_ORE);
        this.blockWithItem(ModBlocks.DEEPSLATE_SALT_ORE);
        this.blockWithItem(ModBlocks.OBSIDIAN_FORGER);
        this.cubeWithCustomSides((Block)ModBlocks.FILTERER.get(), this.modLoc("block/filterer_up"), this.modLoc("block/catalpa_planks"), this.modLoc("block/filterer_north"), this.modLoc("block/filterer_south"), this.modLoc("block/filterer_west"), this.modLoc("block/filterer_east"), this.modLoc("block/filterer_up"));
        this.cubeWithCustomSides((Block)ModBlocks.CRUSHER.get(), this.modLoc("block/crusher_up"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/iron_block"), this.modLoc("block/crusher_north"), this.modLoc("block/crusher_south"), this.modLoc("block/crusher_west"), this.modLoc("block/crusher_east"), this.modLoc("block/crusher_up"));
        this.cubeWithCustomSides((Block)ModBlocks.PASTEURIZER.get(), this.modLoc("block/pasteurizer_up"), this.modLoc("block/red_maple_planks"), this.modLoc("block/pasteurizer_north"), this.modLoc("block/pasteurizer_south"), this.modLoc("block/pasteurizer_west"), this.modLoc("block/pasteurizer_east"), this.modLoc("block/pasteurizer_up"));
        this.stairsBlock((StairBlock)ModBlocks.CATALPA_STAIRS.get(), this.blockTexture((Block)ModBlocks.CATALPA_PLANKS.get()));
        this.slabBlock((SlabBlock)ModBlocks.CATALPA_SLAB.get(), this.blockTexture((Block)ModBlocks.CATALPA_PLANKS.get()), this.blockTexture((Block)ModBlocks.CATALPA_PLANKS.get()));
        this.stairsBlock((StairBlock)ModBlocks.RED_MAPLE_STAIRS.get(), this.blockTexture((Block)ModBlocks.RED_MAPLE_PLANKS.get()));
        this.slabBlock((SlabBlock)ModBlocks.RED_MAPLE_SLAB.get(), this.blockTexture((Block)ModBlocks.RED_MAPLE_PLANKS.get()), this.blockTexture((Block)ModBlocks.RED_MAPLE_PLANKS.get()));
        this.buttonBlock((ButtonBlock)ModBlocks.CATALPA_BUTTON.get(), this.blockTexture((Block)ModBlocks.CATALPA_PLANKS.get()));
        this.pressurePlateBlock((PressurePlateBlock)ModBlocks.CATALPA_PRESSURE_PLATE.get(), this.blockTexture((Block)ModBlocks.CATALPA_PLANKS.get()));
        this.buttonBlock((ButtonBlock)ModBlocks.RED_MAPLE_BUTTON.get(), this.blockTexture((Block)ModBlocks.RED_MAPLE_PLANKS.get()));
        this.pressurePlateBlock((PressurePlateBlock)ModBlocks.RED_MAPLE_PRESSURE_PLATE.get(), this.blockTexture((Block)ModBlocks.RED_MAPLE_PLANKS.get()));
        this.fenceBlock((FenceBlock)ModBlocks.CATALPA_FENCE.get(), this.blockTexture((Block)ModBlocks.CATALPA_PLANKS.get()));
        this.fenceGateBlock((FenceGateBlock)ModBlocks.CATALPA_FENCE_GATE.get(), this.blockTexture((Block)ModBlocks.CATALPA_PLANKS.get()));
        this.fenceBlock((FenceBlock)ModBlocks.RED_MAPLE_FENCE.get(), this.blockTexture((Block)ModBlocks.RED_MAPLE_PLANKS.get()));
        this.fenceGateBlock((FenceGateBlock)ModBlocks.RED_MAPLE_FENCE_GATE.get(), this.blockTexture((Block)ModBlocks.RED_MAPLE_PLANKS.get()));
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.CATALPA_DOOR.get(), this.modLoc("block/catalpa_door_bottom"), this.modLoc("block/catalpa_door_top"), "cutout");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)ModBlocks.CATALPA_TRAPDOOR.get(), this.modLoc("block/catalpa_trapdoor"), true, "cutout");
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.MUD_DOOR.get(), this.modLoc("block/mud_door_bottom"), this.modLoc("block/mud_door_top"), "cutout");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)ModBlocks.MUD_TRAPDOOR.get(), this.modLoc("block/mud_trapdoor"), true, "cutout");
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.RED_MAPLE_DOOR.get(), this.modLoc("block/red_maple_door_bottom"), this.modLoc("block/red_maple_door_top"), "cutout");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)ModBlocks.RED_MAPLE_TRAPDOOR.get(), this.modLoc("block/red_maple_trapdoor"), true, "cutout");
        this.logBlock((RotatedPillarBlock)ModBlocks.CATALPA_LOG.get());
        this.axisBlock((RotatedPillarBlock)ModBlocks.CATALPA_WOOD.get(), this.blockTexture((Block)ModBlocks.CATALPA_LOG.get()), this.blockTexture((Block)ModBlocks.CATALPA_LOG.get()));
        this.logBlock((RotatedPillarBlock)ModBlocks.STRIPPED_CATALPA_LOG.get());
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRIPPED_CATALPA_WOOD.get(), this.blockTexture((Block)ModBlocks.STRIPPED_CATALPA_LOG.get()), this.blockTexture((Block)ModBlocks.STRIPPED_CATALPA_LOG.get()));
        this.logBlock((RotatedPillarBlock)ModBlocks.RED_MAPLE_LOG.get());
        this.axisBlock((RotatedPillarBlock)ModBlocks.RED_MAPLE_WOOD.get(), this.blockTexture((Block)ModBlocks.RED_MAPLE_LOG.get()), this.blockTexture((Block)ModBlocks.RED_MAPLE_LOG.get()));
        this.logBlock((RotatedPillarBlock)ModBlocks.STRIPPED_RED_MAPLE_LOG.get());
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRIPPED_RED_MAPLE_WOOD.get(), this.blockTexture((Block)ModBlocks.STRIPPED_RED_MAPLE_LOG.get()), this.blockTexture((Block)ModBlocks.STRIPPED_RED_MAPLE_LOG.get()));
        this.blockItem(ModBlocks.CATALPA_LOG);
        this.blockItem(ModBlocks.CATALPA_WOOD);
        this.blockItem(ModBlocks.STRIPPED_CATALPA_LOG);
        this.blockItem(ModBlocks.STRIPPED_CATALPA_WOOD);
        this.leavesBlock(ModBlocks.CATALPA_LEAVES);
        this.blockItem(ModBlocks.RED_MAPLE_LOG);
        this.blockItem(ModBlocks.RED_MAPLE_WOOD);
        this.blockItem(ModBlocks.STRIPPED_RED_MAPLE_LOG);
        this.blockItem(ModBlocks.STRIPPED_RED_MAPLE_WOOD);
        this.leavesBlock(ModBlocks.RED_MAPLE_LEAVES);
        this.farmlandBlock((Block)ModBlocks.SPEEDY_FARMLAND.get(), this.modLoc("block/speedy_farmland"), this.modLoc("block/speedy_farmland_moist"), this.modLoc("block/blue_dirt"));
        this.farmlandBlock((Block)ModBlocks.FLASH_FARMLAND.get(), this.modLoc("block/flash_farmland"), this.modLoc("block/flash_farmland_moist"), this.modLoc("block/yellow_dirt"));
        this.farmlandBlock((Block)ModBlocks.FIERY_FARMLAND.get(), this.modLoc("block/fiery_farmland"), this.modLoc("block/fiery_farmland_moist"), this.modLoc("block/red_dirt"));
        this.farmlandBlock((Block)ModBlocks.TWINDLING_TWEAKS_FARMLAND.get(), this.modLoc("block/twindling_tweaks_farmland"), this.modLoc("block/twindling_tweaks_farmland_moist"), this.modLoc("block/combined_dirt"));
        this.cakeBlock((Block)ModBlocks.GOAT_CAKE.get(), "goat_cake");
        this.signBlock((StandingSignBlock)ModBlocks.CATALPA_SIGN.get(), (WallSignBlock)ModBlocks.CATALPA_WALL_SIGN.get(), this.blockTexture((Block)ModBlocks.CATALPA_PLANKS.get()));
        this.signBlock((StandingSignBlock)ModBlocks.RED_MAPLE_SIGN.get(), (WallSignBlock)ModBlocks.RED_MAPLE_WALL_SIGN.get(), this.blockTexture((Block)ModBlocks.RED_MAPLE_PLANKS.get()));
        this.hangingSignBlock((Block)ModBlocks.CATALPA_HANGING_SIGN.get(), (Block)ModBlocks.CATALPA_WALL_HANGING_SIGN.get(), this.blockTexture((Block)ModBlocks.CATALPA_PLANKS.get()));
        this.saplingBlock(ModBlocks.CATALPA_SAPLING);
        this.hangingSignBlock((Block)ModBlocks.RED_MAPLE_HANGING_SIGN.get(), (Block)ModBlocks.RED_MAPLE_WALL_HANGING_SIGN.get(), this.blockTexture((Block)ModBlocks.RED_MAPLE_PLANKS.get()));
        this.saplingBlock(ModBlocks.RED_MAPLE_SAPLING);
        this.saplingBlock(ModBlocks.BANANA_SAPLING);
        this.bananaLeavesBlock();
        this.makeBush((SweetBerryBushBlock)ModBlocks.BLUEBERRY_BUSH.get(), "blueberry_bush_stage", "blueberry_bush_stage");
        this.makeBush((SweetBerryBushBlock)ModBlocks.RASPBERRY_BUSH.get(), "raspberry_bush_stage", "raspberry_bush_stage");
        this.makeCucumberCrop((CropBlock)ModBlocks.CUCUMBER_SEEDS_BLOCK.get(), "cucumber_seeds_stage", "cucumber_seeds_stage");
        this.makeTomatoCrop((CropBlock)ModBlocks.TOMATO_SEEDS_BLOCK.get(), "tomato_seeds_stage", "tomato_seeds_stage");
        this.makeLettuceCrop((CropBlock)ModBlocks.LETTUCE_SEEDS_BLOCK.get(), "lettuce_seeds_stage", "lettuce_seeds_stage");
        this.makeOrangeCrop((CropBlock)ModBlocks.ORANGE_SEEDS_BLOCK.get(), "orange_seeds_stage", "orange_seeds_stage");
        this.makeBroccoliCrop((CropBlock)ModBlocks.BROCCOLI_SEEDS_BLOCK.get(), "broccoli_seeds_stage", "broccoli_seeds_stage");
        this.makeCornCrop((CropBlock)ModBlocks.CORN_SEEDS_BLOCK.get(), "corn_seeds_stage", "corn_seeds_stage");
    }

    public void cakeBlock(Block block, String textureBaseName) {
        for (int i = 0; i <= 6; ++i) {
            Object suffix = i == 0 ? "" : "_slice" + i;
            String modelName = this.name(block) + (String)suffix;
            Object parent = i == 0 ? "block/cake" : "block/cake_slice" + i;
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, this.mcLoc((String)parent))).texture("bottom", this.modLoc("block/" + textureBaseName + "_bottom"))).texture("top", this.modLoc("block/" + textureBaseName + "_top"))).texture("side", this.modLoc("block/" + textureBaseName + "_side"))).texture("inside", this.modLoc("block/" + textureBaseName + "_inner"));
        }
        this.getVariantBuilder(block).forAllStates(state -> {
            int bites = (Integer)state.getValue((Property)CakeBlock.BITES);
            ResourceLocation model = this.modLoc("block/" + this.name(block) + (String)(bites == 0 ? "" : "_slice" + bites));
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(model)).build();
        });
    }

    public void farmlandBlock(Block block, ResourceLocation dryTop, ResourceLocation moistTop, ResourceLocation side) {
        ModelBuilder dryModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/template_farmland"))).texture("top", dryTop)).texture("dirt", side)).texture("particle", dryTop);
        ModelBuilder moistModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_moist", this.mcLoc("block/template_farmland"))).texture("top", moistTop)).texture("dirt", side)).texture("particle", moistTop);
        this.getVariantBuilder(block).forAllStates(arg_0 -> ModBlockStateProvider.lambda$farmlandBlock$1((ModelFile)moistModel, (ModelFile)dryModel, arg_0));
    }

    private void bananaLeavesBlock() {
        Block block = (Block)ModBlocks.BANANA_LEAVES.get();
        for (int i = 0; i < 4; ++i) {
            String modelName = "banana_leaves_" + i;
            this.models().cubeAll(modelName, this.modLoc("block/" + modelName));
        }
        this.getVariantBuilder(block).partialState().setModels(ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/banana_leaves_0"))).weight(1).nextModel().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/banana_leaves_1"))).weight(1).nextModel().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/banana_leaves_2"))).weight(1).nextModel().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/banana_leaves_3"))).weight(1).build());
    }

    public void makeCucumberCrop(CropBlock block, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.CucumberStates((BlockState)state, block, modelName, textureName);
        this.getVariantBuilder((Block)block).forAllStates(function);
    }

    private ConfiguredModel[] CucumberStates(BlockState state, CropBlock block, String modelName, String textureName) {
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().crop(modelName + String.valueOf(state.getValue((Property)((CucumberPlantBlock)block).getAgeProperty())), ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)("block/" + textureName + String.valueOf(state.getValue((Property)((CucumberPlantBlock)block).getAgeProperty())))))).renderType("cutout"))};
        return models;
    }

    public void makeTomatoCrop(CropBlock block, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.TomatoStates((BlockState)state, block, modelName, textureName);
        this.getVariantBuilder((Block)block).forAllStates(function);
    }

    private ConfiguredModel[] TomatoStates(BlockState state, CropBlock block, String modelName, String textureName) {
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().crop(modelName + String.valueOf(state.getValue((Property)((TomatoPlantBlock)block).getAgeProperty())), ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)("block/" + textureName + String.valueOf(state.getValue((Property)((TomatoPlantBlock)block).getAgeProperty())))))).renderType("cutout"))};
        return models;
    }

    public void makeLettuceCrop(CropBlock block, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.LettuceStates((BlockState)state, block, modelName, textureName);
        this.getVariantBuilder((Block)block).forAllStates(function);
    }

    private ConfiguredModel[] LettuceStates(BlockState state, CropBlock block, String modelName, String textureName) {
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().crop(modelName + String.valueOf(state.getValue((Property)((LettucePlantBlock)block).getAgeProperty())), ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)("block/" + textureName + String.valueOf(state.getValue((Property)((LettucePlantBlock)block).getAgeProperty())))))).renderType("cutout"))};
        return models;
    }

    public void makeOrangeCrop(CropBlock block, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.OrangeStates((BlockState)state, block, modelName, textureName);
        this.getVariantBuilder((Block)block).forAllStates(function);
    }

    private ConfiguredModel[] OrangeStates(BlockState state, CropBlock block, String modelName, String textureName) {
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().crop(modelName + String.valueOf(state.getValue((Property)((OrangePlantBlock)block).getAgeProperty())), ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)("block/" + textureName + String.valueOf(state.getValue((Property)((OrangePlantBlock)block).getAgeProperty())))))).renderType("cutout"))};
        return models;
    }

    public void makeBroccoliCrop(CropBlock block, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.BroccoliStates((BlockState)state, block, modelName, textureName);
        this.getVariantBuilder((Block)block).forAllStates(function);
    }

    private ConfiguredModel[] BroccoliStates(BlockState state, CropBlock block, String modelName, String textureName) {
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().crop(modelName + String.valueOf(state.getValue((Property)((BroccoliPlantBlock)block).getAgeProperty())), ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)("block/" + textureName + String.valueOf(state.getValue((Property)((BroccoliPlantBlock)block).getAgeProperty())))))).renderType("cutout"))};
        return models;
    }

    public void makeCornCrop(CropBlock block, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.CornStates((BlockState)state, block, modelName, textureName);
        this.getVariantBuilder((Block)block).forAllStates(function);
    }

    private ConfiguredModel[] CornStates(BlockState state, CropBlock block, String modelName, String textureName) {
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().crop(modelName + String.valueOf(state.getValue((Property)((CornPlantBlock)block).getAgeProperty())), ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)("block/" + textureName + String.valueOf(state.getValue((Property)((CornPlantBlock)block).getAgeProperty())))))).renderType("cutout"))};
        return models;
    }

    public void makeBush(SweetBerryBushBlock block, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.states((BlockState)state, modelName, textureName);
        this.getVariantBuilder((Block)block).forAllStates(function);
    }

    private ConfiguredModel[] states(BlockState state, String modelName, String textureName) {
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().cross(modelName + String.valueOf(state.getValue((Property)BlueberryBushBlock.AGE)), ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)("block/" + textureName + String.valueOf(state.getValue((Property)BlueberryBushBlock.AGE)))))).renderType("cutout"))};
        return models;
    }

    private void cubeWithCustomSides(Block block, ResourceLocation up, ResourceLocation down, ResourceLocation north, ResourceLocation south, ResourceLocation west, ResourceLocation east, ResourceLocation particle) {
        String name = this.key(block).getPath();
        ModelBuilder model = this.models().cube(name, down, up, north, south, west, east);
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        this.simpleBlockItem(block, (ModelFile)model);
    }

    private void dirtPathBlock(Block block) {
        String name = this.key(block).getPath();
        String baseName = name.replace("_path", "");
        ResourceLocation bottomTexture = this.modLoc("block/" + baseName);
        if (baseName.equals("dirt") || baseName.equals("coarse_dirt") || baseName.equals("rooted_dirt") || baseName.equals("soul_sand") || baseName.equals("soul_soil")) {
            bottomTexture = this.mcLoc("block/" + baseName);
        }
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.mcLoc("block/dirt_path"))).texture("top", this.modLoc("block/" + name + "_top"))).texture("side", this.modLoc("block/" + name + "_side"))).texture("bottom", bottomTexture)).texture("particle", bottomTexture);
        this.simpleBlock(block, (ModelFile)model);
    }

    private void saplingBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().cross(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).getPath(), this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name(signBlock), texture);
        this.hangingSignBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ModelFile sign) {
        this.simpleBlock(signBlock, sign);
        this.simpleBlock(wallSignBlock, sign);
    }

    private String name(Block block) {
        return this.key(block).getPath();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    private void leavesBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).getPath(), ResourceLocation.parse((String)"minecraft:block/leaves"), "all", this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    private void blockItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockItem((Block)blockRegistryObject.get(), (ModelFile)new ModelFile.UncheckedModelFile("twindlingtweaks:block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).getPath()));
    }

    private void blockWithItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$farmlandBlock$1(ModelFile moistModel, ModelFile dryModel, BlockState state) {
        int moisture = (Integer)state.getValue((Property)FarmBlock.MOISTURE);
        return ConfiguredModel.builder().modelFile(moisture > 0 ? moistModel : dryModel).build();
    }
}

