/*
 * Decompiled with CFR 0.152.
 */
package com.bungy.twindlingtweaks.datagen;

import com.bungy.twindlingtweaks.block.ModBlocks;
import com.bungy.twindlingtweaks.item.ModItems;
import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "twindlingtweaks", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(ModItems.UNSTABLE_ALLUMINITE_INGOT);
        this.simpleItem(ModItems.REINFORCED_ALLUMINITE_INGOT);
        this.simpleItem(ModItems.ALLUMINITE_INGOT);
        this.simpleItem(ModItems.ALLUMINITE_NUGGET);
        this.simpleItem(ModItems.ALLUMINITE_ROD_SHARD);
        this.simpleItem(ModItems.RAW_ALLUMINITE);
        this.simpleItem(ModItems.RAW_LUMINIUM);
        this.simpleItem(ModItems.UNPROCESSED_LUMINIUM_CHUNK);
        this.simpleItem(ModItems.LUMINIUM_CHUNK);
        this.simpleItem(ModItems.LUMINIUM_GEM);
        this.simpleItem(ModItems.REINFORCED_LUMINIUM_GEM);
        this.simpleItem(ModItems.IRON_CHUNKS);
        this.simpleItem(ModItems.DIAMOND_CHUNKS);
        this.simpleItem(ModItems.DIAMOND_POWDER);
        this.simpleItem(ModItems.IRON_POWDER);
        this.simpleItem(ModItems.MUD_BALL);
        this.simpleItem(ModItems.DRIED_MUD_BALL);
        this.simpleItem(ModItems.UNFILTERED_SUGAR);
        this.simpleItem(ModItems.SALT_ROCK);
        this.simpleItem(ModItems.SALT);
        this.simpleItem(ModItems.ORANGE_SEED_POWDER);
        this.simpleItem(ModItems.ORANGE_SEED_MILK);
        this.simpleItem(ModItems.IRON_INFUSED_MILK);
        this.simpleItem(ModItems.DIAMOND_INFUSED_MILK);
        this.simpleItem(ModItems.LUMINIUM_APPLE);
        this.simpleItem(ModItems.SALAD_TOPPINGS);
        this.simpleItem(ModItems.SALAD);
        this.simpleItem(ModItems.RANCH_BOTTLE);
        this.simpleItem(ModItems.KETCHUP_BOTTLE);
        this.simpleItem(ModItems.CRUSHED_TOMATO);
        this.simpleItem(ModItems.CRUSHED_TOMATO_BOTTLE);
        this.simpleItem(ModItems.VEGETABLE_OIL);
        this.simpleItem(ModItems.HEARTY_STEW);
        this.simpleItem(ModItems.BOILED_EGG);
        this.simpleItem(ModItems.SALTED_RAW_BEEF);
        this.simpleItem(ModItems.SALTED_RAW_PORKCHOP);
        this.simpleItem(ModItems.SALTED_RAW_CHICKEN);
        this.simpleItem(ModItems.SALTED_RAW_MUTTON);
        this.simpleItem(ModItems.SALTED_RAW_RABBIT);
        this.simpleItem(ModItems.SALTED_RAW_COD);
        this.simpleItem(ModItems.SALTED_RAW_SALMON);
        this.simpleItem(ModItems.BREAD_SLICE);
        this.simpleItem(ModItems.TOAST);
        this.simpleItem(ModItems.GOAT_MILK);
        this.simpleItem(ModItems.GOAT_CHEESE);
        this.simpleItem(ModItems.SLICED_GOAT_CHEESE);
        this.simpleItem(ModItems.GOAT_ICE_CREAM);
        this.simpleItem(ModItems.GOAT_BUTTER);
        this.simpleItem(ModItems.VANILLA_GOAT_YOGURT);
        this.simpleItem(ModItems.CUCUMBER);
        this.simpleItem(ModItems.TOMATO);
        this.simpleItem(ModItems.LETTUCE);
        this.simpleItem(ModItems.ORANGE);
        this.simpleItem(ModItems.BROCCOLI);
        this.simpleItem(ModItems.CORN);
        this.simpleItem(ModItems.CROUTON);
        this.simpleItem(ModItems.STEAK_LETTUCE_SANDWICH);
        this.simpleItem(ModItems.TOASTED_STEAK_LETTUCE_SANDWICH);
        this.simpleItem(ModItems.CHEESE_MEAT_SANDWICH);
        this.simpleItem(ModItems.VEGAN_SANDWICH);
        this.simpleItem(ModItems.MEATY_SANDWICH);
        this.simpleItem(ModItems.POTATO_BITS);
        this.simpleItem(ModItems.SALTED_POTATO_CHIPS);
        this.simpleItem(ModItems.FRIED_EGG);
        this.simpleItem(ModItems.BLUEBERRIES);
        this.simpleItem(ModItems.RASPBERRIES);
        this.simpleItem(ModItems.BANANA);
        this.simpleItem(ModItems.BANANA_SANDWICH);
        this.simpleItem(ModItems.BERRY_BOWL);
        this.simpleItem(ModItems.BERRY_TOAST);
        this.simpleItem(ModItems.SPRING_SALAD_TOPPINGS);
        this.simpleItem(ModItems.SPRING_SALAD);
        this.simpleItem(ModItems.SPECIAL_SALAD_TOPPINGS);
        this.simpleItem(ModItems.SPECIAL_SALAD);
        this.simpleItem(ModItems.CUCUMBER_SEEDS);
        this.simpleItem(ModItems.TOMATO_SEEDS);
        this.simpleItem(ModItems.LETTUCE_SEEDS);
        this.simpleItem(ModItems.BROCCOLI_SEEDS);
        this.simpleItem(ModItems.CORN_SEEDS);
        this.simpleItem(ModItems.ORANGE_SEEDS);
        this.simpleItem(ModItems.GOAT_CAKE_ITEM);
        this.simpleItem(ModItems.MYSTICAL_MUSIC_DISC);
        this.simpleItem(ModItems.MYSTICAL_DISC_FRAGMENT);
        this.simpleItem(ModItems.EMPTY_CHARM);
        this.simpleItem(ModItems.BASIC_DIRT_CHARM);
        this.simpleItem(ModItems.BLUE_DIRT_CHARM);
        this.simpleItem(ModItems.YELLOW_DIRT_CHARM);
        this.simpleItem(ModItems.RED_DIRT_CHARM);
        this.simpleItem(ModItems.ALLUMIN_LUMINIUM_DIRT_CHARM);
        this.simpleItem(ModItems.BASIC_DIRT_PATH_CHARM);
        this.simpleItem(ModItems.ADVANCED_DIRT_PATH_CHARM);
        this.simpleItem(ModItems.BLUE_DIRT_PATH_CHARM);
        this.simpleItem(ModItems.YELLOW_DIRT_PATH_CHARM);
        this.simpleItem(ModItems.RED_DIRT_PATH_CHARM);
        this.simpleItem(ModItems.ALLUMIN_LUMINIUM_DIRT_PATH_CHARM);
        this.simpleBlockItem(ModBlocks.CATALPA_DOOR);
        this.simpleBlockItem(ModBlocks.RED_MAPLE_DOOR);
        this.simpleBlockItem(ModBlocks.MUD_DOOR);
        this.fenceItem(ModBlocks.CATALPA_FENCE, ModBlocks.CATALPA_PLANKS);
        this.buttonItem(ModBlocks.CATALPA_BUTTON, ModBlocks.CATALPA_PLANKS);
        this.fenceItem(ModBlocks.RED_MAPLE_FENCE, ModBlocks.RED_MAPLE_PLANKS);
        this.buttonItem(ModBlocks.RED_MAPLE_BUTTON, ModBlocks.RED_MAPLE_PLANKS);
        this.evenSimplerBlockItem(ModBlocks.CATALPA_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.CATALPA_SLAB);
        this.evenSimplerBlockItem(ModBlocks.CATALPA_PRESSURE_PLATE);
        this.evenSimplerBlockItem(ModBlocks.CATALPA_FENCE_GATE);
        this.evenSimplerBlockItem(ModBlocks.RED_MAPLE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.RED_MAPLE_SLAB);
        this.evenSimplerBlockItem(ModBlocks.RED_MAPLE_PRESSURE_PLATE);
        this.evenSimplerBlockItem(ModBlocks.RED_MAPLE_FENCE_GATE);
        this.trapdoorItem(ModBlocks.CATALPA_TRAPDOOR);
        this.trapdoorItem(ModBlocks.RED_MAPLE_TRAPDOOR);
        this.trapdoorItem(ModBlocks.MUD_TRAPDOOR);
        this.handheldItem(ModItems.ALLUMINITE_SWORD);
        this.handheldItem(ModItems.ALLUMINITE_PICKAXE);
        this.handheldItem(ModItems.ALLUMINITE_AXE);
        this.handheldItem(ModItems.ALLUMINITE_SHOVEL);
        this.handheldItem(ModItems.ALLUMINITE_HOE);
        this.handheldItem(ModItems.OBSIDIAN_SWORD);
        this.handheldItem(ModItems.OBSIDIAN_PICKAXE);
        this.handheldItem(ModItems.OBSIDIAN_AXE);
        this.handheldItem(ModItems.OBSIDIAN_SHOVEL);
        this.handheldItem(ModItems.OBSIDIAN_HOE);
        this.handheldItem(ModItems.OBSIDIAN_HAMMER);
        this.handheldItem(ModItems.STONE_HAMMER);
        this.handheldItem(ModItems.IRON_HAMMER);
        this.handheldItem(ModItems.DIAMOND_HAMMER);
        this.handheldItem(ModItems.ALLUMINITE_ROD);
        this.handheldItem(ModItems.COOKING_KNIFE);
        this.trimmedArmorItem(ModItems.ALLUMINITE_HELMET);
        this.trimmedArmorItem(ModItems.ALLUMINITE_CHESTPLATE);
        this.trimmedArmorItem(ModItems.ALLUMINITE_LEGGINGS);
        this.trimmedArmorItem(ModItems.ALLUMINITE_BOOTS);
        this.trimmedArmorItem(ModItems.OBSIDIAN_HELMET);
        this.trimmedArmorItem(ModItems.OBSIDIAN_CHESTPLATE);
        this.trimmedArmorItem(ModItems.OBSIDIAN_LEGGINGS);
        this.trimmedArmorItem(ModItems.OBSIDIAN_BOOTS);
        this.simpleItem(ModItems.CATALPA_SIGN);
        this.simpleItem(ModItems.CATALPA_HANGING_SIGN);
        this.simpleItem(ModItems.RED_MAPLE_SIGN);
        this.simpleItem(ModItems.RED_MAPLE_HANGING_SIGN);
        this.simpleItem(ModItems.CATALPA_BOAT);
        this.simpleItem(ModItems.CATALPA_CHEST_BOAT);
        this.simpleItem(ModItems.RED_MAPLE_BOAT);
        this.simpleItem(ModItems.RED_MAPLE_CHEST_BOAT);
        this.saplingItem(ModBlocks.CATALPA_SAPLING);
        this.saplingItem(ModBlocks.RED_MAPLE_SAPLING);
        this.saplingItem(ModBlocks.BANANA_SAPLING);
        this.simpleBlockItem(ModBlocks.CATALPA_FLOWERS);
        this.bananaLeavesItem();
        this.evenSimplerBlockItem(ModBlocks.BLUE_DIRT_PATH);
        this.evenSimplerBlockItem(ModBlocks.YELLOW_DIRT_PATH);
        this.evenSimplerBlockItem(ModBlocks.RED_DIRT_PATH);
        this.evenSimplerBlockItem(ModBlocks.ALLUMIN_LUMINIUM_DIRT_PATH);
        this.evenSimplerBlockItem(ModBlocks.COARSE_DIRT_PATH);
        this.evenSimplerBlockItem(ModBlocks.ROOTED_DIRT_PATH);
        this.evenSimplerBlockItem(ModBlocks.SOUL_SAND_PATH);
        this.evenSimplerBlockItem(ModBlocks.SOUL_SOIL_PATH);
        this.evenSimplerBlockItem(ModBlocks.SPEEDY_FARMLAND);
        this.evenSimplerBlockItem(ModBlocks.FLASH_FARMLAND);
        this.evenSimplerBlockItem(ModBlocks.FIERY_FARMLAND);
        this.evenSimplerBlockItem(ModBlocks.TWINDLING_TWEAKS_FARMLAND);
    }

    private void trimmedArmorItem(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "twindlingtweaks";
        Object object = itemRegistryObject.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.forEach((trimMaterial, value) -> {
                float trimValue = value.floatValue();
                String armorType = switch (armorItem.getEquipmentSlot()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = armorItem.toString();
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.location().getPath();
                String currentTrimName = armorItemPath + "_" + trimMaterial.location().getPath() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.parse((String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.parse((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.parse((String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc.getNamespace() + ":item/" + armorItemResLoc.getPath())).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemRegistryObject.getId().getPath(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc.getNamespace() + ":item/" + trimNameResLoc.getPath())).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)("item/" + itemRegistryObject.getId().getPath())));
            });
        }
    }

    private ItemModelBuilder saplingItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)("block/" + item.getId().getPath())));
    }

    private void bananaLeavesItem() {
        this.withExistingParent(ModBlocks.BANANA_LEAVES.getId().getPath(), this.modLoc("block/banana_leaves_0"));
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)("item/" + item.getId().getPath())));
    }

    public void evenSimplerBlockItem(RegistryObject<Block> block) {
        this.withExistingParent("twindlingtweaks:" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath()));
    }

    public void trapdoorItem(RegistryObject<Block> block) {
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath() + "_bottom"));
    }

    public void fenceItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath(), this.mcLoc("block/fence_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).getPath())));
    }

    public void buttonItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath(), this.mcLoc("block/button_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).getPath())));
    }

    public void wallItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).getPath())));
    }

    private ItemModelBuilder handheldItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)("item/" + item.getId().getPath())));
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)("item/" + item.getId().getPath())));
    }

    private ItemModelBuilder simpleBlockItemBlockTexture(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)("block/" + item.getId().getPath())));
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.IRON, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.COPPER, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.GOLD, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.EMERALD, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.LAPIS, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, Float.valueOf(1.0f));
    }
}

