/*
 * Decompiled with CFR 0.152.
 */
package com.bungy.twindlingtweaks.datagen.builder;

import com.bungy.twindlingtweaks.recipes.be_recipes.CrusherRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class CrusherRecipeBuilder {
    private final Ingredient tagInput;
    private final Ingredient itemInput;
    private final Item output;
    private int amount = 1;

    private CrusherRecipeBuilder(Ingredient tagInput, Ingredient itemInput, Item output) {
        this.tagInput = tagInput;
        this.itemInput = itemInput;
        this.output = output;
    }

    public static CrusherRecipeBuilder of(TagKey<Item> tag, Item item, Item output) {
        return new CrusherRecipeBuilder(Ingredient.of(tag), Ingredient.of((ItemLike[])new ItemLike[]{item}), output);
    }

    public static CrusherRecipeBuilder of(TagKey<Item> tag, Item item, ItemStack result) {
        return new CrusherRecipeBuilder(Ingredient.of(tag), Ingredient.of((ItemLike[])new ItemLike[]{item}), result.getItem()).setAmount(result.getCount());
    }

    public CrusherRecipeBuilder setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public void save(RecipeOutput recipeOutput, String name) {
        this.save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)name));
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        NonNullList ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.tagInput, this.itemInput});
        CrusherRecipe recipe = new CrusherRecipe(id, new ItemStack((ItemLike)this.output, this.amount), (NonNullList<Ingredient>)ingredients);
        output.accept(id, (Recipe)recipe, null);
    }
}

