/*
 * Decompiled with CFR 0.152.
 */
package com.bungy.twindlingtweaks.datagen.builder;

import com.bungy.twindlingtweaks.recipes.be_recipes.ObsidianForgerRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class ObsidianForgerRecipeBuilder {
    private final Ingredient tagInput;
    private final Ingredient itemInput1;
    private final Ingredient itemInput2;
    private final Item output;
    private int amount = 1;

    private ObsidianForgerRecipeBuilder(Ingredient tagInput, Ingredient itemInput1, Ingredient itemInput2, Item output) {
        this.tagInput = tagInput;
        this.itemInput1 = itemInput1;
        this.itemInput2 = itemInput2;
        this.output = output;
    }

    public static ObsidianForgerRecipeBuilder of(TagKey<Item> tag, Item item1, Item item2, Item output) {
        return new ObsidianForgerRecipeBuilder(Ingredient.of(tag), Ingredient.of((ItemLike[])new ItemLike[]{item1}), Ingredient.of((ItemLike[])new ItemLike[]{item2}), output);
    }

    public static ObsidianForgerRecipeBuilder of(TagKey<Item> tag, Item item1, Item item2, ItemStack result) {
        return new ObsidianForgerRecipeBuilder(Ingredient.of(tag), Ingredient.of((ItemLike[])new ItemLike[]{item1}), Ingredient.of((ItemLike[])new ItemLike[]{item2}), result.getItem()).setAmount(result.getCount());
    }

    public ObsidianForgerRecipeBuilder setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public void save(RecipeOutput recipeOutput, String name) {
        this.save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)name));
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        NonNullList ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.tagInput, this.itemInput1, this.itemInput2});
        ObsidianForgerRecipe recipe = new ObsidianForgerRecipe(id, new ItemStack((ItemLike)this.output, this.amount), (NonNullList<Ingredient>)ingredients);
        output.accept(id, (Recipe)recipe, null);
    }
}

