/*
 * Decompiled with CFR 0.152.
 */
package com.bungy.twindlingtweaks.datagen.builder;

import com.bungy.twindlingtweaks.recipes.be_recipes.FiltererRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class PasteurizerRecipeBuilder {
    private final Ingredient input;
    private final Item output;
    private int amount = 1;

    private PasteurizerRecipeBuilder(Ingredient input, Item output) {
        this.input = input;
        this.output = output;
    }

    public static PasteurizerRecipeBuilder of(Ingredient input, Item output) {
        return new PasteurizerRecipeBuilder(input, output);
    }

    public static PasteurizerRecipeBuilder of(Item input, Item output) {
        return new PasteurizerRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{input}), output);
    }

    public PasteurizerRecipeBuilder setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public void save(RecipeOutput output) {
        this.save(output, "pasteurizer/" + this.output.toString().toLowerCase());
    }

    public void save(RecipeOutput recipeOutput, String name) {
        this.save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)name));
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation id) {
        NonNullList ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.input});
        FiltererRecipe recipe = new FiltererRecipe(id, new ItemStack((ItemLike)this.output, this.amount), (NonNullList<Ingredient>)ingredients);
        recipeOutput.accept(id, (Recipe)recipe, null);
    }
}

