/*
 * Decompiled with CFR 0.152.
 */
package com.bungy.twindlingtweaks.integration.jei;

import com.bungy.twindlingtweaks.integration.jei.categories.block_entity.CrusherRecipeCategory;
import com.bungy.twindlingtweaks.integration.jei.categories.block_entity.FiltererRecipeCategory;
import com.bungy.twindlingtweaks.integration.jei.categories.block_entity.ObsidianForgerRecipeCategory;
import com.bungy.twindlingtweaks.integration.jei.categories.block_entity.special_block_entity.PasteurizerRecipeCategory;
import com.bungy.twindlingtweaks.integration.jei.recipes.ModJEIRecipes;
import com.bungy.twindlingtweaks.recipes.be_recipes.CrusherRecipe;
import com.bungy.twindlingtweaks.recipes.be_recipes.FiltererRecipe;
import com.bungy.twindlingtweaks.recipes.be_recipes.ObsidianForgerRecipe;
import com.bungy.twindlingtweaks.recipes.be_recipes.PasteurizerRecipe;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

@JeiPlugin
public class JEITwindlingTweaksPlugin
implements IModPlugin {
    public static RecipeType<ObsidianForgerRecipe> FORGING_TYPE = new RecipeType(ObsidianForgerRecipeCategory.UID, ObsidianForgerRecipe.class);
    public static RecipeType<CrusherRecipe> CRUSHING_TYPE = new RecipeType(CrusherRecipeCategory.UID, CrusherRecipe.class);
    public static RecipeType<FiltererRecipe> FILTERING_TYPE = new RecipeType(FiltererRecipeCategory.UID, FiltererRecipe.class);
    public static final RecipeType<PasteurizerRecipe> PASTEURIZING_TYPE = RecipeType.create((String)"twindlingtweaks", (String)"pasteurizing", PasteurizerRecipe.class);

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ObsidianForgerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new FiltererRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrusherRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new PasteurizerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        List forgingHolders = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ObsidianForgerRecipe.Type.INSTANCE);
        List<ObsidianForgerRecipe> recipesForging = forgingHolders.stream().map(RecipeHolder::value).toList();
        registration.addRecipes(FORGING_TYPE, recipesForging);
        List filteringHolders = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)FiltererRecipe.Type.INSTANCE);
        List<FiltererRecipe> recipesFiltering = filteringHolders.stream().map(RecipeHolder::value).toList();
        registration.addRecipes(FILTERING_TYPE, recipesFiltering);
        List crushingHolders = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)CrusherRecipe.Type.INSTANCE);
        List<CrusherRecipe> recipesCrushing = crushingHolders.stream().map(RecipeHolder::value).toList();
        registration.addRecipes(CRUSHING_TYPE, recipesCrushing);
        List pasteurizingHolders = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)PasteurizerRecipe.Type.INSTANCE);
        List<PasteurizerRecipe> recipesPasteurizing = pasteurizingHolders.stream().map(RecipeHolder::value).toList();
        registration.addRecipes(PASTEURIZING_TYPE, recipesPasteurizing);
        registration.addRecipes(PASTEURIZING_TYPE, ModJEIRecipes.getDummyRecipes());
    }
}

