/*
 * Decompiled with CFR 0.152.
 */
package com.bungy.twindlingtweaks.item.custom.boat;

import com.bungy.twindlingtweaks.entity.custom.boat.ModBoatEntity2;
import com.bungy.twindlingtweaks.entity.custom.chest_boat.ModChestBoatEntity2;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ModBoatItem2
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private final ModBoatEntity2.Type type;
    private final boolean hasChest;
    private int burnTime = 0;

    public ModBoatItem2(boolean pHasChest, ModBoatEntity2.Type pType, Item.Properties pProperties, int burnTime) {
        super(pProperties);
        this.hasChest = pHasChest;
        this.type = pType;
        this.burnTime = burnTime;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        BlockHitResult hitresult = ModBoatItem2.getPlayerPOVHitResult((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        Vec3 vec3 = pPlayer.getViewVector(1.0f);
        List list = pLevel.getEntities((Entity)pPlayer, pPlayer.getBoundingBox().expandTowards(vec3.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = pPlayer.getEyePosition();
            for (Entity entity : list) {
                AABB aabb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!aabb.contains(vec31)) continue;
                return InteractionResultHolder.pass((Object)itemstack);
            }
        }
        if (hitresult.getType() == HitResult.Type.BLOCK) {
            Boat boat = this.getBoat(pLevel, (HitResult)hitresult);
            if (boat instanceof ModChestBoatEntity2) {
                ModChestBoatEntity2 chestBoat = (ModChestBoatEntity2)boat;
                chestBoat.setVariant(this.type);
            } else if (boat instanceof ModBoatEntity2) {
                ((ModBoatEntity2)boat).setVariant(this.type);
            }
            boat.setYRot(pPlayer.getYRot());
            if (!pLevel.noCollision((Entity)boat, boat.getBoundingBox())) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (!pLevel.isClientSide) {
                pLevel.addFreshEntity((Entity)boat);
                pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.ENTITY_PLACE, hitresult.getLocation());
                if (!pPlayer.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
            }
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)pLevel.isClientSide());
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    private Boat getBoat(Level p_220017_, HitResult p_220018_) {
        return this.hasChest ? new ModChestBoatEntity2(p_220017_, p_220018_.getLocation().x, p_220018_.getLocation().y, p_220018_.getLocation().z) : new ModBoatEntity2(p_220017_, p_220018_.getLocation().x, p_220018_.getLocation().y, p_220018_.getLocation().z);
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return this.burnTime;
    }
}

