/*
 * Decompiled with CFR 0.152.
 */
package com.bungy.twindlingtweaks.recipes.be_recipes;

import com.bungy.twindlingtweaks.recipes.ModRecipeTypes;
import com.bungy.twindlingtweaks.recipes.ModRecipes;
import com.bungy.twindlingtweaks.recipes.be_recipes.input.FiltererRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class FiltererRecipe
implements Recipe<FiltererRecipeInput> {
    public final ResourceLocation id;
    public final ItemStack output;
    public final NonNullList<Ingredient> recipeItems;

    public FiltererRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(FiltererRecipeInput pInput, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        return ((Ingredient)this.recipeItems.get(0)).test(pInput.getItem(0));
    }

    public ItemStack assemble(FiltererRecipeInput pInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.FILTERING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.FILTERING.get();
    }

    public static class Serializer
    implements RecipeSerializer<FiltererRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)"filtering");
        public static final StreamCodec<RegistryFriendlyByteBuf, List<Ingredient>> INGREDIENT_LIST_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, List<Ingredient>>(){

            public List<Ingredient> decode(RegistryFriendlyByteBuf buf) {
                int size = buf.readVarInt();
                ArrayList<Ingredient> list = new ArrayList<Ingredient>();
                for (int i = 0; i < size; ++i) {
                    list.add((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
                }
                return list;
            }

            public void encode(RegistryFriendlyByteBuf buf, List<Ingredient> value) {
                buf.writeVarInt(value.size());
                for (Ingredient ingredient : value) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ingredient);
                }
            }
        };
        private static final StreamCodec<RegistryFriendlyByteBuf, FiltererRecipe> CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, FiltererRecipe::getId, INGREDIENT_LIST_STREAM_CODEC, FiltererRecipe::getIngredients, (StreamCodec)ItemStack.STREAM_CODEC, FiltererRecipe::getOutput, (id, ingredients, output) -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)ingredients);
            return new FiltererRecipe((ResourceLocation)id, (ItemStack)output, (NonNullList<Ingredient>)nonNullList);
        });

        public MapCodec<FiltererRecipe> codec() {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(FiltererRecipe::getId), (App)Ingredient.CODEC.listOf().fieldOf("ingredients").forGetter(r -> r.getIngredients()), (App)ItemStack.CODEC.fieldOf("output").forGetter(FiltererRecipe::getOutput)).apply((Applicative)instance, (id, ingredientsList, output) -> {
                NonNullList ingredients = NonNullList.create();
                ingredients.addAll((Collection)ingredientsList);
                return new FiltererRecipe((ResourceLocation)id, (ItemStack)output, (NonNullList<Ingredient>)ingredients);
            }));
        }

        public StreamCodec<RegistryFriendlyByteBuf, FiltererRecipe> streamCodec() {
            return CODEC;
        }
    }

    public static class Type
    implements RecipeType<FiltererRecipe> {
        public static final Type INSTANCE = new Type();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)"filtering");

        public String toString() {
            return ID.toString();
        }
    }
}

