/*
 * Decompiled with CFR 0.152.
 */
package com.bungy.twindlingtweaks.recipes.be_recipes;

import com.bungy.twindlingtweaks.recipes.ModRecipeTypes;
import com.bungy.twindlingtweaks.recipes.ModRecipes;
import com.bungy.twindlingtweaks.recipes.be_recipes.input.ObsidianForgerRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ObsidianForgerRecipe
implements Recipe<ObsidianForgerRecipeInput> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;

    public ObsidianForgerRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(ObsidianForgerRecipeInput pInput, Level pLevel) {
        if (pLevel.isClientSide()) {
            return false;
        }
        boolean firstIngredientMatches = ((Ingredient)this.recipeItems.get(0)).test(pInput.getItem(0));
        boolean secondIngredientMatches = ((Ingredient)this.recipeItems.get(1)).test(pInput.getItem(1));
        boolean thirdIngredientMatches = ((Ingredient)this.recipeItems.get(2)).test(pInput.getItem(2));
        return firstIngredientMatches && secondIngredientMatches && thirdIngredientMatches;
    }

    public ItemStack assemble(ObsidianForgerRecipeInput pInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.FORGING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.FORGING.get();
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public static class Serializer
    implements RecipeSerializer<ObsidianForgerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)"forging");
        public static final StreamCodec<RegistryFriendlyByteBuf, List<Ingredient>> INGREDIENT_LIST_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, List<Ingredient>>(){

            public List<Ingredient> decode(RegistryFriendlyByteBuf buf) {
                int size = buf.readVarInt();
                ArrayList<Ingredient> list = new ArrayList<Ingredient>();
                for (int i = 0; i < size; ++i) {
                    list.add((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
                }
                return list;
            }

            public void encode(RegistryFriendlyByteBuf buf, List<Ingredient> value) {
                buf.writeVarInt(value.size());
                for (Ingredient ingredient : value) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ingredient);
                }
            }
        };
        private static final StreamCodec<RegistryFriendlyByteBuf, ObsidianForgerRecipe> CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ObsidianForgerRecipe::getId, INGREDIENT_LIST_STREAM_CODEC, ObsidianForgerRecipe::getIngredients, (StreamCodec)ItemStack.STREAM_CODEC, ObsidianForgerRecipe::getOutput, (id, ingredients, output) -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)ingredients);
            return new ObsidianForgerRecipe((ResourceLocation)id, (ItemStack)output, (NonNullList<Ingredient>)nonNullList);
        });

        public MapCodec<ObsidianForgerRecipe> codec() {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(ObsidianForgerRecipe::getId), (App)Ingredient.CODEC.listOf().fieldOf("ingredients").forGetter(r -> r.getIngredients()), (App)ItemStack.CODEC.fieldOf("output").forGetter(ObsidianForgerRecipe::getOutput)).apply((Applicative)instance, (id, ingredientsList, output) -> {
                NonNullList ingredients = NonNullList.create();
                ingredients.addAll((Collection)ingredientsList);
                return new ObsidianForgerRecipe((ResourceLocation)id, (ItemStack)output, (NonNullList<Ingredient>)ingredients);
            }));
        }

        public StreamCodec<RegistryFriendlyByteBuf, ObsidianForgerRecipe> streamCodec() {
            return CODEC;
        }
    }

    public static class Type
    implements RecipeType<ObsidianForgerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)"forging");

        public String toString() {
            return ID.toString();
        }
    }
}

