/*
 * Decompiled with CFR 0.152.
 */
package com.bungy.twindlingtweaks.util;

import com.bungy.twindlingtweaks.item.ModItems;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="twindlingtweaks", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModCommonEvents {
    @SubscribeEvent
    public static void onGoatMilked(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof Goat)) {
            return;
        }
        Goat goat = (Goat)entity;
        if (event.getItemStack().getItem() != Items.BUCKET) {
            return;
        }
        Level level = event.getLevel();
        Player player = event.getEntity();
        if (!level.isClientSide()) {
            ItemStack goatMilk = new ItemStack((ItemLike)ModItems.GOAT_MILK.get());
            if (!player.isCreative()) {
                event.getItemStack().shrink(1);
            }
            if (!player.getInventory().add(goatMilk)) {
                player.drop(goatMilk, false);
            }
            level.playSound(null, (Entity)goat, SoundEvents.COW_MILK, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
    }
}

