/*
 * Decompiled with CFR 0.152.
 */
package com.bungy.twindlingtweaks.world.feature;

import com.bungy.twindlingtweaks.block.ModBlocks;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.CherryFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.CherryTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> RED_MAPLE_KEY = ModConfiguredFeatures.registerKey("red_maple");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CATALPA_KEY = ModConfiguredFeatures.registerKey("catalpa");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BANANA_KEY = ModConfiguredFeatures.registerKey("banana");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLUEBERRY_BUSH_KEY = ModConfiguredFeatures.registerKey("blueberry_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RASPBERRY_BUSH_KEY = ModConfiguredFeatures.registerKey("raspberry_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_LUMINIUM_ORE_KEY = ModConfiguredFeatures.registerKey("overworld_luminium_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_ALLUMINITE_ORE_KEY = ModConfiguredFeatures.registerKey("overworld_alluminite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_MUD_ORE_KEY = ModConfiguredFeatures.registerKey("overworld_mud_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_SUGAR_ORE_KEY = ModConfiguredFeatures.registerKey("overworld_sugar_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_SALT_ORE_KEY = ModConfiguredFeatures.registerKey("overworld_salt_ore");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceable = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> overworldLuminiumOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceable, (BlockState)((Block)ModBlocks.LUMINIUM_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_LUMINIUM_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldAlluminiteOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceable, (BlockState)((Block)ModBlocks.ALLUMINITE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_ALLUMINITE_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldMudOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceable, (BlockState)((Block)ModBlocks.MUD_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_MUD_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldSugarOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceable, (BlockState)((Block)ModBlocks.SUGAR_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_SUGAR_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldSaltOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceable, (BlockState)((Block)ModBlocks.SALT_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_SALT_ORE.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, OVERWORLD_LUMINIUM_ORE_KEY, Feature.ORE, new OreConfiguration(overworldLuminiumOres, 7));
        ModConfiguredFeatures.register(context, OVERWORLD_ALLUMINITE_ORE_KEY, Feature.ORE, new OreConfiguration(overworldAlluminiteOres, 14));
        ModConfiguredFeatures.register(context, OVERWORLD_MUD_ORE_KEY, Feature.ORE, new OreConfiguration(overworldMudOres, 16));
        ModConfiguredFeatures.register(context, OVERWORLD_SUGAR_ORE_KEY, Feature.ORE, new OreConfiguration(overworldSugarOres, 15));
        ModConfiguredFeatures.register(context, OVERWORLD_SALT_ORE_KEY, Feature.ORE, new OreConfiguration(overworldSaltOres, 12));
        ModConfiguredFeatures.register(context, CATALPA_KEY, Feature.TREE, ModConfiguredFeatures.createCatalpa().build());
        ModConfiguredFeatures.register(context, RED_MAPLE_KEY, Feature.TREE, ModConfiguredFeatures.createRedMaple().build());
        ModConfiguredFeatures.register(context, BANANA_KEY, Feature.TREE, ModConfiguredFeatures.createBanana().build());
        ModConfiguredFeatures.register(context, BLUEBERRY_BUSH_KEY, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ModBlocks.BLUEBERRY_BUSH.get()).defaultBlockState().setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(3))))), List.of(Blocks.GRASS_BLOCK)));
        ModConfiguredFeatures.register(context, RASPBERRY_BUSH_KEY, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ModBlocks.RASPBERRY_BUSH.get()).defaultBlockState().setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(3))))), List.of(Blocks.GRASS_BLOCK)));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createStraightBlobTree(Block pLogBlock, Block pLeavesBlock, int pBaseHeight, int pHeightRandA, int pHeightRandB, int pRadius) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)pLogBlock), (TrunkPlacer)new StraightTrunkPlacer(pBaseHeight, pHeightRandA, pHeightRandB), (BlockStateProvider)BlockStateProvider.simple((Block)pLeavesBlock), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)pRadius), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createCatalpaTree(Block pLogBlock, Block pLeavesBlock, int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)pLogBlock), (TrunkPlacer)new StraightTrunkPlacer(pBaseHeight, pHeightRandA, pHeightRandB), (BlockStateProvider)BlockStateProvider.simple((Block)pLeavesBlock), (FoliagePlacer)new CherryFoliagePlacer((IntProvider)ConstantInt.of((int)4), (IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)5), 0.25f, 0.5f, 0.16666667f, 0.33333334f), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createBasicCherryTree(Block pLogBlock, Block pLeavesBlock) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)pLogBlock), (TrunkPlacer)new CherryTrunkPlacer(7, 1, 0, (IntProvider)new WeightedListInt(SimpleWeightedRandomList.builder().add((Object)ConstantInt.of((int)1), 1).add((Object)ConstantInt.of((int)2), 1).add((Object)ConstantInt.of((int)3), 1).build()), (IntProvider)UniformInt.of((int)2, (int)4), UniformInt.of((int)-4, (int)-3), (IntProvider)UniformInt.of((int)-1, (int)0)), (BlockStateProvider)BlockStateProvider.simple((Block)pLeavesBlock), (FoliagePlacer)new CherryFoliagePlacer((IntProvider)ConstantInt.of((int)4), (IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)5), 0.25f, 0.5f, 0.16666667f, 0.33333334f), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"twindlingtweaks", (String)name));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createCatalpa() {
        return ModConfiguredFeatures.createCatalpaTree((Block)ModBlocks.CATALPA_LOG.get(), (Block)ModBlocks.CATALPA_LEAVES.get(), 4, 3, 0).ignoreVines();
    }

    private static TreeConfiguration.TreeConfigurationBuilder createRedMaple() {
        return ModConfiguredFeatures.createBasicCherryTree((Block)ModBlocks.RED_MAPLE_LOG.get(), (Block)ModBlocks.RED_MAPLE_LEAVES.get()).ignoreVines();
    }

    private static TreeConfiguration.TreeConfigurationBuilder createBanana() {
        return ModConfiguredFeatures.createStraightBlobTree(Blocks.OAK_LOG, (Block)ModBlocks.BANANA_LEAVES.get(), 4, 2, 0, 2).ignoreVines();
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

