/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.main.ModRPGHud;
import net.spellcraftgaming.rpghud.settings.Settings;

public abstract class HudElement {
    public static final int COLOR_RED = 0xC10000;
    public static final int COLOR_PINK = 16738740;
    public static final int COLOR_BROWN = 9127187;
    public static final int COLOR_WHITE = 0xF2F2F2;
    public static final int COLOR_ORANGE = 16745472;
    public static final int COLOR_GREEN = 3916288;
    public static final int COLOR_PURPLE = 10748144;
    public static final int COLOR_BLUE = 23490;
    public static final int COLOR_AQUA = 65535;
    public static final int COLOR_BLACK = 0x292929;
    public static final int COLOR_GREY = 0x8A8A8A;
    public static final int COLOR_YELLOW = 0xEEEE00;
    public static final int[] COLOR_DEFAULT = new int[]{0x4C4C4C, 0x3D3D3D};
    protected static final ResourceLocation INTERFACE = new ResourceLocation("rpghud:textures/interface.png");
    public static final int OFFSET_PERCENT = 25;
    public static final int OFFSET_PREVIEW = 0x5A5A5A;
    protected int posX;
    protected int posY;
    protected final int defaultPosX;
    protected final int defaultPosY;
    protected int elementWidth;
    protected int elementHeight;
    protected boolean moveable;
    protected HudElementType type;
    protected Minecraft mc;
    protected ModRPGHud rpgHud;
    protected Settings settings;
    protected float scale;
    protected float scaleInverted;
    public HudElementType parent;

    public HudElement(HudElementType type, int posX, int posY, int width, int height, boolean moveable) {
        this.type = type;
        this.posX = posX;
        this.posY = posY;
        this.defaultPosX = posX;
        this.defaultPosY = posY;
        this.elementWidth = width;
        this.elementHeight = height;
        this.moveable = moveable;
        this.mc = Minecraft.m_91087_();
        this.rpgHud = ModRPGHud.instance;
        this.settings = this.rpgHud.settings;
        this.scale = 1.0f;
        this.scaleInverted = 1.0f / this.scale;
        this.parent = type;
    }

    public void draw(Gui gui, PoseStack ms, float zLevel, float partialTicks, int scaledWidth, int scaledHeight) {
        this.drawElement(gui, ms, zLevel, partialTicks, scaledWidth, scaledHeight);
    }

    public abstract void drawElement(Gui var1, PoseStack var2, float var3, float var4, int var5, int var6);

    public int getPosX(int scaledWidth) {
        return this.posX;
    }

    public int getPosY(int scaledHeight) {
        return this.posY;
    }

    public int getWidth(int scaledWidth) {
        return this.elementWidth;
    }

    public int getHeight(int scaledHeight) {
        return this.elementHeight;
    }

    public float getScale() {
        return 1.0f;
    }

    public float getInvertedScale() {
        return 1.0f / this.getScale();
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public HudElementType getType() {
        return this.type;
    }

    public boolean setPos(int posX, int posY) {
        boolean xValid = false;
        boolean yValid = false;
        if (posX >= 0 && posX < this.mc.m_91268_().m_85445_() - this.elementWidth) {
            xValid = true;
        }
        if (posY >= 0 && posY < this.mc.m_91268_().m_85446_() - this.elementHeight) {
            yValid = true;
        }
        if (xValid && yValid) {
            this.posX = posX;
            this.posY = posY;
        }
        return xValid && yValid;
    }

    public void setPositionToDefault() {
        this.posX = this.defaultPosX;
        this.posY = this.defaultPosY;
    }

    public boolean checkConditions() {
        return true;
    }

    public static void drawRect(PoseStack ms, int posX, int posY, int width, int height, int color) {
        if (color == -1) {
            return;
        }
        float f3 = color <= 0xFFFFFF && color >= 0 ? 1.0f : (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69465_();
        BufferBuilder vertexbuffer = Tesselator.m_85913_().m_85915_();
        vertexbuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        vertexbuffer.m_85982_(ms.m_85850_().m_85861_(), (float)posX, (float)(posY + height), 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        vertexbuffer.m_85982_(ms.m_85850_().m_85861_(), (float)(posX + width), (float)(posY + height), 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        vertexbuffer.m_85982_(ms.m_85850_().m_85861_(), (float)(posX + width), (float)posY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        vertexbuffer.m_85982_(ms.m_85850_().m_85861_(), (float)posX, (float)posY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)vertexbuffer.m_231175_());
        RenderSystem.m_69461_();
        RenderSystem.m_69482_();
    }

    protected static void drawOutline(PoseStack ms, int x, int y, int width, int height, int color) {
        HudElement.drawRect(ms, x, y, width, 1, color);
        HudElement.drawRect(ms, x, y + 1, 1, height - 2, color);
        HudElement.drawRect(ms, x + width - 1, y + 1, 1, height - 2, color);
        HudElement.drawRect(ms, x, y + height - 1, width, 1, color);
    }

    public static void drawCustomBar(PoseStack ms, int x, int y, int width, int height, double value, int colorBarLight, int colorBarDark) {
        HudElement.drawCustomBar(ms, x, y, width, height, value, COLOR_DEFAULT[0], COLOR_DEFAULT[1], colorBarLight, colorBarDark, true, 0);
    }

    public static void drawCustomBar(PoseStack ms, int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark) {
        HudElement.drawCustomBar(ms, x, y, width, height, value, colorGroundLight, colorGroundDark, colorBarLight, colorBarDark, true, 0);
    }

    public static void drawCustomBar(PoseStack ms, int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark, boolean outlined) {
        HudElement.drawCustomBar(ms, x, y, width, height, value, colorGroundLight, colorGroundDark, colorBarLight, colorBarDark, outlined, 0);
    }

    public static void drawCustomBar(PoseStack ms, int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark, int colorOutline) {
        HudElement.drawCustomBar(ms, x, y, width, height, value, colorGroundLight, colorGroundDark, colorBarLight, colorBarDark, true, colorOutline);
    }

    public static void drawCustomBar(PoseStack ms, int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark, boolean outlined, int colorOutline) {
        if (value < 0.0) {
            value = 0.0;
        } else if (value > 100.0) {
            value = 100.0;
        }
        int offset = 0;
        if (outlined) {
            offset = 1;
        }
        int filledWidth = width;
        filledWidth = width - offset * 2;
        if (filledWidth < 0) {
            filledWidth = 0;
        }
        int filledHeight = width;
        filledHeight = height - offset * 2;
        if (filledHeight < 0) {
            filledHeight = 0;
        }
        int percentFilled = (int)Math.round(value / 100.0 * (double)filledWidth);
        if (outlined) {
            HudElement.drawOutline(ms, x, y, width, height, colorOutline);
        }
        int halfedFilledHeight = filledHeight / 2;
        HudElement.drawRect(ms, x + offset, y + offset, percentFilled, halfedFilledHeight, colorBarLight);
        HudElement.drawRect(ms, x + offset, y + offset + halfedFilledHeight, percentFilled, filledHeight - halfedFilledHeight, colorBarDark);
        if (filledWidth - percentFilled > 0) {
            HudElement.drawRect(ms, x + offset + percentFilled, y + offset, filledWidth - percentFilled, halfedFilledHeight, colorGroundLight);
            HudElement.drawRect(ms, x + offset + percentFilled, y + offset + halfedFilledHeight, filledWidth - percentFilled, filledHeight - halfedFilledHeight, colorGroundDark);
        }
    }

    public void drawTetragon(int posX1, int posX2, int posY1, int posY2, int width1, int width2, int height1, int height2, int color) {
        if (color == -1) {
            return;
        }
        if (width1 < 0) {
            width1 = 0;
        }
        if (width2 < 0) {
            width2 = 0;
        }
        float f3 = color <= 0xFFFFFF && color >= 0 ? 1.0f : (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69465_();
        BufferBuilder vertexbuffer = Tesselator.m_85913_().m_85915_();
        vertexbuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        vertexbuffer.m_5483_((double)posX1, (double)posY1 + (double)height1, 0.0).m_85950_(f, f1, f2, f3).m_5752_();
        vertexbuffer.m_5483_((double)posX2 + (double)width2, (double)posY2 + (double)height2, 0.0).m_85950_(f, f1, f2, f3).m_5752_();
        vertexbuffer.m_5483_((double)posX1 + (double)width1, (double)posY2, 0.0).m_85950_(f, f1, f2, f3).m_5752_();
        vertexbuffer.m_5483_((double)posX2, (double)posY1, 0.0).m_85950_(f, f1, f2, f3).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)vertexbuffer.m_231175_());
        RenderSystem.m_69461_();
        RenderSystem.m_69482_();
    }

    public static int offsetColorPercent(int color, int offsetPercent) {
        int colorPart = color >> 16 & 0xFF;
        if ((colorPart -= colorPart / (100 / offsetPercent)) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        int colorOffset = colorPart << 16;
        colorPart = color >> 8 & 0xFF;
        colorPart -= colorPart / (100 / offsetPercent);
        if (colorPart > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        colorOffset += colorPart << 8;
        colorPart = color & 0xFF;
        colorPart -= colorPart / (100 / offsetPercent);
        if (colorPart > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        return colorOffset += colorPart;
    }

    public static int offsetColor(int color, int offset) {
        int colorPart = color >> 16 & 0xFF;
        if ((colorPart += offset >> 16 & 0xFF) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        int colorOffset = colorPart << 16;
        colorPart = color >> 8 & 0xFF;
        if ((colorPart += offset >> 8 & 0xFF) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        colorOffset += colorPart << 8;
        colorPart = color & 0xFF;
        if ((colorPart += offset & 0xFF) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        return colorOffset += colorPart;
    }

    protected void bind(ResourceLocation res) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)res);
    }

    protected static ResourceLocation getPlayerSkin(LocalPlayer player) {
        return player.m_108560_();
    }

    protected void renderHotbarItem(PoseStack ms, int x, int y, float partialTicks, Player player, ItemStack item) {
        if (!item.m_41619_()) {
            PoseStack PoseStack2 = RenderSystem.m_157191_();
            float f = (float)item.m_41612_() - partialTicks;
            if (f > 0.0f) {
                PoseStack2.m_85836_();
                float f1 = 1.0f + f / 5.0f;
                PoseStack2.m_85837_((double)(x + 8), (double)(y + 12), 0.0);
                PoseStack2.m_85841_(1.0f / f1, (f1 + 1.0f) / 2.0f, 1.0f);
                PoseStack2.m_85837_((double)(-(x + 8)), (double)(-(y + 12)), 0.0);
            }
            this.mc.m_91291_().m_115123_(item, x, y);
            if (f > 0.0f) {
                PoseStack2.m_85849_();
            }
            this.mc.m_91291_().m_115169_(this.mc.f_91062_, item, x, y);
        }
    }

    protected void renderSlot(int x, int y, float partialTicks, Player player, ItemStack item, int p_168683_) {
        if (!item.m_41619_()) {
            PoseStack posestack = RenderSystem.m_157191_();
            float f = (float)item.m_41612_() - partialTicks;
            if (f > 0.0f) {
                float f1 = 1.0f + f / 5.0f;
                posestack.m_85836_();
                posestack.m_85837_((double)(x + 8), (double)(y + 12), 0.0);
                posestack.m_85841_(1.0f / f1, (f1 + 1.0f) / 2.0f, 1.0f);
                posestack.m_85837_((double)(-(x + 8)), (double)(-(y + 12)), 0.0);
                RenderSystem.m_157182_();
            }
            this.mc.m_91291_().m_174229_((LivingEntity)player, item, x, y, p_168683_);
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            if (f > 0.0f) {
                posestack.m_85849_();
                RenderSystem.m_157182_();
            }
            this.mc.m_91291_().m_115169_(this.mc.f_91062_, item, x, y);
        }
    }

    protected void drawStringWithBackground(PoseStack ms, String text, int posX, int posY, int colorMain, int colorBackground) {
        this.mc.f_91062_.m_92883_(ms, text, (float)(posX + 1), (float)posY, colorBackground);
        this.mc.f_91062_.m_92883_(ms, text, (float)(posX - 1), (float)posY, colorBackground);
        this.mc.f_91062_.m_92883_(ms, text, (float)posX, (float)(posY + 1), colorBackground);
        this.mc.f_91062_.m_92883_(ms, text, (float)posX, (float)(posY - 1), colorBackground);
        this.mc.f_91062_.m_92883_(ms, text, (float)posX, (float)posY, colorMain);
        RenderSystem.m_69478_();
    }

    public boolean isChatOpen() {
        return this.mc.f_91080_ instanceof ChatScreen;
    }
}

