/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element.vanilla;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;

public class HudElementEntityInspectVanilla
extends HudElement {
    protected static final ResourceLocation DAMAGE_INDICATOR = new ResourceLocation("rpghud:textures/entityinspect.png");

    @Override
    public boolean checkConditions() {
        return this.settings.getBoolValue("enable_entity_inspect");
    }

    public HudElementEntityInspectVanilla() {
        super(HudElementType.ENTITY_INSPECT, 0, 0, 0, 0, true);
    }

    @Override
    public void drawElement(Gui gui, PoseStack ms, float zLevel, float partialTicks, int scaledWidth, int scaledHeight) {
        LivingEntity focused = HudElementEntityInspectVanilla.getFocusedEntity((Entity)this.mc.f_91074_);
        if (focused != null && !(focused instanceof ArmorStand) && !focused.m_21023_(MobEffects.f_19609_)) {
            int armor;
            int posX = scaledWidth / 2 + this.settings.getPositionValue("inspector_position")[0];
            int posY = this.settings.getPositionValue("inspector_position")[1];
            this.bind(DAMAGE_INDICATOR);
            gui.m_93228_(ms, posX - 62, 20 + posY, 0, 0, 128, 36);
            float health = focused.m_21223_();
            float maxHealth = focused.m_21233_();
            if (health > maxHealth) {
                health = maxHealth;
            }
            HudElementEntityInspectVanilla.drawCustomBar(ms, posX - 25, 34 + posY, 89, 8, (double)health / (double)maxHealth * 100.0, this.settings.getIntValue("color_health"), HudElementEntityInspectVanilla.offsetColorPercent(this.settings.getIntValue("color_health"), 25));
            String stringHealth = (double)Math.round(health * 10.0f) / 10.0 + "/" + (double)Math.round(maxHealth * 10.0f) / 10.0;
            ms.m_85841_(0.5f, 0.5f, 0.5f);
            Gui.m_93208_((PoseStack)ms, (Font)this.mc.f_91062_, (String)stringHealth, (int)((posX - 27 + 44) * 2), (int)((36 + posY) * 2), (int)-1);
            ms.m_85841_(2.0f, 2.0f, 2.0f);
            int x = posX - 29 + 44 - this.mc.f_91062_.m_92895_(focused.m_7755_().getString()) / 2;
            int y = 25 + posY;
            this.drawStringWithBackground(ms, focused.m_7755_().getString(), x, y, -1, 0);
            HudElementEntityInspectVanilla.drawEntityOnScreen(posX - 60 + 16, 49 + posY, focused);
            if (this.settings.getBoolValue("show_entity_armor").booleanValue() && (armor = focused.m_21230_()) > 0) {
                String value = String.valueOf(armor);
                this.bind(DAMAGE_INDICATOR);
                gui.m_93228_(ms, posX - 26, posY + 44, 0, 36, 19, 8);
                this.bind(Gui.f_93098_);
                ms.m_85841_(0.5f, 0.5f, 0.5f);
                gui.m_93228_(ms, (posX - 24) * 2 - 1, (posY + 45) * 2, 34, 9, 9, 9);
                this.drawStringWithBackground(ms, value, (posX - 18) * 2 - 2, (posY + 45) * 2 + 1, -1, 0);
                ms.m_85841_(2.0f, 2.0f, 2.0f);
            }
        }
    }

    public static void drawEntityOnScreen(int posX, int posY, LivingEntity entity) {
        int scale = 1;
        int s1 = (int)(18.0f / entity.m_20206_());
        int s3 = (int)(18.0f / entity.m_6134_());
        int offset = 0;
        scale = s1 > s3 ? s3 : s1;
        if (entity instanceof Squid) {
            scale = 11;
            offset = -13;
        } else if (entity instanceof Spider) {
            scale = 11;
            offset = -5;
        }
        float f = (float)Math.atan(4.5);
        float g = (float)Math.atan(0.0);
        PoseStack ms = RenderSystem.m_157191_();
        ms.m_85836_();
        ms.m_85837_((double)posX, (double)(posY += offset), 1050.0);
        ms.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack poseStack = new PoseStack();
        poseStack.m_85837_(0.0, 0.0, 1000.0);
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion quaternion2 = Vector3f.f_122223_.m_122240_(g * 20.0f);
        quaternion.m_80148_(quaternion2);
        poseStack.m_85845_(quaternion);
        float h = entity.f_20883_;
        float i = entity.m_146908_();
        float j = entity.m_146909_();
        float k = entity.f_20886_;
        float l = entity.f_20885_;
        entity.m_5618_(180.0f + f * 20.0f);
        entity.m_146922_(180.0f + f * 40.0f);
        entity.m_146926_(-g * 20.0f);
        entity.f_20885_ = entity.m_146908_() - 35.0f;
        entity.f_20886_ = entity.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        quaternion2.m_80157_();
        entityRenderDispatcher.m_114412_(quaternion2);
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        entityRenderDispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)immediate, 0xF000F0);
        immediate.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        entity.f_20883_ = h;
        entity.m_146922_(i);
        entity.m_146926_(j);
        entity.f_20886_ = k;
        entity.f_20885_ = l;
        ms.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    public static LivingEntity getFocusedEntity(Entity watcher) {
        LivingEntity focusedEntity = null;
        double maxDistance = 64.0;
        Vec3 vec = new Vec3(watcher.m_20185_(), watcher.m_20186_(), watcher.m_20189_());
        Vec3 posVec = watcher.m_20182_();
        if (watcher instanceof Player) {
            vec = vec.m_82520_(0.0, (double)watcher.m_20192_(), 0.0);
            posVec = posVec.m_82520_(0.0, (double)watcher.m_20192_(), 0.0);
        }
        Vec3 lookVec = Vec3.m_82503_((Vec2)watcher.m_20155_());
        Vec3 vec2 = vec.m_82549_(lookVec.m_82541_().m_82542_(maxDistance, maxDistance, maxDistance));
        BlockHitResult ray = watcher.f_19853_.m_45547_(new ClipContext(vec, vec2, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, watcher));
        double distance = maxDistance;
        if (ray != null) {
            distance = ray.m_82425_().m_203193_((Position)posVec);
        }
        Vec3 reachVector = posVec.m_82520_(lookVec.f_82479_ * maxDistance, lookVec.f_82480_ * maxDistance, lookVec.f_82481_ * maxDistance);
        double currentDistance = distance;
        List entitiesWithinMaxDistance = watcher.f_19853_.m_45933_(watcher, watcher.m_20191_().m_82363_(lookVec.f_82479_ * maxDistance, lookVec.f_82480_ * maxDistance, lookVec.f_82481_ * maxDistance).m_82363_(1.0, 1.0, 1.0));
        for (Entity entity : entitiesWithinMaxDistance) {
            Vec3 hitVec;
            double distanceToEntity;
            if (!(entity instanceof LivingEntity)) continue;
            float collisionBorderSize = entity.m_6143_();
            AABB hitBox = entity.m_20191_().m_82363_((double)collisionBorderSize, (double)collisionBorderSize, (double)collisionBorderSize);
            Vec3 hitVecIn = HudElementEntityInspectVanilla.intercept(posVec, reachVector, hitBox);
            if (hitBox.m_82390_(posVec)) {
                if (!(currentDistance <= 0.0)) continue;
                currentDistance = 0.0;
                focusedEntity = (LivingEntity)entity;
                continue;
            }
            if (hitVecIn == null || !((distanceToEntity = posVec.m_82554_(hitVec = new Vec3(hitVecIn.f_82479_, hitVecIn.f_82480_, hitVecIn.f_82481_))) <= currentDistance)) continue;
            currentDistance = distanceToEntity;
            focusedEntity = (LivingEntity)entity;
        }
        return focusedEntity;
    }

    public static Vec3 intercept(Vec3 vecA, Vec3 vecB, AABB bb) {
        double[] adouble = new double[]{1.0};
        Direction enumfacing = null;
        double d0 = vecB.f_82479_ - vecA.f_82479_;
        double d1 = vecB.f_82480_ - vecA.f_82480_;
        double d2 = vecB.f_82481_ - vecA.f_82481_;
        if ((enumfacing = HudElementEntityInspectVanilla.func_197741_a(bb, vecA, adouble, enumfacing, d0, d1, d2)) == null) {
            return null;
        }
        double d3 = adouble[0];
        return vecA.m_82520_(d3 * d0, d3 * d1, d3 * d2);
    }

    private static Direction func_197741_a(AABB aabb, Vec3 p_197741_1_, double[] p_197741_2_, Direction facing, double p_197741_4_, double p_197741_6_, double p_197741_8_) {
        if (p_197741_4_ > 1.0E-7) {
            facing = HudElementEntityInspectVanilla.func_197740_a(p_197741_2_, facing, p_197741_4_, p_197741_6_, p_197741_8_, aabb.f_82288_, aabb.f_82289_, aabb.f_82292_, aabb.f_82290_, aabb.f_82293_, Direction.WEST, p_197741_1_.f_82479_, p_197741_1_.f_82480_, p_197741_1_.f_82481_);
        } else if (p_197741_4_ < -1.0E-7) {
            facing = HudElementEntityInspectVanilla.func_197740_a(p_197741_2_, facing, p_197741_4_, p_197741_6_, p_197741_8_, aabb.f_82291_, aabb.f_82289_, aabb.f_82292_, aabb.f_82290_, aabb.f_82293_, Direction.EAST, p_197741_1_.f_82479_, p_197741_1_.f_82480_, p_197741_1_.f_82481_);
        }
        if (p_197741_6_ > 1.0E-7) {
            facing = HudElementEntityInspectVanilla.func_197740_a(p_197741_2_, facing, p_197741_6_, p_197741_8_, p_197741_4_, aabb.f_82289_, aabb.f_82290_, aabb.f_82293_, aabb.f_82288_, aabb.f_82291_, Direction.DOWN, p_197741_1_.f_82480_, p_197741_1_.f_82481_, p_197741_1_.f_82479_);
        } else if (p_197741_6_ < -1.0E-7) {
            facing = HudElementEntityInspectVanilla.func_197740_a(p_197741_2_, facing, p_197741_6_, p_197741_8_, p_197741_4_, aabb.f_82292_, aabb.f_82290_, aabb.f_82293_, aabb.f_82288_, aabb.f_82291_, Direction.UP, p_197741_1_.f_82480_, p_197741_1_.f_82481_, p_197741_1_.f_82479_);
        }
        if (p_197741_8_ > 1.0E-7) {
            facing = HudElementEntityInspectVanilla.func_197740_a(p_197741_2_, facing, p_197741_8_, p_197741_4_, p_197741_6_, aabb.f_82290_, aabb.f_82288_, aabb.f_82291_, aabb.f_82289_, aabb.f_82292_, Direction.NORTH, p_197741_1_.f_82481_, p_197741_1_.f_82479_, p_197741_1_.f_82480_);
        } else if (p_197741_8_ < -1.0E-7) {
            facing = HudElementEntityInspectVanilla.func_197740_a(p_197741_2_, facing, p_197741_8_, p_197741_4_, p_197741_6_, aabb.f_82293_, aabb.f_82288_, aabb.f_82291_, aabb.f_82289_, aabb.f_82292_, Direction.SOUTH, p_197741_1_.f_82481_, p_197741_1_.f_82479_, p_197741_1_.f_82480_);
        }
        return facing;
    }

    private static Direction func_197740_a(double[] p_197740_0_, Direction p_197740_1_, double p_197740_2_, double p_197740_4_, double p_197740_6_, double p_197740_8_, double p_197740_10_, double p_197740_12_, double p_197740_14_, double p_197740_16_, Direction p_197740_18_, double p_197740_19_, double p_197740_21_, double p_197740_23_) {
        double d0 = (p_197740_8_ - p_197740_19_) / p_197740_2_;
        double d1 = p_197740_21_ + d0 * p_197740_4_;
        double d2 = p_197740_23_ + d0 * p_197740_6_;
        if (0.0 < d0 && d0 < p_197740_0_[0] && p_197740_10_ - 1.0E-7 < d1 && d1 < p_197740_12_ + 1.0E-7 && p_197740_14_ - 1.0E-7 < d2 && d2 < p_197740_16_ + 1.0E-7) {
            p_197740_0_[0] = d0;
            return p_197740_18_;
        }
        return p_197740_1_;
    }
}

