/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;

public class HudElementMiscVanilla
extends HudElement {
    public HudElementMiscVanilla() {
        super(HudElementType.MISC, 0, 0, 0, 0, true);
    }

    @Override
    public boolean checkConditions() {
        return !this.mc.f_91066_.f_92063_;
    }

    @Override
    public void drawElement(Gui gui, PoseStack ms, float zLevel, float partialTicks, int scaledWidth, int scaledHeight) {
        if (this.settings.getBoolValue("enable_fps").booleanValue()) {
            this.renderFPS(ms, scaledWidth, scaledHeight);
        }
        if (this.settings.getBoolValue("enable_system_time").booleanValue()) {
            this.renderSystemTime(ms, scaledWidth, scaledHeight);
        }
    }

    private void renderFPS(PoseStack ms, int scaledWidth, int scaledHeight) {
        float scale = (float)this.settings.getDoubleValue("fps_scale");
        ms.m_85841_(scale, scale, scale);
        scale = this.getInvertedScale(scale);
        String fps = this.mc.f_90977_.split(" ")[0];
        int posX = (int)((float)(1 + this.settings.getPositionValue("fps_position")[0]) * scale);
        int posY = (int)((float)(1 + this.settings.getPositionValue("fps_position")[0]) * scale);
        Gui.m_93236_((PoseStack)ms, (Font)this.mc.f_91062_, (String)fps, (int)posX, (int)posY, (int)this.settings.getIntValue("color_fps"));
        ms.m_85841_(scale, scale, scale);
    }

    private void renderSystemTime(PoseStack ms, int scaledWidth, int scaledHeight) {
        float scale = (float)this.settings.getDoubleValue("system_time_scale");
        ms.m_85841_(scale, scale, scale);
        scale = this.getInvertedScale(scale);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
        String time = formatter.format(LocalDateTime.now());
        int posX = Math.round((float)(1 + this.settings.getPositionValue("system_time_position")[0]) * scale);
        int posY = Math.round((float)(scaledHeight - 1 + this.settings.getPositionValue("system_time_position")[0]) * scale) - 8;
        if (this.settings.getBoolValue("enable_system_time_background").booleanValue()) {
            int width = Math.round(2.0f * scale + (float)this.mc.f_91062_.m_92895_(String.valueOf(time)));
            HudElementMiscVanilla.drawRect(ms, Math.round((float)posX - 1.0f * scale), Math.round((float)posY - 1.0f * scale) - 1, width, Math.round(10.0f + 1.0f * scale), -1610612736);
        }
        Gui.m_93236_((PoseStack)ms, (Font)this.mc.f_91062_, (String)time, (int)posX, (int)posY, (int)this.settings.getIntValue("color_system_time"));
        ms.m_85841_(scale, scale, scale);
    }

    public float getInvertedScale(float scale) {
        return 1.0f / scale;
    }
}

