/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.main;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.spellcraftgaming.rpghud.gui.hud.HudHotbarWidget;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.main.ModRPGHud;

public class RenderOverlay
implements IGuiOverlay {
    private ModRPGHud rpgHud = ModRPGHud.instance;
    private Minecraft mc = Minecraft.m_91087_();

    public RenderOverlay() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void render(ForgeGui gui, PoseStack ms, float partialTicks, int screenWidth, int screenHeight) {
        this.drawElement(HudElementType.WIDGET, ms, partialTicks);
        this.drawElement(HudElementType.CLOCK, ms, partialTicks);
        this.drawElement(HudElementType.DETAILS, ms, partialTicks);
        this.drawElement(HudElementType.COMPASS, ms, partialTicks);
        this.drawElement(HudElementType.ENTITY_INSPECT, ms, partialTicks);
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.HEALTH)) {
            this.drawElement(HudElementType.HEALTH, ms, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.ARMOR)) {
            this.drawElement(HudElementType.ARMOR, ms, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.FOOD)) {
            this.drawElement(HudElementType.FOOD, ms, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.HEALTH_MOUNT)) {
            this.drawElement(HudElementType.HEALTH_MOUNT, ms, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.AIR)) {
            this.drawElement(HudElementType.AIR, ms, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.JUMP_BAR)) {
            this.drawElement(HudElementType.JUMP_BAR, ms, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.STATUS_EFFECTS)) {
            this.drawElement(HudElementType.STATUS_EFFECTS, ms, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.EXPERIENCE)) {
            this.drawElement(HudElementType.EXPERIENCE, ms, partialTicks);
            this.drawElement(HudElementType.LEVEL, ms, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.HOTBAR)) {
            this.drawElement(HudElementType.HOTBAR, ms, partialTicks);
        }
        this.drawElement(HudElementType.MISC, ms, partialTicks);
    }

    @SubscribeEvent
    public void registerOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("rpg_hud", (IGuiOverlay)this);
    }

    private void drawElement(HudElementType type, PoseStack ms, float partialTicks) {
        if (this.rpgHud.getActiveHud().checkElementConditions(type) && !this.preventElementRenderType(type)) {
            this.bind(GuiComponent.f_93098_);
            ms.m_85836_();
            RenderSystem.m_69478_();
            this.rpgHud.getActiveHud().drawElement(type, this.mc.f_91065_, ms, partialTicks, partialTicks, this.mc.m_91268_().m_85445_(), this.mc.m_91268_().m_85446_());
            ms.m_85849_();
        }
    }

    private boolean preventElementRenderType(HudElementType type) {
        String id = "prevent_element_render_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    public static boolean shouldRenderVanilla(HudElementType type) {
        return RenderOverlay.isVanillaElement(type) || RenderOverlay.forceRenderTypeVanilla(type);
    }

    public static boolean forceRenderTypeVanilla(HudElementType type) {
        ModRPGHud rpgHud = ModRPGHud.instance;
        String id = "render_vanilla_" + type.name().toLowerCase();
        if (rpgHud.settings.doesSettingExist(id)) {
            return rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    public static boolean preventEventType(HudElementType type) {
        if (!RenderOverlay.shouldRenderVanilla(type)) {
            return true;
        }
        ModRPGHud rpgHud = ModRPGHud.instance;
        String id = "prevent_event_" + type.name().toLowerCase();
        if (rpgHud.settings.doesSettingExist(id)) {
            return rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    private void bind(ResourceLocation res) {
        this.mc.m_91097_().m_174784_(res);
    }

    public static boolean isVanillaElement(HudElementType type) {
        return ModRPGHud.instance.getActiveHud().isVanillaElement(type);
    }

    @SubscribeEvent
    public void onGameOverlayRenderPre(RenderGuiOverlayEvent.Pre event) {
        ResourceLocation overlay = event.getOverlay().id();
        if (VanillaGuiOverlay.AIR_LEVEL.id() == overlay) {
            if (RenderOverlay.preventEventType(HudElementType.AIR)) {
                event.setCanceled(true);
            }
        } else if (VanillaGuiOverlay.ARMOR_LEVEL.id() == overlay) {
            if (RenderOverlay.preventEventType(HudElementType.ARMOR)) {
                event.setCanceled(true);
            }
        } else if (VanillaGuiOverlay.EXPERIENCE_BAR.id() == overlay) {
            if (RenderOverlay.preventEventType(HudElementType.EXPERIENCE)) {
                event.setCanceled(true);
            }
        } else if (VanillaGuiOverlay.FOOD_LEVEL.id() == overlay) {
            if (RenderOverlay.preventEventType(HudElementType.FOOD)) {
                event.setCanceled(true);
            }
        } else if (overlay == VanillaGuiOverlay.PLAYER_HEALTH.id()) {
            if (RenderOverlay.preventEventType(HudElementType.HEALTH)) {
                event.setCanceled(true);
            }
        } else if (VanillaGuiOverlay.MOUNT_HEALTH.id() == overlay) {
            if (RenderOverlay.preventEventType(HudElementType.HEALTH_MOUNT)) {
                event.setCanceled(true);
            }
        } else if (VanillaGuiOverlay.HOTBAR.id() == overlay) {
            if (RenderOverlay.preventEventType(HudElementType.HOTBAR)) {
                event.setCanceled(true);
            }
        } else if (VanillaGuiOverlay.JUMP_BAR.id() == overlay) {
            if (RenderOverlay.preventEventType(HudElementType.JUMP_BAR)) {
                event.setCanceled(true);
            }
        } else if (VanillaGuiOverlay.POTION_ICONS.id() == overlay) {
            if (RenderOverlay.preventEventType(HudElementType.STATUS_EFFECTS)) {
                event.setCanceled(true);
            }
        } else if (VanillaGuiOverlay.CHAT_PANEL.id() == overlay && ModRPGHud.instance.getActiveHud() instanceof HudHotbarWidget) {
            event.getPoseStack().m_85837_(0.0, -22.0, 0.0);
        }
    }

    @SubscribeEvent
    public void onGameOverlayRenderPost(RenderGuiOverlayEvent.Post event) {
        ResourceLocation overlay = event.getOverlay().id();
        if (VanillaGuiOverlay.CHAT_PANEL.id() == overlay && ModRPGHud.instance.getActiveHud() instanceof HudHotbarWidget) {
            event.getPoseStack().m_85837_(0.0, 22.0, 0.0);
        }
    }
}

