/*
 * Decompiled with CFR 0.152.
 */
package info.infinf.xaeroTracker;

import info.infinf.xaeroTracker.Commands.Executor;
import info.infinf.xaeroTracker.FilePlayerList;
import info.infinf.xaeroTracker.PlayerData;
import info.infinf.xaeroTracker.util.MessageUtil;
import info.infinf.xaeroTracker.util.PlayerUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationStore;
import net.kyori.adventure.util.UTF8ResourceBundleControl;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XaeroTracker
extends JavaPlugin
implements Listener {
    @NotNull
    public static final String MINIMAP_PACKET_ID = "xaerominimap:main";
    @NotNull
    public static final String WORLD_MAP_PACKET_ID = "xaeroworldmap:main";
    @NotNull
    public final @NotNull Map<@NotNull Player, @NotNull PlayerData> playerData = new ConcurrentHashMap<Player, PlayerData>();
    public ScheduledExecutorService trackerThread;
    public FilePlayerList trackIgnoreList;
    public FilePlayerList trackBypassList;
    public boolean shouldSendLevelId;
    public int levelId;
    public long syncCooldown;
    public boolean onlySyncSameWorld;
    private TranslationStore.StringBased<MessageFormat> translationStore;

    public void onEnable() {
        this.saveDefaultConfig();
        FileConfiguration conf = this.getConfig();
        this.shouldSendLevelId = conf.getBoolean("should-send-level-id", true);
        if (!conf.contains("level-id")) {
            conf.set("level-id", (Object)new Random().nextInt());
            this.saveConfig();
        }
        this.levelId = conf.getInt("level-id");
        this.syncCooldown = conf.getInt("sync-cooldown", 250);
        this.onlySyncSameWorld = conf.getBoolean("only-sync-same-world", false);
        this.trackIgnoreList = new FilePlayerList(this, this.getDataPath().resolve("track_ignore_list.yml").toFile());
        this.trackBypassList = new FilePlayerList(this, this.getDataPath().resolve("track_bypass_list.yml").toFile());
        Messenger messenger = Bukkit.getMessenger();
        messenger.registerIncomingPluginChannel((Plugin)this, MINIMAP_PACKET_ID, this::onMinimapMessageReceived);
        messenger.registerIncomingPluginChannel((Plugin)this, WORLD_MAP_PACKET_ID, this::onWorldMapMessageReceived);
        messenger.registerOutgoingPluginChannel((Plugin)this, MINIMAP_PACKET_ID);
        messenger.registerOutgoingPluginChannel((Plugin)this, WORLD_MAP_PACKET_ID);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        PluginCommand cmd = this.getCommand("xaerotracker");
        if (cmd != null) {
            cmd.setExecutor((CommandExecutor)new Executor(this));
            cmd.setPermission("xaerotracker");
            cmd.setUsage("/xt toggleTracked\n/xt toggleTracked <player name>\n/xt toggleTrackEveryone\n/xt toggleTrackEveryone <player name>\n");
        }
        this.translationStore = TranslationStore.messageFormat(Key.key("xaerotracker:lang"));
        this.translationStore.registerAll(Locale.US, ResourceBundle.getBundle("locales.lang", Locale.US, UTF8ResourceBundleControl.get()), true);
        this.translationStore.registerAll(Locale.SIMPLIFIED_CHINESE, ResourceBundle.getBundle("locales.lang", Locale.SIMPLIFIED_CHINESE, UTF8ResourceBundleControl.get()), true);
        this.translationStore.defaultLocale(Locale.US);
        GlobalTranslator.translator().addSource(this.translationStore);
        for (Player pl : this.getServer().getOnlinePlayers()) {
            this.initPlayer(pl, new PlayerData());
        }
        this.trackerThread = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(null, r, "Xaero Tracker Thread", 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        });
        this.trackerThread.submit(() -> {
            for (Player pl : this.getServer().getOnlinePlayers()) {
                PlayerData data = this.playerData.get(pl);
                if (data == null) continue;
                this.track(pl, data);
            }
        });
    }

    private void initPlayer(Player pl, PlayerData data) {
        try {
            Method addChannel = pl.getClass().getMethod("addChannel", String.class);
            addChannel.invoke((Object)pl, MINIMAP_PACKET_ID);
            addChannel.invoke((Object)pl, WORLD_MAP_PACKET_ID);
            this.sendHandshakeInfo(pl);
            if (this.shouldSendLevelId) {
                this.sendLevelId(pl);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            ex.printStackTrace();
        }
        this.playerData.put(pl, data);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player pl = e.getPlayer();
        PlayerData data = new PlayerData();
        this.initPlayer(pl, data);
        this.trackerThread.submit(() -> this.track(pl, data));
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent e) {
        this.trackerThread.submit(() -> {
            Player pl = e.getPlayer();
            PlayerData data = this.playerData.get(pl);
            if (data != null) {
                if (this.shouldSendLevelId) {
                    this.sendModderBothChannels(pl, data, MessageUtil.getLevelIdMessage(this.levelId));
                }
                data.clearSyncSchedule();
                this.track(pl, data);
                if (this.onlySyncSameWorld) {
                    this.sendModderOneChannel(pl, data, MessageUtil.getTrackResetMessage());
                    this.trackOthers(pl, data.channel);
                }
            }
            if (this.onlySyncSameWorld) {
                byte[] msg = MessageUtil.getUntrackPlayerMessage(pl);
                for (Player other : e.getFrom().getPlayers()) {
                    PlayerData otherData;
                    if (other == pl || (otherData = this.playerData.get(other)) == null) continue;
                    this.sendModderOneChannel(other, otherData, msg);
                }
            }
        });
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        if (!e.hasExplicitlyChangedPosition()) {
            return;
        }
        this.trackerThread.submit(() -> {
            Player pl = e.getPlayer();
            PlayerData data = this.playerData.get(pl);
            if (data == null) {
                return;
            }
            data.clearSyncSchedule();
            long lastSyncInterval = System.currentTimeMillis() - data.lastSyncTime;
            if (lastSyncInterval >= this.syncCooldown) {
                this.track(pl, data);
            } else {
                data.syncSchedule = this.trackerThread.schedule(() -> this.track(pl, data), this.syncCooldown - lastSyncInterval, TimeUnit.MILLISECONDS);
            }
        });
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.trackerThread.submit(() -> {
            Player pl = e.getPlayer();
            this.untrack(pl, this.playerData.get(pl));
            this.playerData.remove(pl);
        });
    }

    public void onMinimapMessageReceived(@NotNull String channel, @NotNull Player pl, byte @NotNull [] message) {
        this.trackerThread.submit(() -> {
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])message);
            if (buf.readByte() == 1) {
                int version = buf.readInt();
                PlayerData data = this.playerData.computeIfAbsent(pl, ignored -> new PlayerData());
                data.setMiniMapNetworkVersion(version);
                if (data.hasWorldMap()) {
                    pl.sendPluginMessage((Plugin)this, WORLD_MAP_PACKET_ID, MessageUtil.getTrackResetMessage());
                }
                pl.sendPluginMessage((Plugin)this, MINIMAP_PACKET_ID, MessageUtil.getTrackResetMessage());
                this.trackOthers(pl, MINIMAP_PACKET_ID);
            }
        });
    }

    public void onWorldMapMessageReceived(@NotNull String channel, @NotNull Player pl, byte @NotNull [] message) {
        this.trackerThread.submit(() -> {
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])message);
            if (buf.readByte() == 1) {
                int version = buf.readInt();
                PlayerData data = this.playerData.computeIfAbsent(pl, ignored -> new PlayerData());
                data.setWorldMapNetworkVersion(version);
                if (!data.hasMiniMap()) {
                    this.trackOthers(pl, WORLD_MAP_PACKET_ID);
                }
            }
        });
    }

    public boolean shouldBeTracked(Player pl) {
        return !this.trackIgnoreList.contains(pl.getName()) && !pl.isInvisible() && pl.getGameMode() != GameMode.SPECTATOR && !PlayerUtil.isVanished(pl);
    }

    public boolean shouldBeTracked(Player pl, Player other) {
        return this.trackBypassList.contains(other.getName()) || other.hasPermission(new Permission("xaerotracker.tracker." + pl.getName(), PermissionDefault.FALSE));
    }

    public void track(@NotNull Player pl, @NotNull PlayerData plData) {
        byte[] msg = MessageUtil.getTrackPlayerMessage(pl);
        boolean shouldTrack = this.shouldBeTracked(pl);
        byte[] untrackMsg = null;
        for (Player other : this.onlySyncSameWorld ? pl.getWorld().getPlayers() : pl.getServer().getOnlinePlayers()) {
            PlayerData otherData;
            if (other == pl || (otherData = this.playerData.get(other)) == null) continue;
            if (!shouldTrack && !this.shouldBeTracked(pl, other)) {
                if (!plData.lastShouldTrack) continue;
                if (untrackMsg == null) {
                    untrackMsg = MessageUtil.getUntrackPlayerMessage(pl);
                }
                this.sendModderOneChannel(other, otherData, untrackMsg);
                continue;
            }
            this.sendModderOneChannel(other, otherData, msg);
        }
        plData.lastShouldTrack = shouldTrack;
        plData.lastSyncTime = System.currentTimeMillis();
    }

    public void trackOthers(Player pl, String channel) {
        for (Player other : this.onlySyncSameWorld ? pl.getWorld().getPlayers() : pl.getServer().getOnlinePlayers()) {
            if (other == pl || !this.shouldBeTracked(other) && !this.shouldBeTracked(other, pl)) continue;
            pl.sendPluginMessage((Plugin)this, channel, MessageUtil.getTrackPlayerMessage(other));
        }
    }

    public void hideUntracked(Player pl) {
        PlayerData data = this.playerData.get(pl);
        if (data == null) {
            return;
        }
        for (Player other : this.onlySyncSameWorld ? pl.getWorld().getPlayers() : pl.getServer().getOnlinePlayers()) {
            if (other == pl || this.shouldBeTracked(other) || this.shouldBeTracked(pl, other)) continue;
            this.sendModderOneChannel(pl, data, MessageUtil.getUntrackPlayerMessage(other));
        }
    }

    public void untrack(@NotNull Player pl, @Nullable PlayerData plData) {
        if (plData != null) {
            plData.clearSyncSchedule();
        }
        byte[] msg = MessageUtil.getUntrackPlayerMessage(pl);
        for (Player other : this.onlySyncSameWorld ? pl.getWorld().getPlayers() : pl.getServer().getOnlinePlayers()) {
            PlayerData otherData;
            if (other == pl || (otherData = this.playerData.get(other)) == null) continue;
            this.sendModderOneChannel(other, otherData, msg);
        }
    }

    public void sendHandshakeInfo(Player pl) {
        this.send(pl, MessageUtil.getHandshakeMessage());
    }

    public void sendLevelId(Player pl) {
        this.send(pl, MessageUtil.getLevelIdMessage(this.levelId));
    }

    public void send(Player pl, byte[] msg) {
        pl.sendPluginMessage((Plugin)this, MINIMAP_PACKET_ID, msg);
        pl.sendPluginMessage((Plugin)this, WORLD_MAP_PACKET_ID, msg);
    }

    public void sendModderBothChannels(Player pl, @NotNull PlayerData data, byte[] msg) {
        if (data.hasMiniMap()) {
            pl.sendPluginMessage((Plugin)this, MINIMAP_PACKET_ID, msg);
        }
        if (data.hasWorldMap()) {
            pl.sendPluginMessage((Plugin)this, WORLD_MAP_PACKET_ID, msg);
        }
    }

    public void sendModderOneChannel(Player pl, @NotNull PlayerData data, byte[] msg) {
        if (data.channel != null) {
            pl.sendPluginMessage((Plugin)this, data.channel, msg);
        }
    }

    public void onDisable() {
        this.trackerThread.submit(() -> {
            this.playerData.clear();
            Messenger messenger = Bukkit.getMessenger();
            messenger.unregisterIncomingPluginChannel((Plugin)this);
            messenger.unregisterOutgoingPluginChannel((Plugin)this);
            GlobalTranslator.translator().removeSource(this.translationStore);
            this.translationStore = null;
            this.trackIgnoreList = null;
            this.trackBypassList = null;
        });
        this.trackerThread.close();
        this.trackerThread = null;
    }
}

