/*
 * Decompiled with CFR 0.152.
 */
package info.infinf.xaeroTracker.Commands;

import info.infinf.xaeroTracker.PlayerData;
import info.infinf.xaeroTracker.XaeroTracker;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Executor
implements TabExecutor {
    public static Style FAILED_STYLE = Style.style(NamedTextColor.RED);
    public static Style SUCCEEDED_STYLE = Style.style(NamedTextColor.GREEN);
    XaeroTracker plugin;

    public Executor(XaeroTracker plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (args.length < 1) {
            return false;
        }
        switch (args[0]) {
            case "toggleTracked": {
                if (args.length > 2) {
                    sender.sendMessage((Component)Component.translatable("xaerotracker.command.excess_args", FAILED_STYLE));
                    return false;
                }
                if (args.length == 1) {
                    if (sender instanceof Player) {
                        Player pl = (Player)sender;
                        if (sender.hasPermission("xaerotracker.toggleTracked")) {
                            if (this.plugin.trackIgnoreList.toggle(pl.getName())) {
                                sender.sendMessage((Component)Component.translatable("xaerotracker.command.succeed_toggle_not_be_tracked", SUCCEEDED_STYLE));
                            } else {
                                sender.sendMessage((Component)Component.translatable("xaerotracker.command.succeed_toggle_be_tracked", SUCCEEDED_STYLE));
                            }
                            PlayerData data = this.plugin.playerData.get(pl);
                            if (data != null) {
                                this.plugin.track(pl, data);
                            }
                            return true;
                        }
                        sender.sendMessage((Component)Component.translatable("xaerotracker.command.permission", FAILED_STYLE));
                        return true;
                    }
                    sender.sendMessage("You must send this as a player");
                    return true;
                }
                if (sender.hasPermission("xaerotracker.toggleTracked.others")) {
                    String name = args[1];
                    if (this.plugin.trackIgnoreList.toggle(name)) {
                        sender.sendMessage((Component)Component.translatable("xaerotracker.command.succeed_toggle_other_not_be_tracked", SUCCEEDED_STYLE, Component.text(name)));
                    } else {
                        sender.sendMessage((Component)Component.translatable("xaerotracker.command.succeed_toggle_other_be_tracked", SUCCEEDED_STYLE, Component.text(name)));
                    }
                    Player pl = this.plugin.getServer().getPlayerExact(name);
                    PlayerData data = this.plugin.playerData.get(pl);
                    if (pl != null && data != null) {
                        this.plugin.track(pl, data);
                    }
                    return true;
                }
                sender.sendMessage((Component)Component.translatable("xaerotracker.command.permission", FAILED_STYLE));
                return true;
            }
            case "toggleTrackEveryone": {
                if (args.length > 2) {
                    sender.sendMessage((Component)Component.translatable("xaerotracker.command.excess_args", FAILED_STYLE));
                    return false;
                }
                if (args.length == 1) {
                    if (sender instanceof Player) {
                        Player pl = (Player)sender;
                        if (sender.hasPermission("xaerotracker.toggleTrackEveryone")) {
                            PlayerData data = this.plugin.playerData.get(pl);
                            if (this.plugin.trackBypassList.toggle(pl.getName())) {
                                sender.sendMessage((Component)Component.translatable("xaerotracker.command.succeed_toggle_track_everyone", SUCCEEDED_STYLE));
                                if (data != null) {
                                    this.plugin.trackOthers(pl, data.channel);
                                }
                            } else {
                                sender.sendMessage((Component)Component.translatable("xaerotracker.command.succeed_toggle_not_track_everyone", SUCCEEDED_STYLE));
                                if (data != null) {
                                    this.plugin.hideUntracked(pl);
                                }
                            }
                            return true;
                        }
                        sender.sendMessage((Component)Component.translatable("xaerotracker.command.permission", FAILED_STYLE));
                        return true;
                    }
                    sender.sendMessage("You must send this as a player");
                    return true;
                }
                String name = args[1];
                if (sender.hasPermission("xaerotracker.toggleTrackEveryone.others")) {
                    Player pl = this.plugin.getServer().getPlayerExact(name);
                    PlayerData data = this.plugin.playerData.get(pl);
                    if (this.plugin.trackBypassList.toggle(name)) {
                        sender.sendMessage((Component)Component.translatable("xaerotracker.command.succeed_toggle_other_track_everyone", SUCCEEDED_STYLE, Component.text(name)));
                        if (pl != null && data != null) {
                            this.plugin.trackOthers(pl, data.channel);
                        }
                    } else {
                        sender.sendMessage((Component)Component.translatable("xaerotracker.command.succeed_toggle_other_not_track_everyone", SUCCEEDED_STYLE, Component.text(args[1])));
                        if (pl != null && data != null) {
                            this.plugin.hideUntracked(pl);
                        }
                    }
                    return true;
                }
                sender.sendMessage((Component)Component.translatable("xaerotracker.command.permission", FAILED_STYLE));
                return true;
            }
        }
        sender.sendMessage("Unknown subcommand");
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (args.length < 1) {
            return List.of();
        }
        switch (args[0]) {
            case "toggleTracked": {
                if (args.length == 2 && sender.hasPermission("xaerotracker.toggleTracked.others")) {
                    return null;
                }
                return List.of();
            }
            case "toggleTrackEveryone": {
                if (args.length == 2 && sender.hasPermission("xaerotracker.toggleTrackEveryone.others")) {
                    return null;
                }
                return List.of();
            }
        }
        ArrayList<String> res = new ArrayList<String>();
        if (sender.hasPermission("xaerotracker.toggleTracked") || sender.hasPermission("xaerotracker.toggleTracked.others")) {
            res.add("toggleTracked");
        }
        if (sender.hasPermission("xaerotracker.toggleTrackEveryone") || sender.hasPermission("xaerotracker.toggleTrackEveryone.others")) {
            res.add("toggleTrackEveryone");
        }
        return res;
    }
}

