/*
 * Decompiled with CFR 0.152.
 */
package info.infinf.xaeroTracker;

import org.jetbrains.annotations.Nullable;

public class PlayerData {
    private int worldMapNetworkVersion;
    private int miniMapNetworkVersion;
    public long lastSyncTime;
    public boolean lastShouldTrack;
    @Nullable
    public String channel;

    public PlayerData() {
        this(0, 0, 0L, false);
    }

    public PlayerData(int worldMapNetworkVersion, int miniMapNetworkVersion, long lastSyncTime, boolean lastShouldTrack) {
        this.worldMapNetworkVersion = worldMapNetworkVersion;
        this.miniMapNetworkVersion = miniMapNetworkVersion;
        this.lastSyncTime = lastSyncTime;
        this.lastShouldTrack = false;
    }

    public int getWorldMapNetworkVersion() {
        return this.worldMapNetworkVersion;
    }

    public int getMiniMapNetworkVersion() {
        return this.miniMapNetworkVersion;
    }

    public void setMiniMapNetworkVersion(int miniMapNetworkVersion) {
        this.miniMapNetworkVersion = miniMapNetworkVersion;
        this.decideChannel();
    }

    public void setWorldMapNetworkVersion(int worldMapNetworkVersion) {
        this.worldMapNetworkVersion = worldMapNetworkVersion;
        this.decideChannel();
    }

    private void decideChannel() {
        this.channel = this.miniMapNetworkVersion == 3 ? "xaerominimap:main" : (this.worldMapNetworkVersion == 3 ? "xaeroworldmap:main" : null);
    }

    public boolean hasWorldMap() {
        return this.worldMapNetworkVersion != 0;
    }

    public boolean hasMiniMap() {
        return this.miniMapNetworkVersion != 0;
    }

    public String toString() {
        return "[PlayerData: worldMapNetworkVersion=" + this.worldMapNetworkVersion + ", minimapNetworkVersion=" + this.miniMapNetworkVersion + ", lastSyncTime=" + this.lastSyncTime + " ]";
    }
}

