/*
 * Decompiled with CFR 0.152.
 */
package info.infinf.xaeroTracker;

import info.infinf.xaeroTracker.XaeroTracker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class FilePlayerList {
    @NotNull
    private static final Yaml yaml;
    private final Logger LOGGER;
    @NotNull
    private final @NotNull Set<@NotNull String> playerList;
    public File file;

    public FilePlayerList(XaeroTracker plugin, File file) {
        Set tmpPlayerList;
        this.file = file;
        this.LOGGER = plugin.getLogger();
        try (FileInputStream fis = new FileInputStream(file);){
            tmpPlayerList = (Set)yaml.load((InputStream)fis);
        }
        catch (FileNotFoundException e) {
            tmpPlayerList = new HashSet();
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, "Cannot load file " + String.valueOf(file.toPath().toAbsolutePath()), e);
            tmpPlayerList = new HashSet();
        }
        this.playerList = tmpPlayerList == null ? new HashSet() : tmpPlayerList;
    }

    public boolean toggle(String name) {
        if (this.playerList.contains(name)) {
            this.playerList.remove(name);
            this.save();
            return false;
        }
        this.playerList.add(name);
        this.save();
        return true;
    }

    public boolean contains(String name) {
        return this.playerList.contains(name);
    }

    protected void save() {
        try (FileWriter fw = new FileWriter(this.file);){
            yaml.dump(this.playerList, (Writer)fw);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setPrettyFlow(true);
        yaml = new Yaml(dumperOptions);
    }
}

