/*
 * Decompiled with CFR 0.152.
 */
package info.infinf.xaeroTracker.util;

import info.infinf.xaeroTracker.util.UUIDUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import org.bukkit.entity.Player;

public class MessageUtil {
    public static byte[] getLevelIdMessage(int levelId) {
        ByteBuf msg = Unpooled.buffer((int)5);
        msg.writeByte(0);
        msg.writeInt(levelId);
        msg.capacity(msg.writerIndex());
        return msg.array();
    }

    public static byte[] getHandshakeMessage() {
        ByteBuf msg = Unpooled.buffer((int)5);
        msg.writeByte(1);
        msg.writeInt(3);
        msg.capacity(msg.writerIndex());
        return msg.array();
    }

    public static byte[] getTrackPlayerMessage(Player pl) {
        ByteBuf msg = Unpooled.buffer((int)93);
        msg.writeByte(2);
        try (ByteBufOutputStream wrappedMsg = new ByteBufOutputStream(msg);){
            int[] uuidArray = UUIDUtil.uuidToIntArray(pl.getUniqueId());
            wrappedMsg.writeByte(10);
            wrappedMsg.writeByte(1);
            wrappedMsg.writeUTF("r");
            wrappedMsg.writeByte(0);
            wrappedMsg.writeByte(11);
            wrappedMsg.writeUTF("i");
            wrappedMsg.writeInt(uuidArray.length);
            for (int i : uuidArray) {
                wrappedMsg.writeInt(i);
            }
            wrappedMsg.writeByte(6);
            wrappedMsg.writeUTF("x");
            wrappedMsg.writeDouble(pl.getX());
            wrappedMsg.writeByte(6);
            wrappedMsg.writeUTF("y");
            wrappedMsg.writeDouble(pl.getY());
            wrappedMsg.writeByte(6);
            wrappedMsg.writeUTF("z");
            wrappedMsg.writeDouble(pl.getZ());
            wrappedMsg.writeByte(8);
            wrappedMsg.writeUTF("d");
            wrappedMsg.writeUTF(pl.getWorld().getKey().toString());
            wrappedMsg.writeByte(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        msg.capacity(msg.writerIndex());
        return msg.array();
    }

    public static byte[] getUntrackPlayerMessage(Player pl) {
        ByteBuf msg = Unpooled.buffer((int)31);
        msg.writeByte(2);
        try (ByteBufOutputStream wrappedMsg = new ByteBufOutputStream(msg);){
            int[] uuidArray = UUIDUtil.uuidToIntArray(pl.getUniqueId());
            wrappedMsg.writeByte(10);
            wrappedMsg.writeByte(1);
            wrappedMsg.writeUTF("r");
            wrappedMsg.writeByte(1);
            wrappedMsg.writeByte(11);
            wrappedMsg.writeUTF("i");
            wrappedMsg.writeInt(uuidArray.length);
            for (int i : uuidArray) {
                wrappedMsg.writeInt(i);
            }
            wrappedMsg.writeByte(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        msg.capacity(msg.writerIndex());
        return msg.array();
    }

    public static byte[] getTrackResetMessage() {
        ByteBuf msg = Unpooled.buffer((int)1);
        msg.writeByte(3);
        msg.capacity(msg.writerIndex());
        return msg.array();
    }
}

