/*
 * Decompiled with CFR 0.152.
 */
package info.infinf.xaeroTracker;

import info.infinf.xaeroTracker.PlayerData;
import info.infinf.xaeroTracker.util.MessageUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.jetbrains.annotations.NotNull;

public final class XaeroTracker
extends JavaPlugin
implements Listener {
    @NotNull
    public static final String MINIMAP_PACKET_ID = "xaerominimap:main";
    @NotNull
    public static final String WORLD_MAP_PACKET_ID = "xaeroworldmap:main";
    public final Map<Player, PlayerData> playerData = new HashMap<Player, PlayerData>();
    public boolean shouldSendLevelId;
    public int levelId;
    public long syncCooldown;

    public void onEnable() {
        this.saveDefaultConfig();
        FileConfiguration conf = this.getConfig();
        this.shouldSendLevelId = conf.getBoolean("should-send-level-id", true);
        if (!conf.contains("level-id")) {
            conf.set("level-id", (Object)new Random().nextInt());
            this.saveConfig();
        }
        this.levelId = conf.getInt("level-id");
        this.syncCooldown = conf.getInt("sync-cooldown", 250);
        Messenger messenger = Bukkit.getMessenger();
        messenger.registerIncomingPluginChannel((Plugin)this, MINIMAP_PACKET_ID, this::onMinimapMessageReceived);
        messenger.registerIncomingPluginChannel((Plugin)this, WORLD_MAP_PACKET_ID, this::onWorldMapMessageReceived);
        messenger.registerOutgoingPluginChannel((Plugin)this, MINIMAP_PACKET_ID);
        messenger.registerOutgoingPluginChannel((Plugin)this, WORLD_MAP_PACKET_ID);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player pl = e.getPlayer();
        try {
            Method addChannel = pl.getClass().getMethod("addChannel", String.class);
            addChannel.invoke((Object)pl, MINIMAP_PACKET_ID);
            addChannel.invoke((Object)pl, WORLD_MAP_PACKET_ID);
            this.sendHandshakeInfo(pl);
            if (this.shouldSendLevelId) {
                this.sendLevelId(pl);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            ex.printStackTrace();
        }
        pl.getWorld().getName();
        this.track(pl);
        this.playerData.put(pl, new PlayerData(System.currentTimeMillis()));
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent e) {
        if (!this.shouldSendLevelId) {
            return;
        }
        Player pl = e.getPlayer();
        PlayerData data = this.playerData.get(pl);
        if (data != null) {
            this.sendModderBothChannels(pl, data, MessageUtil.getLevelIdMessage(this.levelId));
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        if (!e.hasExplicitlyChangedPosition()) {
            return;
        }
        Player pl = e.getPlayer();
        long current = System.currentTimeMillis();
        PlayerData data = this.playerData.computeIfAbsent(pl, ignored -> new PlayerData());
        if (current - data.lastSyncTime >= this.syncCooldown) {
            this.track(pl);
            data.lastSyncTime = current;
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        Player pl = e.getPlayer();
        this.untrack(pl);
        this.playerData.remove(pl);
    }

    public void onMinimapMessageReceived(@NotNull String channel, @NotNull Player pl, byte @NotNull [] message) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])message);
        if (buf.readByte() == 1) {
            int version = buf.readInt();
            PlayerData data = this.playerData.computeIfAbsent(pl, ignored -> new PlayerData());
            data.setMiniMapNetworkVersion(version);
        }
        pl.sendPluginMessage((Plugin)this, MINIMAP_PACKET_ID, MessageUtil.getTrackResetMessage());
        this.trackOthers(pl, MINIMAP_PACKET_ID);
    }

    public void onWorldMapMessageReceived(@NotNull String channel, @NotNull Player pl, byte @NotNull [] message) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])message);
        if (buf.readByte() == 1) {
            int version = buf.readInt();
            PlayerData data = this.playerData.computeIfAbsent(pl, ignored -> new PlayerData());
            data.setWorldMapNetworkVersion(version);
        }
        pl.sendPluginMessage((Plugin)this, WORLD_MAP_PACKET_ID, MessageUtil.getTrackResetMessage());
        this.trackOthers(pl, WORLD_MAP_PACKET_ID);
    }

    public void track(Player pl) {
        byte[] msg = MessageUtil.getTrackPlayerMessage(pl);
        Server server = pl.getServer();
        for (Player other : server.getOnlinePlayers()) {
            PlayerData data;
            if (other == pl || (data = this.playerData.get(other)) == null) continue;
            this.sendModderOneChannel(other, data, msg);
        }
    }

    public void trackOthers(Player pl, String channel) {
        for (Player other : pl.getServer().getOnlinePlayers()) {
            if (other == pl) continue;
            pl.sendPluginMessage((Plugin)this, channel, MessageUtil.getTrackPlayerMessage(other));
        }
    }

    public void untrack(Player pl) {
        byte[] msg = MessageUtil.getUntrackPlayerMessage(pl);
        for (Player other : pl.getServer().getOnlinePlayers()) {
            PlayerData data;
            if (other == pl || (data = this.playerData.get(other)) == null) continue;
            this.sendModderOneChannel(other, data, msg);
        }
    }

    public void sendHandshakeInfo(Player pl) {
        this.send(pl, MessageUtil.getHandshakeMessage());
    }

    public void sendLevelId(Player pl) {
        this.send(pl, MessageUtil.getLevelIdMessage(this.levelId));
    }

    public void send(Player pl, byte[] msg) {
        pl.sendPluginMessage((Plugin)this, WORLD_MAP_PACKET_ID, msg);
        pl.sendPluginMessage((Plugin)this, MINIMAP_PACKET_ID, msg);
    }

    public void sendModderBothChannels(Player pl, @NotNull PlayerData data, byte[] msg) {
        if (data.hasMiniMap()) {
            pl.sendPluginMessage((Plugin)this, MINIMAP_PACKET_ID, msg);
        }
        if (data.hasWorldMap()) {
            pl.sendPluginMessage((Plugin)this, WORLD_MAP_PACKET_ID, msg);
        }
    }

    public void sendModderOneChannel(Player pl, @NotNull PlayerData data, byte[] msg) {
        if (data.channel != null) {
            pl.sendPluginMessage((Plugin)this, data.channel, msg);
        }
    }

    public void onDisable() {
        this.playerData.clear();
        Messenger messenger = Bukkit.getMessenger();
        messenger.unregisterIncomingPluginChannel((Plugin)this);
        messenger.unregisterOutgoingPluginChannel((Plugin)this);
    }
}

