/*
 * Decompiled with CFR 0.152.
 */
package org.oreo.kitsorter.client;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.HashMap;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.oreo.kitsorter.client.clothconfig.ConfEnums;
import org.oreo.kitsorter.client.clothconfig.ModConfig;
import org.oreo.kitsorter.client.fetcher.JsonFetcher;
import org.oreo.kitsorter.client.mapstuff.DynampUtils;
import org.oreo.kitsorter.client.mapstuff.DynmapFetcher;
import org.oreo.kitsorter.client.stolen.ForEachBlockContainerTask;
import org.oreo.kitsorter.client.stolen.utils.TaskType;

@Environment(value=EnvType.CLIENT)
public class KitsorterClient
implements ClientModInitializer {
    public static HashMap<String, String> blackListedPlayers = new HashMap();
    public static HashMap<String, String> blackListedNations = new HashMap();
    public static HashMap<String, String> blackListedTowns = new HashMap();
    public static boolean globalSwitch = true;
    public static String latestVersion = "";
    public static boolean isCached = false;
    public static boolean processStopped = false;
    private static boolean keyPressed = false;
    private static class_2338 posSelected1;
    private static class_2338 posSelected2;
    private static boolean isPos1Selected;

    public void onInitializeClient() {
        AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);
        DynmapFetcher.initialize();
        System.out.println("[DishWasherMod] Kitsorter Client Initializing");
        class_304 sortItems = new class_304("Sort your items", 74, "Dishwasher mod");
        KeyBindingHelper.registerKeyBinding((class_304)sortItems);
        class_304 openConfig = new class_304("Open config", 76, "Dishwasher mod");
        KeyBindingHelper.registerKeyBinding((class_304)openConfig);
        class_304 selectLocations = new class_304("Select position", 72, "Dishwasher mod");
        KeyBindingHelper.registerKeyBinding((class_304)selectLocations);
        class_304 takeSetItems = new class_304("Take set items", 90, "Dishwasher mod");
        KeyBindingHelper.registerKeyBinding((class_304)takeSetItems);
        class_304 stopBind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Stop process", class_3675.class_307.field_1668, 73, "Dishwasher mod"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            boolean isKeyCurrentlyPressed;
            if (openConfig.method_1436()) {
                if (!KitsorterClient.isModActive()) {
                    return;
                }
                class_437 configScreen = (class_437)AutoConfig.getConfigScreen(ModConfig.class, (class_437)client.field_1755).get();
                client.method_1507(configScreen);
            }
            if (sortItems.method_1436()) {
                if (!KitsorterClient.isModActive()) {
                    return;
                }
                ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
                if (config.sortType.equals((Object)ConfEnums.SortingType.HORIZONTAL)) {
                    KitsorterClient.sortItems(TaskType.SET_DEPO_HORIZONTAL);
                } else {
                    KitsorterClient.sortItems(TaskType.SET_DEPO);
                }
            }
            if (takeSetItems.method_1436()) {
                if (!KitsorterClient.isModActive()) {
                    return;
                }
                KitsorterClient.sortItems(TaskType.SET_TAKE);
            }
            if (selectLocations.method_1436()) {
                class_239 hit = client.field_1765;
                if (hit instanceof class_3965) {
                    class_2338 blockHit = ((class_3965)hit).method_17777();
                    if (!isPos1Selected) {
                        posSelected1 = blockHit;
                        isPos1Selected = true;
                        class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)("\u00a7bBlock at " + blockHit.method_10263() + "," + blockHit.method_10264() + "," + blockHit.method_10260() + " selected as position 1")), true);
                    } else {
                        posSelected2 = blockHit;
                        isPos1Selected = false;
                        class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)("\u00a7bBlock at " + blockHit.method_10263() + "," + blockHit.method_10264() + "," + blockHit.method_10260() + " selected as position 2")), true);
                    }
                } else {
                    class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)"\u00a7cNo block selected"), true);
                }
            }
            if ((isKeyCurrentlyPressed = class_3675.method_15987((long)GLFW.glfwGetCurrentContext(), (int)stopBind.method_1429().method_1444())) && !keyPressed) {
                keyPressed = true;
                if (client.field_1724 != null) {
                    processStopped = true;
                }
            } else if (!isKeyCurrentlyPressed && keyPressed) {
                keyPressed = false;
            }
            ClientPlayConnectionEvents.JOIN.register((handler, sender, client1) -> {
                if (!JsonFetcher.isFetchingPlayers) {
                    JsonFetcher.isFetchingPlayers = true;
                    new Thread(() -> {
                        JsonFetcher.fetchSiteData();
                        DynmapFetcher.doTerritoryAssociation();
                        JsonFetcher.isFetchingPlayers = false;
                    }).start();
                }
            });
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"AddLocation").executes(context -> {
                class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)"\u00a7bLocation has been added to your list"), false);
                isPos1Selected = false;
                String firstCoords = "<" + posSelected1.method_10263() + "," + posSelected1.method_10264() + "," + posSelected1.method_10260() + ">";
                String secondCoords = "<" + posSelected2.method_10263() + "," + posSelected2.method_10264() + "," + posSelected2.method_10260() + ">";
                ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
                config.locations.add(firstCoords + "||" + secondCoords);
                AutoConfig.getConfigHolder(ModConfig.class).save();
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"DMretry").executes(context -> {
                class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)"\u00a7bRetrying player data fetch..."), true);
                JsonFetcher.fetchSiteData();
                isCached = false;
                return 1;
            }));
        });
    }

    public static String getModVersion(String modId) {
        return ((ModContainer)FabricLoader.getInstance().getModContainer(modId).orElseThrow(() -> new RuntimeException("Mod not found: " + modId))).getMetadata().getVersion().getFriendlyString();
    }

    public static void sortItems(TaskType taskType) {
        assert (class_310.method_1551().field_1724 != null);
        assert (class_310.method_1551().field_1719 != null);
        assert (class_310.method_1551().field_1761 != null);
        new ForEachBlockContainerTask(class_310.method_1551(), class_310.method_1551().field_1719, (class_1937)class_310.method_1551().field_1687, class_310.method_1551().field_1724, class_310.method_1551().field_1761, taskType).start();
    }

    private static boolean isModActive() {
        if (isCached) {
            KitsorterClient.scheduleReCheck();
            return true;
        }
        if (!globalSwitch) {
            class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)"\u00a7c\u00a7lGLOBAL SHUTDOWN ACTIVATED"), true);
            class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)"\u00a7c\u00a7lGLOBAL SHUTDOWN ACTIVATED"), false);
            return false;
        }
        if (!latestVersion.isBlank() && !latestVersion.equals(KitsorterClient.getModVersion("kitsorter"))) {
            class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)("\u00a7c\u00a7lOutdated version please use " + latestVersion)), true);
            class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)("\u00a7c\u00a7lPlease use " + latestVersion)), false);
            return false;
        }
        String blackListedPlayerReason = KitsorterClient.isPlayerBlackListed();
        String blackListedTownReason = KitsorterClient.isInBlackListedTown();
        String blackListedNationReason = KitsorterClient.isInBlackListedNation();
        if (blackListedPlayerReason == null && blackListedTownReason == null && blackListedNationReason == null) {
            return true;
        }
        String message = KitsorterClient.getDisabledMessage(blackListedPlayerReason, blackListedTownReason, blackListedNationReason);
        class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)message), true);
        class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)message), false);
        return false;
    }

    @NotNull
    private static String getDisabledMessage(String blackListedPlayerReason, String blackListedTownReason, String blackListedNationReason) {
        Object message = blackListedPlayerReason != null ? (!blackListedPlayerReason.isBlank() ? "\u00a7c\u00a7l" + blackListedPlayerReason : "\u00a7c\u00a7lYou have lost your sorting privileges") : (blackListedTownReason != null ? (!blackListedTownReason.isBlank() ? "\u00a7c\u00a7l" + blackListedTownReason : "\u00a7c\u00a7lYour town has lost sorting privileges") : (!blackListedNationReason.isBlank() ? "\u00a7c\u00a7l" + blackListedNationReason : "\u00a7c\u00a7lYour nation has lost sorting privileges"));
        return message;
    }

    @Nullable
    public static String isPlayerBlackListed() {
        return blackListedPlayers.get(class_310.method_1551().method_53462().getName());
    }

    private static String isInBlackListedNation() {
        if (DynampUtils.getClientResident() == null) {
            return null;
        }
        return blackListedNations.get(DynampUtils.getClientResident().getNation());
    }

    private static String isInBlackListedTown() {
        if (DynampUtils.getClientResident() == null) {
            return null;
        }
        return blackListedTowns.get(DynampUtils.getClientResident().getTown());
    }

    private static void scheduleReCheck() {
        new Thread(() -> {
            try {
                Thread.sleep(3600000L);
                JsonFetcher.fetchSiteData();
                isCached = false;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }).start();
    }

    static {
        isPos1Selected = false;
    }
}

