/*
 * Decompiled with CFR 0.152.
 */
package org.oreo.kitsorter.client.fetcher;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.oreo.kitsorter.client.KitsorterClient;

@Environment(value=EnvType.CLIENT)
public class JsonFetcher {
    public static boolean isFetchingPlayers = false;

    public static void fetchSiteData() {
        try {
            String inputLine;
            String url = "https://crusalisutils.clanweb.eu/names.json";
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("HTTP error: " + conn.getResponseCode());
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            String json = response.toString();
            JsonFetcher.parseJsonToEnabledPlayers(json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void parseJsonToEnabledPlayers(String json) {
        try {
            Gson gson = new Gson();
            Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
            Map data = (Map)gson.fromJson(json, mapType);
            List blackListedPlayersList = data.getOrDefault("blackListedPlayers", List.of());
            List blackListedNationsList = data.getOrDefault("blackListedNations", List.of());
            List blackListedTownsList = data.getOrDefault("blackListedTowns", List.of());
            KitsorterClient.globalSwitch = data.getOrDefault("globalSwitch", true);
            KitsorterClient.latestVersion = data.getOrDefault("latestVers", "");
            KitsorterClient.blackListedPlayers.clear();
            KitsorterClient.blackListedNations.clear();
            KitsorterClient.blackListedTowns.clear();
            for (List entry : blackListedPlayersList) {
                if (entry.size() != 2) continue;
                KitsorterClient.blackListedPlayers.put((String)entry.get(0), (String)entry.get(1));
            }
            for (List entry : blackListedNationsList) {
                if (entry.size() != 2) continue;
                KitsorterClient.blackListedNations.put((String)entry.get(0), (String)entry.get(1));
            }
            for (List entry : blackListedTownsList) {
                if (entry.size() != 2) continue;
                KitsorterClient.blackListedTowns.put((String)entry.get(0), (String)entry.get(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

