/*
 * Decompiled with CFR 0.152.
 */
package org.oreo.kitsorter.client.mapstuff;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.oreo.kitsorter.client.mapstuff.DynmapFetcher;
import org.oreo.kitsorter.client.mapstuff.PLAYER_RELATION;
import org.oreo.kitsorter.client.mapstuff.dynmap.NationData;
import org.oreo.kitsorter.client.mapstuff.dynmap.ResidentData;

@Environment(value=EnvType.CLIENT)
public class DynampUtils {
    private static ResidentData clientResident;
    private static NationData clientNation;

    public static ResidentData getPlayerResident(String playerName) {
        for (ResidentData resident : DynmapFetcher.getResidentData()) {
            if (!resident.getName().equalsIgnoreCase(playerName)) continue;
            return resident;
        }
        return null;
    }

    public static ResidentData getClientResident() {
        if (clientResident != null) {
            return clientResident;
        }
        clientResident = DynampUtils.getPlayerResident(class_310.method_1551().method_53462().getName());
        return clientResident;
    }

    public static NationData getPlayerDetectedNation(String playerName) {
        ResidentData resident = DynampUtils.getPlayerResident(playerName);
        if (resident == null) {
            return null;
        }
        String nationName = resident.getNation();
        if (nationName == null) {
            return null;
        }
        for (NationData nation : DynmapFetcher.getNationData()) {
            if (!nation.getName().equals(nationName)) continue;
            return nation;
        }
        return null;
    }

    public static NationData getClientDetectedNation() {
        if (clientNation != null) {
            return clientNation;
        }
        clientNation = DynampUtils.getPlayerDetectedNation(class_310.method_1551().method_53462().getName());
        return clientNation;
    }

    public static PLAYER_RELATION getPlayerToClientRelation(String targetName) {
        NationData clientNation = DynampUtils.getClientDetectedNation();
        NationData targetNation = DynampUtils.getPlayerDetectedNation(targetName);
        if (clientNation == null || targetNation == null) {
            return PLAYER_RELATION.NEUTRAL;
        }
        if (clientNation.getName().equals(targetNation.getName())) {
            ResidentData clientResident = DynampUtils.getClientResident();
            ResidentData targetResident = DynampUtils.getPlayerResident(targetName);
            if (clientResident.getTown().equals(targetResident.getTown())) {
                return PLAYER_RELATION.TOWN;
            }
            return PLAYER_RELATION.NATION;
        }
        if (clientNation.getAllies().contains(targetNation.getName())) {
            return PLAYER_RELATION.ALLIED;
        }
        if (clientNation.getEnemies().contains(targetNation.getName())) {
            return PLAYER_RELATION.ENEMIES;
        }
        return PLAYER_RELATION.NEUTRAL;
    }
}

