/*
 * Decompiled with CFR 0.152.
 */
package org.oreo.kitsorter.client.mapstuff;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.oreo.kitsorter.client.mapstuff.dynmap.NationData;
import org.oreo.kitsorter.client.mapstuff.dynmap.ResidentData;
import org.oreo.kitsorter.client.mapstuff.dynmap.TerritoryData;
import org.oreo.kitsorter.client.mapstuff.dynmap.TownData;

@Environment(value=EnvType.CLIENT)
public class DynmapFetcher {
    static String mapLink = "https://map.crusalis.net";
    private static final String DYNMAP_TOWNS = mapLink + "/nodes/towns.json";
    private static final String DYNMAP_WORLD = mapLink + "/nodes/world.json";
    private static ArrayList<TownData> townData = new ArrayList();
    private static ArrayList<TerritoryData> territoryData = new ArrayList();
    private static ArrayList<NationData> nationData = new ArrayList();
    private static ArrayList<ResidentData> residentData = new ArrayList();
    private static final Object refreshLock = new Object();

    public static CompletableFuture<Void> initialize() {
        return DynmapFetcher.refreshAllData();
    }

    public static void doTerritoryAssociation() {
        for (TerritoryData territory : territoryData) {
            block1: for (TownData town : townData) {
                for (int territoryId : town.getTerritories()) {
                    if (territoryId != territory.getId()) continue;
                    territory.town = town.getName();
                    continue block1;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompletableFuture<Void> refreshAllData() {
        Object object = refreshLock;
        synchronized (object) {
            CompletableFuture<ArrayList<ResidentData>> residentFuture = DynmapFetcher.updateResidentData();
            CompletableFuture<ArrayList<TownData>> townFuture = DynmapFetcher.updateTownData();
            CompletableFuture<ArrayList<NationData>> nationFuture = DynmapFetcher.updateNationData();
            CompletableFuture<ArrayList<TerritoryData>> territoryFuture = DynmapFetcher.updateTerritoryData();
            return CompletableFuture.allOf(townFuture, nationFuture, territoryFuture, residentFuture).thenAccept(v -> {
                residentData = (ArrayList)residentFuture.join();
                townData = (ArrayList)townFuture.join();
                nationData = (ArrayList)nationFuture.join();
                territoryData = (ArrayList)territoryFuture.join();
            });
        }
    }

    public static ArrayList<TownData> getTownData() {
        return new ArrayList<TownData>(townData);
    }

    public static ArrayList<NationData> getNationData() {
        return new ArrayList<NationData>(nationData);
    }

    public static ArrayList<TerritoryData> getTerritoryData() {
        return new ArrayList<TerritoryData>(territoryData);
    }

    public static ArrayList<ResidentData> getResidentData() {
        return new ArrayList<ResidentData>(residentData);
    }

    public static CompletableFuture<String> fetchDynmapData(String link) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String line;
                URL url = new URL(link);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                int responseCode = conn.getResponseCode();
                if (responseCode != 200) {
                    DynmapFetcher.sendErrorMessage(link);
                    return null;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder responseBuilder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    responseBuilder.append(line);
                }
                reader.close();
                return responseBuilder.toString();
            }
            catch (Exception e) {
                DynmapFetcher.sendErrorMessage(link);
                return null;
            }
        });
    }

    private static void sendErrorMessage(String link) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            if (link.contains("towns.json")) {
                String type = "Town";
            } else if (link.contains("ports.json")) {
                String type = "Ports";
            } else if (link.contains("world.json")) {
                String type = "World";
            } else {
                String type = "Unknown";
            }
            client.execute(() -> client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7lWrong dynmap link!").method_27692(class_124.field_1061), false));
        }
    }

    private static CompletableFuture<ArrayList<TownData>> updateTownData() {
        return DynmapFetcher.fetchDynmapData(DYNMAP_TOWNS).thenCompose(json -> {
            ArrayList<TownData> towns = new ArrayList<TownData>();
            if (json == null) {
                return CompletableFuture.completedFuture(towns);
            }
            try {
                JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
                if (!root.has("towns")) {
                    return CompletableFuture.completedFuture(towns);
                }
                JsonObject townsJson = root.getAsJsonObject("towns");
                for (String townName : townsJson.keySet()) {
                    JsonArray homeArray;
                    JsonObject townJson = townsJson.getAsJsonObject(townName);
                    double[] coords = new double[2];
                    if (townJson.has("spawn") && townJson.get("spawn").isJsonArray() && (homeArray = townJson.getAsJsonArray("spawn")).size() >= 3) {
                        coords[0] = homeArray.get(0).getAsDouble();
                        coords[1] = homeArray.get(2).getAsDouble();
                    }
                    ArrayList<Integer> territoriesList = new ArrayList<Integer>();
                    if (townJson.has("territories")) {
                        JsonArray territoriesJson = townJson.getAsJsonArray("territories");
                        for (JsonElement element : territoriesJson) {
                            territoriesList.add(element.getAsInt());
                        }
                    }
                    int[] territories = territoriesList.stream().mapToInt(i -> i).toArray();
                    towns.add(new TownData(townName, coords, territories));
                }
            }
            catch (Exception e) {
                System.out.println("Error updating town data" + String.valueOf(e));
            }
            return CompletableFuture.completedFuture(towns);
        });
    }

    private static CompletableFuture<ArrayList<NationData>> updateNationData() {
        return DynmapFetcher.fetchDynmapData(DYNMAP_TOWNS).thenCompose(json -> {
            ArrayList<NationData> nations = new ArrayList<NationData>();
            if (json == null) {
                return CompletableFuture.completedFuture(nations);
            }
            try {
                JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
                if (!root.has("nations")) {
                    return CompletableFuture.completedFuture(nations);
                }
                JsonObject nationsJson = root.getAsJsonObject("nations");
                for (String nationName : nationsJson.keySet()) {
                    JsonObject nationJson = nationsJson.getAsJsonObject(nationName);
                    if (!nationJson.has("capital") || !nationJson.has("towns") || !nationJson.has("allies") || !nationJson.has("enemies")) continue;
                    String capital = nationJson.get("capital").getAsString();
                    JsonArray townsArray = nationJson.getAsJsonArray("towns");
                    JsonArray alliesArray = nationJson.getAsJsonArray("allies");
                    JsonArray enemiesArray = nationJson.getAsJsonArray("enemies");
                    String[] towns = new String[townsArray.size()];
                    for (int i = 0; i < townsArray.size(); ++i) {
                        towns[i] = townsArray.get(i).getAsString();
                    }
                    String[] allies = new String[alliesArray.size()];
                    for (int i = 0; i < alliesArray.size(); ++i) {
                        allies[i] = alliesArray.get(i).getAsString();
                    }
                    String[] enemies = new String[enemiesArray.size()];
                    for (int i = 0; i < enemiesArray.size(); ++i) {
                        enemies[i] = enemiesArray.get(i).getAsString();
                    }
                    nations.add(new NationData(nationName, capital, towns, allies, enemies));
                }
            }
            catch (Exception e) {
                System.out.println("Error updating nation data" + String.valueOf(e));
            }
            return CompletableFuture.completedFuture(nations);
        });
    }

    private static CompletableFuture<ArrayList<TerritoryData>> updateTerritoryData() {
        return DynmapFetcher.fetchDynmapData(DYNMAP_WORLD).thenCompose(json -> {
            ArrayList<TerritoryData> territories = new ArrayList<TerritoryData>();
            if (json == null) {
                return CompletableFuture.completedFuture(territories);
            }
            try {
                JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
                if (!root.has("territories")) {
                    return CompletableFuture.completedFuture(territories);
                }
                JsonObject territoriesJson = root.getAsJsonObject("territories");
                for (String territoryName : territoriesJson.keySet()) {
                    JsonObject territoryJson = territoriesJson.getAsJsonObject(territoryName);
                    if (!territoryJson.has("chunks")) continue;
                    int id = Integer.parseInt(territoryName);
                    JsonArray chunksJson = territoryJson.getAsJsonArray("chunks");
                    ArrayList<Integer> chunksList = new ArrayList<Integer>();
                    for (JsonElement chunkElement : chunksJson) {
                        chunksList.add(chunkElement.getAsInt());
                    }
                    int[] chunks = chunksList.stream().mapToInt(i -> i).toArray();
                    int size = territoryJson.has("size") ? territoryJson.get("size").getAsInt() : 0;
                    territories.add(new TerritoryData(id, chunks, size));
                }
            }
            catch (Exception e) {
                System.out.println("Error updating territory data" + String.valueOf(e));
            }
            return CompletableFuture.completedFuture(territories);
        });
    }

    private static CompletableFuture<ArrayList<ResidentData>> updateResidentData() {
        return DynmapFetcher.fetchDynmapData(DYNMAP_TOWNS).thenCompose(json -> {
            ArrayList<ResidentData> residents = new ArrayList<ResidentData>();
            if (json == null) {
                return CompletableFuture.completedFuture(residents);
            }
            try {
                JsonObject rootJson = JsonParser.parseString((String)json).getAsJsonObject();
                JsonObject residentsJson = rootJson.getAsJsonObject("residents");
                if (residentsJson != null) {
                    for (Map.Entry entry : residentsJson.entrySet()) {
                        residents.add(DynmapFetcher.parseResidentData(entry));
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Error updating resident data" + String.valueOf(e));
            }
            return CompletableFuture.completedFuture(residents);
        });
    }

    @NotNull
    private static ResidentData parseResidentData(Map.Entry<String, JsonElement> entry) {
        JsonObject residentObject = entry.getValue().getAsJsonObject();
        String name = residentObject.has("name") ? residentObject.get("name").getAsString() : null;
        String town = residentObject.has("town") && !residentObject.get("town").isJsonNull() ? residentObject.get("town").getAsString() : null;
        String nation = residentObject.has("nation") && !residentObject.get("nation").isJsonNull() ? residentObject.get("nation").getAsString() : null;
        return new ResidentData(name, town, nation);
    }

    public static String fetchPlayerNationName(String playerName) {
        ArrayList<ResidentData> residents = DynmapFetcher.getResidentData();
        if (residents.isEmpty()) {
            System.out.println("Resident data is null or empty");
            return null;
        }
        for (ResidentData resident : residents) {
            if (!resident.getName().equalsIgnoreCase(playerName)) continue;
            return resident.getNation();
        }
        if (class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)"\u00a7c\u00a7lERROR Not a resident of a town"), false);
        }
        return "";
    }
}

