/*
 * Decompiled with CFR 0.152.
 */
package org.oreo.kitsorter.client.stolen;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.oreo.kitsorter.client.clothconfig.ModConfig;
import org.oreo.kitsorter.client.stolen.ForEachContainerTask;
import org.oreo.kitsorter.client.stolen.utils.MathUtil;
import org.oreo.kitsorter.client.stolen.utils.TaskType;

@Environment(value=EnvType.CLIENT)
public class ForEachBlockContainerTask
extends ForEachContainerTask {
    private final class_1937 world;
    private final class_636 interactionManager;
    private final float squaredReachDistance;
    private final class_1297 cameraEntity;
    private final TaskType taskType;
    private final Iterator<class_2338> blocks;
    private final Set<class_2338> searchedBlocks = new HashSet<class_2338>();

    public ForEachBlockContainerTask(class_310 client, class_1297 cameraEntity, class_1937 world, class_746 player, class_636 interactionManager, TaskType taskType) {
        super(client, player, taskType);
        this.world = world;
        this.interactionManager = interactionManager;
        assert (client.field_1724 != null);
        float reachDistance = (float)client.field_1724.method_55754();
        this.squaredReachDistance = class_3532.method_27285((float)reachDistance);
        this.cameraEntity = cameraEntity;
        this.blocks = MathUtil.getBlocksInBox(MathUtil.getBox(cameraEntity.method_5836(0.0f), reachDistance)).iterator();
        this.taskType = taskType;
    }

    @Override
    protected boolean findAndOpenNextContainer() {
        block4: while (this.blocks.hasNext()) {
            class_2338 pos = this.blocks.next().method_10062();
            if (this.searchedBlocks.contains(pos) || !this.isOpenable(this.world, pos)) continue;
            ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
            switch (this.taskType) {
                case SET_TAKE: {
                    if (!config.ignorePlots || !this.isWithinAreas(pos, config)) break;
                    continue block4;
                }
                case SET_DEPO: 
                case SET_DEPO_HORIZONTAL: {
                    if (!config.useLocations || this.isWithinAreas(pos, config)) break;
                    continue block4;
                }
            }
            class_2680 state = this.world.method_8320(pos);
            class_243 origin = this.cameraEntity.method_5836(0.0f);
            class_243 closestPos = MathUtil.getClosestPoint(pos, state.method_26218((class_1922)this.world, pos), origin);
            if (closestPos.method_1025(origin) > (double)this.squaredReachDistance) continue;
            this.searchedBlocks.add(pos);
            this.getTheOtherHalfOfLargeChest(this.world, pos).ifPresent(this.searchedBlocks::add);
            class_3965 hitResult = new class_3965(closestPos, MathUtil.getFacingDirection(closestPos.method_1020(origin)).method_10153(), pos, false);
            this.interactionManager.method_2896(this.player, class_1268.field_5808, hitResult);
            return true;
        }
        return false;
    }

    private boolean isOpenable(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof class_1263) && block != class_2246.field_10443) {
            return false;
        }
        if (this.isBlockDisabled(block)) {
            return false;
        }
        if (state.method_26204() instanceof class_2281 || state.method_26204() == class_2246.field_10443) {
            if (class_2281.method_9756((class_1936)world, (class_2338)pos)) {
                return false;
            }
            return this.getTheOtherHalfOfLargeChest(world, pos).map(offsetPos -> !class_2281.method_9756((class_1936)world, (class_2338)offsetPos)).orElse(true);
        }
        return true;
    }

    private Optional<class_2338> getTheOtherHalfOfLargeChest(class_1937 world, class_2338 pos) {
        class_2338 offsetPos;
        class_2680 theOtherHalf;
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() instanceof class_2281 && state.method_11654((class_2769)class_2281.field_10770) != class_2745.field_12569 && (theOtherHalf = world.method_8320(offsetPos = pos.method_10093(class_2281.method_9758((class_2680)state)))).method_26204() == state.method_26204() && state.method_11654((class_2769)class_2281.field_10768) == theOtherHalf.method_11654((class_2769)class_2281.field_10768) && class_2281.method_9758((class_2680)state) == class_2281.method_9758((class_2680)theOtherHalf).method_10153()) {
            return Optional.ofNullable(offsetPos);
        }
        return Optional.empty();
    }

    private boolean isBlockDisabled(class_2248 block) {
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        return block == class_2246.field_16328 && config.ignoreBarrels || block == class_2246.field_10034 && config.ignoreChests || block == class_2246.field_10312 && config.ignoreHoppers;
    }

    private boolean isWithinAreas(class_2338 blockPos, ModConfig config) {
        for (String area : config.locations) {
            int[] pos2;
            int[] pos1 = ForEachBlockContainerTask.extract3DCoordinates(area)[0];
            if (!ForEachBlockContainerTask.isPointInsideCuboid(blockPos, pos1, pos2 = ForEachBlockContainerTask.extract3DCoordinates(area)[1])) continue;
            return true;
        }
        return false;
    }

    public static boolean isPointInsideCuboid(class_2338 posToCheck, int[] corner1, int[] corner2) {
        int x1 = posToCheck.method_10263();
        int y1 = posToCheck.method_10264();
        int z1 = posToCheck.method_10260();
        int x2 = corner1[0];
        int y2 = corner1[1];
        int z2 = corner1[2];
        int px = corner2[0];
        int py = corner2[1];
        int pz = corner2[2];
        int minX = Math.min(x2, px);
        int maxX = Math.max(x2, px);
        int minY = Math.min(y2, py);
        int maxY = Math.max(y2, py);
        int minZ = Math.min(z2, pz);
        int maxZ = Math.max(z2, pz);
        return minX <= x1 && x1 <= maxX && minY <= y1 && y1 <= maxY && minZ <= z1 && z1 <= maxZ;
    }

    private static int[][] extract3DCoordinates(String input) {
        String escapedSeparator = Pattern.quote("||");
        String pattern = "<(-?\\d+),(-?\\d+),(-?\\d+)>" + escapedSeparator + "<(-?\\d+),(-?\\d+),(-?\\d+)>";
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(input);
        if (matcher.matches()) {
            int x1 = Integer.parseInt(matcher.group(1));
            int y1 = Integer.parseInt(matcher.group(2));
            int z1 = Integer.parseInt(matcher.group(3));
            int x2 = Integer.parseInt(matcher.group(4));
            int y2 = Integer.parseInt(matcher.group(5));
            int z2 = Integer.parseInt(matcher.group(6));
            return new int[][]{{x1, y1, z1}, {x2, y2, z2}};
        }
        class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cERROR Input does not match the expected format: <x,y,z>||<x,y,z>"), false);
        throw new IllegalArgumentException("Input does not match the expected format: <x,y,z>||<x,y,z>");
    }
}

