/*
 * Decompiled with CFR 0.152.
 */
package org.oreo.kitsorter.client.stolen;

import com.mojang.text2speech.Narrator;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_418;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.oreo.kitsorter.client.KitsorterClient;
import org.oreo.kitsorter.client.clothconfig.ModConfig;
import org.oreo.kitsorter.client.stolen.interfac.OnKeyCallback;
import org.oreo.kitsorter.client.stolen.interfac.SetScreenCallback;
import org.oreo.kitsorter.client.stolen.utils.TaskType;

@Environment(value=EnvType.CLIENT)
public abstract class ForEachContainerTask {
    private static final ScheduledThreadPoolExecutor TIMER = new ScheduledThreadPoolExecutor(1);
    private static ForEachContainerTask currentTask;
    protected final class_310 client;
    protected final class_746 player;
    private final int searchInterval;
    private final ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
    private boolean interrupted;
    private TaskType taskType;
    @Nullable
    private ForEachContainerTask after;

    public ForEachContainerTask(class_310 client, class_746 player, TaskType taskType) {
        this.client = client;
        this.player = player;
        this.taskType = taskType;
        this.searchInterval = this.config.searchInterval;
        ForEachContainerTask.init();
    }

    public static void init() {
        SetScreenCallback.EVENT.register(screen -> {
            if (ForEachContainerTask.isRunning()) {
                if (screen instanceof class_418) {
                    currentTask.interrupt();
                    return class_1269.field_5811;
                }
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        OnKeyCallback.PRESS.register(key -> {
            if (ForEachContainerTask.isRunning()) {
                if (key == 256) {
                    currentTask.interrupt();
                }
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        ClientReceiveMessageEvents.GAME.register((message, overlay) -> {
            class_2588 translatable;
            class_7417 patt0$temp;
            if (ForEachContainerTask.isRunning() && (patt0$temp = message.method_10851()) instanceof class_2588 && (translatable = (class_2588)patt0$temp).method_11022().equals("container.isLocked")) {
                ForEachContainerTask.getCurrentTask().openNextContainer();
            }
        });
    }

    public static ForEachContainerTask getCurrentTask() {
        return currentTask;
    }

    public static boolean isRunning() {
        return currentTask != null;
    }

    public void start() {
        currentTask = this;
        this.openNextContainerExceptionHandled();
    }

    protected void stop() {
        class_310.method_1551().execute(() -> this.player.method_7346());
        TIMER.getQueue().clear();
        currentTask = null;
    }

    public void interrupt() {
        this.sendChatMessage("stack-to-nearby-chests.message.actionInterrupted");
        this.interrupted = true;
    }

    public void onInventory() {
        if (this.config.debugMode) {
            ForEachContainerTask.sendGameDebugMessage("New container");
        }
        System.out.println("NEW CONTAINER OPENED");
        if (KitsorterClient.processStopped) {
            this.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Stopped chest process"), false);
            KitsorterClient.processStopped = false;
            this.stop();
            return;
        }
        switch (this.taskType) {
            case SET_DEPO: {
                this.depoSet();
                break;
            }
            case SET_TAKE: {
                this.takeSetItems();
            }
        }
    }

    private void depoSet() {
        class_1661 playerInv = this.client.field_1724.method_31548();
        if (!playerInv.method_5442()) {
            class_1703 class_17032 = class_310.method_1551().field_1724.field_7512;
            if (!(class_17032 instanceof class_1707)) {
                return;
            }
            class_1707 handler = (class_1707)class_17032;
            class_1263 inventory = handler.method_7629();
            if (this.config.useOverrideItemMovement) {
                this.client.field_1761.method_2906(handler.field_7763, this.config.takeSlot + inventory.method_5439(), 0, class_1713.field_7791, (class_1657)this.player);
                this.client.field_1761.method_2906(handler.field_7763, this.config.putSlot, 0, class_1713.field_7791, (class_1657)this.player);
                return;
            }
            new Thread(() -> this.lambda$depoSet$4(inventory, (class_1263)playerInv, handler)).start();
        } else {
            class_5250 message = class_2561.method_43470((String)"\u00a7lYour inventory is empty").method_27692(class_124.field_1061);
            this.client.field_1724.method_7353((class_2561)message, false);
            this.interrupted = true;
        }
        this.clearTimeout();
        this.openNextContainer();
    }

    private void takeSetItems() {
        class_1661 playerInv = this.client.field_1724.method_31548();
        if (ForEachContainerTask.isInventoryFull((class_1263)playerInv)) {
            class_5250 message = class_2561.method_43470((String)"\u00a7lYour inventory is full").method_27692(class_124.field_1061);
            this.client.field_1724.method_7353((class_2561)message, false);
            this.interrupted = true;
            this.clearTimeout();
            this.openNextContainer();
            return;
        }
        class_1703 class_17032 = this.client.field_1724.field_7512;
        if (!(class_17032 instanceof class_1707)) {
            return;
        }
        class_1707 handler = (class_1707)class_17032;
        class_1263 inventory = handler.method_7629();
        new Thread(() -> {
            for (int targetSlot = 0; targetSlot < inventory.method_5439(); ++targetSlot) {
                if (this.interrupted) {
                    KitsorterClient.processStopped = false;
                    break;
                }
                class_1799 stack = inventory.method_5438(targetSlot);
                if (stack.method_7960()) continue;
                int finalSlot = targetSlot;
                this.client.execute(() -> this.client.field_1761.method_2906(handler.field_7763, finalSlot, 0, class_1713.field_7794, (class_1657)this.client.field_1724));
                try {
                    Thread.sleep(this.config.timeBetweenItems);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.client.execute(() -> {
                this.clearTimeout();
                this.openNextContainer();
            });
        }).start();
    }

    private void openNextContainer() {
        if (this.interrupted) {
            this.stop();
            return;
        }
        if (this.searchInterval == 0) {
            this.openNextContainerExceptionHandled();
        } else {
            TIMER.schedule(() -> this.client.execute(this::openNextContainerExceptionHandled), (long)this.searchInterval, TimeUnit.MILLISECONDS);
        }
    }

    private void openNextContainerExceptionHandled() {
        try {
            if (this.findAndOpenNextContainer()) {
                this.setTimeout();
            } else if (this.after != null) {
                this.after.start();
            } else {
                this.stop();
            }
        }
        catch (Exception e) {
            this.sendChatMessage("stack-to-nearby-chests.message.exceptionOccurred");
            Narrator.LOGGER.error("An exception occurred", (Throwable)e);
            this.stop();
        }
    }

    protected abstract boolean findAndOpenNextContainer();

    private void setTimeout() {
        TIMER.schedule(() -> this.client.execute(() -> {
            this.sendChatMessage("Time Out started something went wrong");
            this.stop();
        }), 2L, TimeUnit.SECONDS);
    }

    private void clearTimeout() {
        TIMER.getQueue().clear();
    }

    private void sendChatMessage(String key) {
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)key));
    }

    private boolean isSetItem(class_1799 stack) {
        return this.config.setItems.contains(class_7923.field_41178.method_10221((Object)stack.method_7909()).toString());
    }

    private boolean isSpecificSetItem(class_1799 stack, String item) {
        return item.equals(class_7923.field_41178.method_10221((Object)stack.method_7909()).toString());
    }

    private static void sendGameDebugMessage(String message) {
        class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)message), false);
    }

    public static boolean isInventoryFull(class_1263 inventory) {
        for (int i = 0; i < inventory.method_5439() - 5; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    private /* synthetic */ void lambda$depoSet$4(class_1263 inventory, class_1263 playerInv, class_1707 handler) {
        ArrayList<Integer> takenSLots = new ArrayList<Integer>();
        int targetSlot = 0;
        int kitsDeposited = 0;
        while (targetSlot < inventory.method_5439()) {
            if (this.interrupted) {
                KitsorterClient.processStopped = false;
                break;
            }
            if (kitsDeposited >= this.config.kitsPerBarrel || kitsDeposited != 0 && this.config.setItems.size() / kitsDeposited < 1) break;
            for (String setItem : this.config.setItems) {
                if (setItem.equals(class_7923.field_41178.method_10221((Object)inventory.method_5438(targetSlot).method_7909()).toString()) || !playerInv.method_18862(Set.of((class_1792)class_7923.field_41178.method_63535(class_2960.method_12829((String)setItem))))) {
                    ++targetSlot;
                    continue;
                }
                for (int slot = 0; slot < playerInv.method_5439(); ++slot) {
                    if (this.client.field_1761 == null) {
                        this.interrupted = true;
                        break;
                    }
                    class_1799 stack = playerInv.method_5438(slot);
                    if (takenSLots.contains(slot) || stack.method_7960() || !this.isSpecificSetItem(stack, setItem)) continue;
                    takenSLots.add(slot);
                    System.out.println("Item of type:" + stack.method_7909().method_7876());
                    try {
                        Thread.sleep(this.config.timeBetweenItems);
                        if (slot <= 8) {
                            this.client.field_1761.method_2906(handler.field_7763, targetSlot, slot, class_1713.field_7791, (class_1657)this.player);
                            inventory.method_5431();
                            playerInv.method_5431();
                            this.clearTimeout();
                            break;
                        }
                        int slotToTakeFrom = slot + inventory.method_5439() - 9;
                        if (slotToTakeFrom >= inventory.method_5439() + playerInv.method_5439()) {
                            ForEachContainerTask.sendGameDebugMessage("\u00a7cSlot index index is over limit, slot :" + slotToTakeFrom + " limit: " + (inventory.method_5439() + playerInv.method_5439()));
                            this.clearTimeout();
                            break;
                        }
                        System.out.println("Picking up at " + slotToTakeFrom);
                        if (this.config.debugMode) {
                            ForEachContainerTask.sendGameDebugMessage("Picking up at " + slotToTakeFrom + " of type " + stack.method_7909().method_7876());
                        }
                        this.client.field_1761.method_2906(handler.field_7763, slotToTakeFrom, 0, class_1713.field_7791, (class_1657)this.player);
                        if (this.config.debugMode) {
                            ForEachContainerTask.sendGameDebugMessage("Putting down on " + targetSlot);
                        }
                        Thread.sleep(this.config.timeBetweenItems);
                        this.client.field_1761.method_2906(handler.field_7763, targetSlot, 0, class_1713.field_7791, (class_1657)this.player);
                        Thread.sleep(this.config.timeBetweenItems);
                        this.client.field_1761.method_2906(handler.field_7763, slotToTakeFrom, 0, class_1713.field_7791, (class_1657)this.player);
                        inventory.method_5431();
                        playerInv.method_5431();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.clearTimeout();
                    break;
                }
                ++targetSlot;
            }
            ++kitsDeposited;
        }
        boolean hasSetItems = false;
        for (int slot = 0; slot < playerInv.method_5439(); ++slot) {
            class_1799 stack = playerInv.method_5438(slot);
            if (!this.isSetItem(stack)) continue;
            hasSetItems = true;
            break;
        }
        this.interrupted = !hasSetItems;
        this.clearTimeout();
        this.openNextContainer();
    }
}

