/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation;

import com.google.gson.Gson;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.LoggerBase;
import com.holybuckets.foundation.config.PerformanceImpactConfig;
import com.holybuckets.foundation.datastore.DataStore;
import com.holybuckets.foundation.event.EventRegistrar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.balm.api.event.client.ConnectedToServerEvent;
import net.blay09.mods.balm.api.event.client.DisconnectedFromServerEvent;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_5217;
import net.minecraft.server.MinecraftServer;

public class GeneralConfig {
    public static final String CLASS_ID = "000";
    public static final Gson GSON = new Gson();
    private static GeneralConfig instance;
    private DataStore dataStore;
    private ExecutorService watchExecutorService;
    private volatile boolean running = true;
    private Boolean isClientSide;
    private MinecraftServer server;
    private final Map<String, class_1936> LEVELS;
    private Map<class_1936, class_2382> WORLD_SPAWNS;
    private Long worldSeed;
    private boolean isWorldConfigInit;
    private Boolean isPlayerLoaded;
    private PerformanceImpactConfig performanceImpactConfig;

    private GeneralConfig() {
        instance = this;
        LoggerBase.logInit(null, "000000", this.getClass().getName());
        this.isClientSide = false;
        this.isPlayerLoaded = false;
        this.LEVELS = new HashMap<String, class_1936>();
        this.WORLD_SPAWNS = new HashMap<class_1936, class_2382>();
        this.running = true;
        this.isWorldConfigInit = false;
    }

    public static void init(EventRegistrar reg) {
        if (instance != null) {
            return;
        }
        instance = new GeneralConfig();
        GeneralConfig.instance.dataStore = DataStore.init();
        reg.registerOnConnectedToServer(instance::onPlayerConnectedToServerEvent, EventPriority.Highest);
        reg.registerOnDisconnectedFromServer(instance::onPlayerDisconnectedFromServerEvent, EventPriority.Lowest);
        reg.registerOnBeforeServerStarted(instance::onBeforeServerStarted, EventPriority.Highest);
        reg.registerOnServerStopped(instance::onServerStopped, EventPriority.Lowest);
        reg.registerOnLevelLoad(instance::onLoadLevel, EventPriority.Highest);
        reg.registerOnLevelUnload(instance::onUnLoadLevel, EventPriority.Lowest);
        reg.registerOnPlayerLoad(instance::initPlayerConfigs, EventPriority.Highest);
    }

    private void initPerformanceConfig() {
        this.performanceImpactConfig = new PerformanceImpactConfig();
    }

    public static GeneralConfig getInstance() {
        return instance;
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public Map<String, class_1936> getLevels() {
        return new HashMap<String, class_1936>(this.LEVELS);
    }

    public void onPlayerConnectedToServerEvent(ConnectedToServerEvent event) {
        this.isClientSide = true;
        this.initPerformanceConfig();
    }

    public void onPlayerDisconnectedFromServerEvent(DisconnectedFromServerEvent event) {
        this.isClientSide = null;
    }

    public void onBeforeServerStarted(ServerStartingEvent event) {
        this.isClientSide = false;
        this.initPerformanceConfig();
        if (this.server == null) {
            this.server = event.getServer();
        }
        if (!this.isWorldConfigInit) {
            this.worldSeed = this.server.method_27728().method_28057().method_28028();
            if (this.worldSeed != null) {
                this.isWorldConfigInit = true;
                LoggerBase.logInfo(null, "010001", "World Seed: " + this.worldSeed);
            }
        }
        this.dataStore = DataStore.init();
        this.dataStore.onBeforeServerStarted(event);
        this.watchExecutorService = Executors.newSingleThreadExecutor();
        this.watchExecutorService.submit(this::startAutoSaveThread);
    }

    public void onServerStopped(ServerStoppedEvent event) {
        if (this.dataStore == null) {
            return;
        }
        this.dataStore.onServerStopped(event);
        this.dataStore = null;
        this.server = null;
        this.isClientSide = null;
    }

    public void onLoadLevel(LevelLoadingEvent.Load event) {
        class_1936 level = event.getLevel();
        this.LEVELS.put(HBUtil.LevelUtil.toLevelId(level), level);
        class_5217 data = level.method_8401();
        class_2338 spawn = new class_2338(data.method_215(), data.method_144(), data.method_166());
        this.WORLD_SPAWNS.put(level, (class_2382)spawn);
    }

    public void onUnLoadLevel(LevelLoadingEvent.Unload event) {
    }

    public boolean isWorldConfigInit() {
        return this.isWorldConfigInit;
    }

    public void initPlayerConfigs(PlayerLoginEvent event) {
        this.isPlayerLoaded = true;
        LoggerBase.logDebug(null, "006001", "Player Logged In");
    }

    @Nullable
    class_1936 getLevel(String id) {
        if (this.LEVELS == null) {
            return null;
        }
        class_1936 level = this.LEVELS.get(id);
        if (level == null) {
            return null;
        }
        return level;
    }

    public Long getWorldSeed() {
        return this.worldSeed;
    }

    public class_2382 getWorldSpawn(class_1936 level) {
        return this.WORLD_SPAWNS.get(level);
    }

    public Boolean getIsPLAYER_LOADED() {
        return this.isPlayerLoaded;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public long getTotalTickCount() {
        GeneralConfig generalConfig = this;
        return generalConfig.dataStore.getTotalTickCount() + (long)this.server.method_3780();
    }

    public PerformanceImpactConfig getPerformanceImpactConfig() {
        if (this.performanceImpactConfig == null) {
            this.initPerformanceConfig();
        }
        return this.performanceImpactConfig;
    }

    private void startAutoSaveThread() {
        while (this.running) {
            try {
                Thread.sleep(30000L);
                if (!this.running) continue;
                EventRegistrar.getInstance().dataSaveEvent();
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void stopAutoSaveThread() {
        try {
            this.watchExecutorService.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            this.watchExecutorService.shutdownNow();
        }
        catch (InterruptedException e) {
            LoggerBase.logError(null, "006002", "Error stopping AutoSaveThread");
        }
    }
}

