/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.LoggerBase;
import com.holybuckets.foundation.block.ModBlocks;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.modelInterface.IStringSerializable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmRegistries;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.balm.api.network.BalmNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;

public class HBUtil {
    public static final String CLASS_ID = "004";
    private static class_2818 threadedChunkResult = null;

    public static class Fast3DArray {
        private int[] X;
        private int[] Y;
        private int[] Z;
        public int size = 0;
        public final int MAX_SIZE;

        public Fast3DArray(int size) {
            this.MAX_SIZE = size;
            this.X = new int[size];
            this.Y = new int[size];
            this.Z = new int[size];
        }

        public void add(class_2338 pos) {
            this.add(pos.method_10263(), pos.method_10264(), pos.method_10260());
        }

        public void add(int x, int y, int z) {
            if (this.size >= this.MAX_SIZE) {
                return;
            }
            this.X[this.size] = x;
            this.Y[this.size] = y;
            this.Z[this.size] = z;
            ++this.size;
        }

        public void addAll(Fast3DArray other) {
            for (int i = 0; i < other.size; ++i) {
                this.add(other.X[i], other.Y[i], other.Z[i]);
            }
        }

        public int[][] get(int index) {
            if (index >= this.MAX_SIZE || index < 0) {
                return null;
            }
            return new int[][]{{this.X[index], this.Y[index], this.Z[index]}};
        }

        public int getX(int index) {
            return this.X[index];
        }

        public int getY(int index) {
            return this.Y[index];
        }

        public int getZ(int index) {
            return this.Z[index];
        }

        public TripleInt[] toArray() {
            TripleInt[] arr = new TripleInt[this.size];
            for (int i = 0; i < this.size; ++i) {
                arr[i] = new TripleInt(this.X[i], this.Y[i], this.Z[i]);
            }
            return arr;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Count: " + this.size + " ");
            String delimiter = "";
            for (int i = 0; i < this.size; ++i) {
                sb.append(delimiter);
                sb.append("[" + this.X[i] + ", " + this.Y[i] + ", " + this.Z[i] + "]");
                delimiter = ", ";
            }
            return sb.toString();
        }
    }

    public static class Validator {
        private static final HashSet<String> ACCEPTED_STRING_BOOLEAN_TRUE = new HashSet<String>(Arrays.asList("TRUE", "true", "yes", "1"));

        public static boolean validateNumber(Number value, ConfigNumber n, String element) {
            StringBuilder error = new StringBuilder();
            error.append("Error setting ");
            error.append(n.name);
            error.append(element);
            error.append(" using default value of ");
            error.append(n.current + " instead");
            if (value.doubleValue() >= ((Number)n.min).doubleValue() && value.doubleValue() <= ((Number)n.max).doubleValue()) {
                return true;
            }
            LoggerBase.logWarning(null, "001002", error.toString());
            return false;
        }

        public static Boolean parseBoolean(String value) {
            return ACCEPTED_STRING_BOOLEAN_TRUE.contains(value);
        }

        public static class ConfigNumber<T extends Number> {
            private final String name;
            private final T min;
            private final T max;
            private T current;

            public ConfigNumber(String name, T current, T min, T max) {
                if (((Comparable)min).compareTo(max) > 0) {
                    throw new IllegalArgumentException("Min value cannot be greater than max value.");
                }
                if (((Comparable)current).compareTo(min) < 0 || ((Comparable)current).compareTo(max) > 0) {
                    throw new IllegalArgumentException("Current value must be within the range of min and max.");
                }
                this.name = name;
                this.min = min;
                this.max = max;
                this.current = current;
            }

            public T get() {
                return this.current;
            }

            public void set(T value) {
                if (!this.test(value)) {
                    throw new IllegalArgumentException("Value is out of range: " + value);
                }
                this.current = value;
            }

            public boolean test(T value) {
                return ((Comparable)value).compareTo(this.min) >= 0 && ((Comparable)value).compareTo(this.max) <= 0;
            }

            public String toString() {
                return "ConfigNumber{name='" + this.name + "', min=" + this.min + ", max=" + this.max + ", current=" + this.current + "}";
            }
        }
    }

    public static class WorldPos {
        public class_2338 blockPos;
        public TripleInt sectionIndicies;
        public int sectionIndex;
        public static final int SECTION_SZ = 16;
        public boolean DNE = false;

        public WorldPos(class_2338 pos, class_2791 chunk) {
            this.blockPos = pos;
            this.setWorldPos(pos, chunk);
        }

        public WorldPos(TripleInt indices, int section, class_2791 chunk) {
            this.sectionIndicies = indices;
            this.sectionIndex = section;
            this.setWorldPos(indices, section, chunk);
        }

        public void setWorldPos(class_2338 pos, class_2791 chunk) {
            this.blockPos = pos;
            class_2338 chunkPos = chunk.method_12004().method_8323();
            Integer Y_MIN = chunk.method_31607();
            Integer Y_MAX = chunk.method_31600();
            int x = pos.method_10263() - chunkPos.method_10263();
            int z = pos.method_10260() - chunkPos.method_10260();
            this.sectionIndex = (pos.method_10264() - Y_MIN) / 16;
            int y = (pos.method_10264() - Y_MIN) % 16;
            this.sectionIndicies = new TripleInt(x, y, z);
        }

        public void setWorldPos(TripleInt indices, int section, class_2791 chunk) {
            class_2338 chunkPos = chunk.method_12004().method_8323();
            Integer Y_MIN = chunk.method_31607();
            Integer Y_MAX = chunk.method_31600();
            int x = chunkPos.method_10263() + indices.x;
            int y = Y_MIN + 16 * section + indices.y;
            int z = chunkPos.method_10260() + indices.z;
            this.blockPos = new class_2338(x, y, z);
        }

        public class_2338 getWorldPos() {
            return this.blockPos;
        }

        public TripleInt getIndices() {
            return this.sectionIndicies;
        }

        public Integer getSectionIndex() {
            return this.sectionIndex;
        }

        public int getX() {
            return this.blockPos.method_10263();
        }

        public int getY() {
            return this.blockPos.method_10264();
        }

        public int getZ() {
            return this.blockPos.method_10260();
        }

        public String sectionToString() {
            return "Indicies{x,y,z=" + this.sectionIndicies + ", sectionIndex=" + this.sectionIndex + "}";
        }

        public String worldPosToString() {
            return "WorldPos{blockPos=" + this.blockPos + "}";
        }
    }

    public static class TripleInt {
        public int x;
        public int y;
        public int z;

        public TripleInt(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public TripleInt(class_2382 vec) {
            this.x = vec.method_10263();
            this.y = vec.method_10264();
            this.z = vec.method_10260();
        }

        public static TripleInt of(int x, int y, int z) {
            return new TripleInt(x, y, z);
        }

        public String toString() {
            return "[" + this.x + ", " + this.y + ", " + this.z + "]";
        }
    }

    public static class FileIO {
        public static String loadJsonConfigs(File userConfigFile, File defaultConfigFile, IStringSerializable defaultData) {
            File configFile = userConfigFile;
            String DEFAULT_DATA = defaultData.serialize();
            if (!configFile.exists()) {
                StringBuilder warnNoUserFile = new StringBuilder();
                warnNoUserFile.append("Could not find the provided  config file at path: ");
                warnNoUserFile.append(configFile.getAbsolutePath());
                warnNoUserFile.append(". Provided file name from serverConfig/hbs_ore_clusters_and_regen-server.toml: ");
                warnNoUserFile.append(configFile.getPath());
                warnNoUserFile.append(". Attempting to load the default file at default location: ");
                warnNoUserFile.append(configFile.getAbsolutePath());
                LoggerBase.logWarning(null, "000001", warnNoUserFile.toString());
                configFile = defaultConfigFile;
                if (!configFile.exists()) {
                    StringBuilder warnNoDefaultFile = new StringBuilder();
                    warnNoDefaultFile.append("Could not find the default  JSON config file at path: ");
                    warnNoDefaultFile.append(configFile.getAbsolutePath());
                    warnNoDefaultFile.append(". A default file will be created for future reference.");
                    LoggerBase.logError(null, "000002", warnNoDefaultFile.toString());
                    try {
                        configFile.createNewFile();
                    }
                    catch (Exception e) {
                        StringBuilder error = new StringBuilder();
                        error.append("Could not create the default  JSON config file at path: ");
                        error.append(configFile.getAbsolutePath());
                        error.append(" due to an unknown exception. The game will still run using default values from memory.");
                        error.append("  You can try running the game as an administrator or update the file permissions to fix this issue.");
                        LoggerBase.logError(null, "000003", error.toString());
                        return DEFAULT_DATA;
                    }
                    FileIO.serializeJsonConfigs(configFile, DEFAULT_DATA);
                }
            }
            String json = "";
            try {
                json = Files.readString(Paths.get(configFile.getAbsolutePath(), new String[0]));
            }
            catch (IOException e) {
                StringBuilder error = new StringBuilder();
                error.append("Could not read the  JSON config file at path: ");
                error.append(configFile.getAbsolutePath());
                error.append(" due to an unknown exception. The game will still run using default values from memory.");
                LoggerBase.logError(null, "000004", error.toString());
                return DEFAULT_DATA;
            }
            return json;
        }

        public static boolean serializeJsonConfigs(File configFile, String jsonData) {
            try {
                Files.write(Paths.get(configFile.getAbsolutePath(), new String[0]), jsonData.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                StringBuilder error = new StringBuilder();
                error.append("Could not write JSON data to config file at path: ");
                error.append(configFile.getAbsolutePath());
                error.append(" due to an unknown exception.");
                error.append("  You can try running the game as an administrator or check the file permissions.");
                LoggerBase.logError(null, "000004", error.toString());
                return false;
            }
            return true;
        }

        public static JsonElement arrayToJson(String[] arr) {
            Gson gson = new GsonBuilder().serializeNulls().create();
            return gson.toJsonTree((Object)arr);
        }
    }

    public static class NetworkUtil {
        private static int SENT = 0;
        private static boolean CLIENT_STARTED = false;
        private static boolean USING_DEDICATED_SERVER = false;
        private static BalmNetworking networking = Balm.getNetworking();
        private static MinecraftServer server;
        private static final Queue<Runnable> PENDING_TASKS;
        public static final ThreadPoolExecutor POOL;

        private static <T> void sendHandler(Runnable r) {
            if (CLIENT_STARTED) {
                POOL.submit(r);
            } else {
                PENDING_TASKS.add(r);
            }
        }

        public static <T> void serverSendToAllPlayers(T message) {
            NetworkUtil.sendHandler(() -> networking.sendToAll(server, message));
        }

        public static <T> void serverSendToPlayer(class_1657 player, T message) {
            NetworkUtil.sendHandler(() -> networking.sendTo(player, message));
        }

        public static void init(EventRegistrar reg) {
            reg.registerOnServerStarted(NetworkUtil::onServerStart);
            reg.registerOnPlayerLoad(NetworkUtil::onPlayerConnectedEvent);
        }

        private static void onServerStart(ServerStartedEvent event) {
            if (event.getServer().method_3816()) {
                USING_DEDICATED_SERVER = true;
                CLIENT_STARTED = true;
            }
            server = GeneralConfig.getInstance().getServer();
        }

        private static void onPlayerConnectedEvent(PlayerLoginEvent event) {
            Runnable task;
            CLIENT_STARTED = true;
            while ((task = PENDING_TASKS.poll()) != null) {
                POOL.submit(task);
            }
        }

        static {
            PENDING_TASKS = new LinkedBlockingQueue<Runnable>();
            POOL = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        }
    }

    public static class ShapeUtil {
        public static Fast3DArray getCircle(int radius) {
            if (radius <= 0) {
                return null;
            }
            Fast3DArray circle = new Fast3DArray(4 * (radius + 1) * (radius + 1));
            circle.add(0, 0, 0);
            if (radius <= 1) {
                return circle;
            }
            if (radius == 2) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        circle.add(x, 0, z);
                    }
                }
                return circle;
            }
            double softness = 0.5;
            double radiusSquared = Math.ceil((double)(--radius) + softness) * ((double)radius + softness);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (!((double)(x * x + z * z) <= radiusSquared)) continue;
                    circle.add(x, 0, z);
                }
            }
            return circle;
        }

        public static Fast3DArray getSphere(int radius, int height) {
            if (radius <= 0 || height <= 0) {
                return null;
            }
            if (height < 2) {
                return ShapeUtil.getCircle(radius);
            }
            if (radius < 4) {
                Fast3DArray sphere = new Fast3DArray(height * 9);
                Fast3DArray circle = ShapeUtil.getCircle(1);
                for (int y = 0; y < height; ++y) {
                    for (int i = 0; i < circle.size; ++i) {
                        sphere.add(circle.X[i], y, circle.Z[i]);
                    }
                }
                return sphere;
            }
            Fast3DArray sphere = new Fast3DArray((int)((double)(height * radius * radius) * Math.PI * 2.0));
            int halfHeight = (int)Math.floor(height / 2);
            double[] radii = new double[halfHeight + 1];
            double deltaRadiusPerHt = (double)radius / (double)height;
            for (int y = 0; y <= halfHeight; ++y) {
                radii[y] = y == 0 ? (double)radius : radii[y - 1] - deltaRadiusPerHt - 0.01;
            }
            int yAdj = 0;
            for (int y = halfHeight * -1; y <= halfHeight; ++y) {
                if (height % 2 == 0 && y == 0) {
                    yAdj = -1;
                    continue;
                }
                Fast3DArray layer = ShapeUtil.getCircle((int)Math.ceil(radii[Math.abs(y)]));
                for (int i = 0; i < layer.size; ++i) {
                    sphere.add(layer.X[i], y + yAdj, layer.Z[i]);
                }
            }
            return sphere;
        }

        public static Fast3DArray getSquare(int length, int width) {
            if (length <= 0 || width <= 0) {
                return null;
            }
            Fast3DArray square = new Fast3DArray(length * width + 1);
            int modL = length % 2 == 0 ? 1 : 0;
            int modW = width % 2 == 0 ? 1 : 0;
            int xStart = -length / 2 + modL;
            int zStart = -width / 2 + modW;
            if (length == 1 && width == 1) {
                square.add(0, 0, 0);
                return square;
            }
            if (length == 1) {
                for (int z = zStart; z <= width / 2; ++z) {
                    square.add(0, 0, z);
                }
                return square;
            }
            if (width == 1) {
                for (int x = xStart; x <= length / 2; ++x) {
                    square.add(x, 0, 0);
                }
                return square;
            }
            if (length == 2 && width == 2) {
                square.add(-1, 0, -1);
                square.add(-1, 0, 1);
                square.add(1, 0, -1);
                square.add(1, 0, 1);
                return square;
            }
            if (length == 2) {
                for (int z = zStart; z <= width / 2; ++z) {
                    square.add(-1, 0, z);
                    square.add(1, 0, z);
                }
                return square;
            }
            if (width == 2) {
                for (int x = xStart; x <= length / 2; ++x) {
                    square.add(x, 0, -1);
                    square.add(x, 0, 1);
                }
                return square;
            }
            for (int x = xStart; x <= length / 2; ++x) {
                for (int z = zStart; z <= width / 2; ++z) {
                    square.add(x, 0, z);
                }
            }
            return square;
        }

        public static Fast3DArray getCube(int length, int width, int height) {
            if (height <= 0 || length <= 0 || width <= 0) {
                return null;
            }
            Fast3DArray cube = new Fast3DArray(height * length * width);
            for (int y = 0; y < height; ++y) {
                Fast3DArray plane = ShapeUtil.getSquare(length, width);
                for (int i = 0; i < plane.size; ++i) {
                    cube.add(plane.X[i], y, plane.Z[i]);
                }
            }
            return cube;
        }
    }

    public static class ChunkUtil {
        public static String getId(class_2791 chunk) {
            return chunk.method_12004().field_9181 + "," + chunk.method_12004().field_9180;
        }

        public static String getId(int x, int z) {
            return x + "," + z;
        }

        public static String getId(class_1923 pos) {
            return pos.field_9181 + "," + pos.field_9180;
        }

        public static String getId(class_2338 pos) {
            return ChunkUtil.getId(Math.floorDiv(pos.method_10263(), 16), Math.floorDiv(pos.method_10260(), 16));
        }

        public static class_2338 getWorldPos(String id) {
            return ChunkUtil.getChunkPos(id).method_8323();
        }

        public static class_1923 getChunkPos(String id) {
            String[] parts = id.split(",");
            return new class_1923(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
        }

        public static class_1923 getChunkPos(class_2338 pos) {
            String id = ChunkUtil.getId(pos);
            String[] parts = id.split(",");
            return new class_1923(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
        }

        public static boolean checkInBounds(class_2791 chunk, int x, int z) {
            return chunk.method_12004().field_9181 >= -x && chunk.method_12004().field_9181 <= x && chunk.method_12004().field_9180 >= -z && chunk.method_12004().field_9180 <= z;
        }

        public static int chunkDistSquared(class_1923 p1, class_1923 p2) {
            return (p1.field_9181 - p2.field_9181) * (p1.field_9181 - p2.field_9181) + (p1.field_9180 - p2.field_9180) * (p1.field_9180 - p2.field_9180);
        }

        public static float chunkDist(class_1923 p1, class_1923 p2) {
            return (float)Math.sqrt(ChunkUtil.chunkDistSquared(p1, p2));
        }

        public static float chunkDist(String id1, String id2) {
            return ChunkUtil.chunkDist(ChunkUtil.getChunkPos(id1), ChunkUtil.getChunkPos(id2));
        }

        public static class_1923 posAdd(class_1923 p, int x, int z) {
            return new class_1923(p.field_9181 + x, p.field_9180 + z);
        }

        public static class_1923 posAdd(class_1923 p1, class_1923 p2) {
            return new class_1923(p1.field_9181 + p2.field_9181, p1.field_9180 + p2.field_9180);
        }

        public static class_1923 posAdd(class_1923 p1, int[] dir) {
            return new class_1923(p1.field_9181 + dir[0], p1.field_9180 + dir[1]);
        }

        public static Long getChunkPos1DMap(String id) {
            return ChunkUtil.getChunkPos1DMap(ChunkUtil.getChunkPos(id));
        }

        public static Long getChunkPos1DMap(class_1923 pos) {
            Long WIDTH = 10000000L;
            return (long)pos.field_9181 * WIDTH + (long)pos.field_9180;
        }

        public static List<String> getLocalChunkIds(class_1923 center, int radius) {
            ArrayList<String> ids = new ArrayList<String>();
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    ids.add(ChunkUtil.getId(ChunkUtil.posAdd(center, x, z)));
                }
            }
            return ids;
        }

        public static class_2818 getLevelChunk(class_1936 level, int x, int z, boolean forceLoad) {
            if (Math.abs(x) > 25 || Math.abs(z) > 25) {
                boolean bl = false;
            }
            if (level == null) {
                return null;
            }
            if (level.method_8398() == null) {
                return null;
            }
            if (level.method_8398().method_14151() == 0) {
                return null;
            }
            if (forceLoad) {
                return level.method_8398().method_12126(x, z, true);
            }
            class_2818 c = level.method_8398().method_21730(x, z);
            return c;
        }
    }

    public static class LevelUtil {
        @Nullable
        public static class_1936 toLevel(LevelNameSpace nameSpace, String dimensionId) {
            Object levelId = dimensionId.replace("CLIENT:", "").replace("SERVER:", "");
            if (nameSpace == LevelNameSpace.CLIENT) {
                levelId = "CLIENT:" + (String)levelId;
            } else if (nameSpace == LevelNameSpace.SERVER) {
                levelId = "SERVER:" + (String)levelId;
            }
            return LevelUtil.toLevel((String)levelId);
        }

        public static class_1936 toServerLevel(String id) {
            return LevelUtil.toLevel(LevelNameSpace.SERVER, id);
        }

        public static class_1936 toClientLevel(String id) {
            return LevelUtil.toLevel(LevelNameSpace.CLIENT, id);
        }

        private static class_1936 toLevel(String id) {
            return GeneralConfig.getInstance().getLevel(id);
        }

        public static String toLevelId(class_1936 level) {
            if (level == null) {
                return null;
            }
            String levelName = level.method_8597().comp_655().toString();
            if (level.method_8608()) {
                return "CLIENT:" + levelName;
            }
            return "SERVER:" + levelName;
        }

        public static enum LevelNameSpace {
            CLIENT,
            SERVER;

        }
    }

    public static class BlockUtil {
        public static String blockToString(class_2248 blockType) {
            if (blockType == null) {
                LoggerBase.logError(null, "004000", "Error parsing blockType to string, blockType is null");
                return null;
            }
            return blockType.toString().replace("Block{", "").replace("}", "");
        }

        public static class_2248 blockNameToBlock(String blockName) {
            if (blockName == null || blockName.isEmpty()) {
                LoggerBase.logError(null, "004001", "Error parsing block name as string into a Minecraft Block type, type provided was null or provided as empty string");
                return ModBlocks.empty;
            }
            if (blockName.contains(":")) {
                String[] parts = blockName.split(":");
                return BlockUtil.blockNameToBlock(parts[0], parts[1]);
            }
            return BlockUtil.blockNameToBlock("minecraft", blockName);
        }

        public static class_2248 blockNameToBlock(String namespace, String blockName) {
            class_2960 blockKey;
            BalmRegistries registries;
            class_2248 b;
            if (blockName == null || blockName.isEmpty()) {
                LoggerBase.logError(null, "004001", "Error parsing block name as string into a Minecraft Block type, type provided was null or provided as empty string");
                return null;
            }
            if (namespace == null || namespace.isEmpty()) {
                namespace = "minecraft";
            }
            if ((b = (registries = Balm.getRegistries()).getBlock(blockKey = new class_2960(namespace.trim(), blockName.trim()))) == null) {
                LoggerBase.logError(null, "004002", "Error parsing block name as string into a Minecraft Block type, block name provided was not found in Minecraft Block registry: " + blockName);
            }
            return b;
        }

        public static String positionToString(class_2338 pos) {
            if (pos == null) {
                return null;
            }
            return "[" + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260() + "]";
        }

        public static List<Pair<class_2680, class_2338>> findBlockPos(List<Pair<class_2680, class_2338>> all, Integer x, Integer y, Integer z) {
            ArrayList<Pair<class_2680, class_2338>> found = new ArrayList<Pair<class_2680, class_2338>>();
            for (Pair<class_2680, class_2338> p : all) {
                if (x != null && ((class_2338)p.getRight()).method_10263() != x.intValue() || y != null && ((class_2338)p.getRight()).method_10264() != y.intValue() || z != null && ((class_2338)p.getRight()).method_10260() != z.intValue()) continue;
                found.add(p);
            }
            return found;
        }

        public static boolean inRange(Pair<class_2680, class_2338> p, class_2338 center, int radius) {
            return BlockUtil.inRange((class_2338)p.getRight(), center, radius);
        }

        public static boolean inRange(class_2338 p, class_2338 center, int radius) {
            if (p == null) {
                return false;
            }
            if (center == null) {
                center = new class_2338(0, 0, 0);
            }
            return p.method_10262((class_2382)center) <= (double)(radius * radius);
        }

        public static int distanceSqr(class_2338 p1, class_2338 p2) {
            return (int)p1.method_10262((class_2382)p2);
        }

        public static Map<class_2680, List<class_2338>> condenseBlockStates(List<Pair<class_2680, class_2338>> blockStates) {
            HashMap<class_2680, List<class_2338>> blocks = new HashMap<class_2680, List<class_2338>>();
            for (Pair<class_2680, class_2338> pair : blockStates) {
                blocks.putIfAbsent((class_2680)pair.getLeft(), new ArrayList());
                ((List)blocks.get(pair.getLeft())).add((class_2338)pair.getRight());
            }
            return blocks;
        }

        public static List<Pair<class_2680, class_2338>> expandBlockStates(Map<class_2680, List<class_2338>> blocks) {
            ArrayList<Pair<class_2680, class_2338>> blockStates = new ArrayList<Pair<class_2680, class_2338>>();
            for (class_2680 block : blocks.keySet()) {
                for (class_2338 pos : blocks.get(block)) {
                    blockStates.add((Pair<class_2680, class_2338>)Pair.of((Object)block, (Object)pos));
                }
            }
            return blockStates;
        }

        public static String serializeBlockPairs(Map<class_2248, List<class_2338>> blocks) {
            StringBuilder blockUpdates = new StringBuilder();
            for (class_2248 block : blocks.keySet()) {
                blockUpdates.append("{");
                String blockName = BlockUtil.blockToString(block);
                blockUpdates.append(blockName);
                blockUpdates.append("=");
                List<class_2338> positions = blocks.get(block);
                if (positions.isEmpty()) {
                    blockUpdates.append("[]}, ");
                    continue;
                }
                for (class_2338 pos : positions) {
                    TripleInt vec = new TripleInt((class_2382)pos);
                    blockUpdates.append("[" + vec.x + "," + vec.y + "," + vec.z + "]");
                    blockUpdates.append("&");
                }
                blockUpdates.deleteCharAt(blockUpdates.length() - 1);
                blockUpdates.append("}, ");
            }
            blockUpdates.deleteCharAt(blockUpdates.length() - 1);
            blockUpdates.deleteCharAt(blockUpdates.length() - 1);
            return blockUpdates.toString();
        }

        public static Map<class_2248, List<class_2338>> deserializeBlockPairs(String data) {
            String[] blocks;
            HashMap<class_2248, List<class_2338>> blockPairs = new HashMap<class_2248, List<class_2338>>();
            for (String pairs : blocks = data.split(", ")) {
                pairs = pairs.substring(1, pairs.length() - 1);
                String[] parts = pairs.split("=");
                String[] blockParts = parts[0].split(":");
                class_2248 blockType = BlockUtil.blockNameToBlock(blockParts[0], blockParts[1]);
                blockPairs.put(blockType, new ArrayList());
                String[] positions = parts[1].split("&");
                if (positions[0].contains("[]")) continue;
                for (String pos : positions) {
                    String[] vec = pos.replace("[", "").replace("]", "").split(",");
                    int x = Integer.parseInt(vec[0]);
                    int y = Integer.parseInt(vec[1]);
                    int z = Integer.parseInt(vec[2]);
                    class_2338 blockPos = new class_2338(x, y, z);
                    ((List)blockPairs.get(blockType)).add(blockPos);
                }
            }
            return blockPairs;
        }

        public static String serializeBlockStatePairs(Map<class_2680, List<class_2338>> blocks) {
            HashMap<class_2248, List<class_2338>> blockMap = new HashMap<class_2248, List<class_2338>>();
            for (class_2680 state : blocks.keySet()) {
                blockMap.put(state.method_26204(), blocks.get(state));
            }
            return BlockUtil.serializeBlockPairs(blockMap);
        }

        public static Map<class_2680, List<class_2338>> deserializeBlockStatePairs(String data) {
            Map<class_2248, List<class_2338>> blockMap = BlockUtil.deserializeBlockPairs(data);
            HashMap<class_2680, List<class_2338>> stateMap = new HashMap<class_2680, List<class_2338>>();
            for (class_2248 block : blockMap.keySet()) {
                stateMap.put(block.method_9564(), blockMap.get(block));
            }
            return stateMap;
        }

        public static int mapTo1DNumber(TripleInt p) {
            return BlockUtil.mapTo1DNumber(new class_2338(p.x, p.y, p.z));
        }

        public static int mapTo1DNumber(class_2338 p) {
            int x = p.method_10263() << 1 ^ p.method_10263() >> 31;
            int y = p.method_10264() << 1 ^ p.method_10264() >> 31;
            int z = p.method_10260() << 1 ^ p.method_10260() >> 31;
            long pairXY = x >= y ? (long)x * (long)x + (long)x + (long)y : (long)y * (long)y + (long)x;
            long pairXYZ = (int)pairXY >= z ? (long)((int)pairXY) * (long)((int)pairXY) + (long)((int)pairXY) + (long)z : (long)z * (long)z + (long)((int)pairXY);
            return (int)(pairXYZ ^ pairXYZ >>> 32);
        }
    }

    public static class PlayerUtil {
        public static List<class_3222> getAllPlayers() {
            MinecraftServer server = GeneralConfig.getInstance().getServer();
            if (server == null) {
                return Collections.emptyList();
            }
            return server.method_3760().method_14571();
        }

        public static List<class_3222> getAllPlayersInBlockRange(class_2338 center, int range) {
            if (range < 1) {
                return Collections.emptyList();
            }
            List<class_3222> players = PlayerUtil.getAllPlayers();
            ArrayList<class_3222> playersInRange = new ArrayList<class_3222>();
            for (class_3222 player : players) {
                if (!(player.method_24515().method_10262((class_2382)center) <= (double)(range * range))) continue;
                playersInRange.add(player);
            }
            return playersInRange;
        }

        public static List<class_3222> getAllPlayersInChunkRange(class_2791 center, int range) {
            List<class_3222> players = PlayerUtil.getAllPlayers();
            ArrayList<class_3222> playersInRange = new ArrayList<class_3222>();
            class_2338 centerPos = center.method_12004().method_8323();
            for (class_3222 player : players) {
                if (!PlayerUtil.getAllPlayersInBlockRange(centerPos, range * 16).contains(player)) continue;
                playersInRange.add(player);
            }
            return playersInRange;
        }
    }
}

