/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;

public class LoggerBase {
    private static List<LogEntry> logHistory = new ArrayList<LogEntry>();
    private static final int MAX_LOG_HISTORY = 10000;
    private static final float SAMPLE_RATE = 0.1f;
    private static String FILTER_TYPE = null;
    private static String FILTER_ID = null;
    private static String FILTER_PREFIX = null;
    private static String FILTER_CONTENT = null;
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String PREFIX = "HB's Foundation";
    public static final Boolean DEBUG_MODE = true;
    private static final HashMap<String, LogEntry> FILTER_RULES = new HashMap();
    private static final HashSet<String> EXCLUDE_PROJECTS;
    private static final HashSet<String> EXCLUDE_CLASS;
    private static final HashSet<String> EXCLUDE_ID;

    protected static synchronized String buildBaseConsoleMessage(String id, String prefix, String message) {
        return "[" + prefix + "] ( " + id + " ): " + message;
    }

    protected static synchronized String buildBaseConsoleMessage(LogEntry entry) {
        return LoggerBase.buildBaseConsoleMessage(entry.id, entry.prefix, entry.message);
    }

    private static LogEntry applySamplingRate(LogEntry entry) {
        boolean containsFilterableType = FILTER_RULES.containsKey(entry.type);
        boolean containsFilterableId = FILTER_RULES.containsKey(entry.id);
        if (containsFilterableType) {
            return FILTER_RULES.get(entry.type);
        }
        if (containsFilterableId) {
            return FILTER_RULES.get(entry.id);
        }
        return null;
    }

    private static boolean shouldPrintLog(LogEntry entry) {
        if (EXCLUDE_PROJECTS.contains(entry.prefix)) {
            return false;
        }
        if (EXCLUDE_CLASS.contains(entry.id.substring(0, 3))) {
            return false;
        }
        if (EXCLUDE_ID.contains(entry.id)) {
            return false;
        }
        LogEntry filterRule = LoggerBase.applySamplingRate(entry);
        if (filterRule == null) {
            return true;
        }
        FILTER_TYPE = filterRule.type;
        FILTER_ID = filterRule.id;
        FILTER_PREFIX = filterRule.prefix;
        FILTER_CONTENT = filterRule.message;
        if (FILTER_TYPE != null && !entry.type.equals(FILTER_TYPE)) {
            return false;
        }
        if (FILTER_ID != null && !entry.id.equals(FILTER_ID)) {
            return false;
        }
        if (FILTER_PREFIX != null && !entry.prefix.equals(FILTER_PREFIX)) {
            return false;
        }
        if (FILTER_CONTENT != null && !entry.message.contains(FILTER_CONTENT)) {
            return false;
        }
        if (entry.sampleRate != null && Math.random() > (double)entry.sampleRate.floatValue()) {
            return false;
        }
        if (FILTER_TYPE == null && FILTER_ID == null && FILTER_PREFIX == null && FILTER_CONTENT == null) {
            return Math.random() < (double)0.1f;
        }
        return true;
    }

    protected static synchronized String buildBaseClientMessage(String prefix, String message) {
        return prefix + ":" + message;
    }

    protected static synchronized String buildClientDisplayMessage(String prefix, String message) {
        return message;
    }

    public static void logInfo(String prefix, String logId, String message) {
        LogEntry entry;
        if (prefix == null) {
            prefix = PREFIX;
        }
        if (LoggerBase.shouldPrintLog(entry = new LogEntry("INFO", logId, prefix, message))) {
            LOGGER.info(LoggerBase.buildBaseConsoleMessage(entry));
        }
    }

    public static void logWarning(String prefix, String logId, String string) {
        if (prefix == null) {
            prefix = PREFIX;
        }
        LogEntry entry = new LogEntry("WARN", logId, prefix, string);
    }

    public static void logError(String prefix, String logId, String string) {
        LogEntry entry;
        if (prefix == null) {
            prefix = PREFIX;
        }
        if (LoggerBase.shouldPrintLog(entry = new LogEntry("ERROR", logId, prefix, string))) {
            LOGGER.error(LoggerBase.buildBaseConsoleMessage(entry));
        }
    }

    public static void logDebug(String prefix, String logId, String string) {
        LogEntry entry;
        if (prefix == null) {
            prefix = PREFIX;
        }
        if (DEBUG_MODE.booleanValue() && LoggerBase.shouldPrintLog(entry = new LogEntry("DEBUG", logId, prefix, string))) {
            LOGGER.info(LoggerBase.buildBaseConsoleMessage(entry));
        }
    }

    public static List<LogEntry> filterByType(String type) {
        return LoggerBase.filterLogs(entry -> entry.type.equals(type));
    }

    public static List<LogEntry> filterById(String id) {
        return LoggerBase.filterLogs(entry -> entry.id.equals(id));
    }

    public static List<LogEntry> filterByPrefix(String prefix) {
        return LoggerBase.filterLogs(entry -> entry.prefix.equals(prefix));
    }

    public static List<LogEntry> filterByMessageContent(String content) {
        return LoggerBase.filterLogs(entry -> entry.message.contains(content));
    }

    public static List<LogEntry> filterByTimeRange(long startTime, long endTime) {
        return LoggerBase.filterLogs(entry -> entry.timestamp >= startTime && entry.timestamp <= endTime);
    }

    private static List<LogEntry> filterLogs(Predicate<LogEntry> predicate) {
        ArrayList<LogEntry> filtered = new ArrayList<LogEntry>();
        for (LogEntry entry : logHistory) {
            if (!predicate.test(entry)) continue;
            filtered.add(entry);
        }
        return filtered;
    }

    public static void logInit(String prefix, String logId, String string) {
        LoggerBase.logDebug(prefix, logId, "--------" + string.toUpperCase() + " INITIALIZED --------");
    }

    public static void logClientInfo(String message) {
        LOGGER.info(LoggerBase.buildBaseClientMessage(PREFIX, message));
    }

    public static void logClientDisplay(String message) {
        String msg = LoggerBase.buildClientDisplayMessage("", message);
    }

    public static float getTime(long t1, long t2) {
        return (t2 - t1) / 1000000L;
    }

    public static void threadExited(String prefix, String logId, Object threadContainer, Throwable thrown) {
        StringBuilder sb = new StringBuilder();
        sb.append("Thread " + Thread.currentThread().getName() + " exited");
        if (thrown == null) {
            LoggerBase.logDebug(null, logId, sb + " gracefully");
        } else {
            StackTraceElement[] stackTrace;
            sb.append(" with exception: " + thrown.getMessage());
            for (StackTraceElement ste : stackTrace = thrown.getStackTrace()) {
                sb.append("\n" + ste.toString());
            }
            sb.append("\n\n");
            LoggerBase.logError(null, logId, sb.toString());
        }
    }

    static {
        FILTER_RULES.put("003001", new LogEntry(null, null, null, null, Float.valueOf(0.1f)));
        FILTER_RULES.put("003002", new LogEntry(null, null, null, null, Float.valueOf(0.1f)));
        FILTER_RULES.put("003007", new LogEntry(null, null, null, "minecraft:", null));
        FILTER_RULES.put("007002", new LogEntry(null, null, null, "1", null));
        FILTER_RULES.put("002020", new LogEntry(null, null, null, null, null));
        FILTER_RULES.put("002004", new LogEntry(null, null, null, null, null));
        FILTER_RULES.put("002032", new LogEntry(null, null, null, null, null));
        FILTER_RULES.put("002028", new LogEntry(null, null, null, null, Float.valueOf(0.001f)));
        FILTER_RULES.put("002025", new LogEntry(null, null, null, null, Float.valueOf(0.01f)));
        FILTER_RULES.put("002026", new LogEntry(null, null, null, null, Float.valueOf(0.01f)));
        FILTER_RULES.put("002027", new LogEntry(null, null, null, null, Float.valueOf(0.01f)));
        FILTER_RULES.put("002015", new LogEntry(null, null, null, null, Float.valueOf(0.01f)));
        FILTER_RULES.put("002033", new LogEntry(null, null, null, null, Float.valueOf(0.01f)));
        EXCLUDE_PROJECTS = new HashSet<String>(Arrays.asList(""));
        EXCLUDE_CLASS = new HashSet<String>(Arrays.asList(""));
        EXCLUDE_ID = new HashSet<String>(Arrays.asList("003007", "002004", "002029", "002010", "002018", "005003", "009001", ""));
    }

    protected static class LogEntry {
        public String type;
        public String id;
        public String prefix;
        public String message;
        public Float sampleRate;
        public long timestamp;

        public LogEntry(String type, String id, String prefix, String message, Float sampleRate) {
            this.type = type;
            this.id = id;
            this.prefix = prefix;
            this.message = message;
            this.sampleRate = sampleRate;
            this.timestamp = System.currentTimeMillis();
        }

        public LogEntry(String type, String id, String prefix, String message) {
            this(type, id, prefix, message, null);
        }
    }
}

