/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.datastore;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.datastore.LevelSaveData;
import com.holybuckets.foundation.datastore.ModSaveData;
import com.holybuckets.foundation.datastore.WorldSaveData;
import com.holybuckets.foundation.modelInterface.IStringSerializable;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.minecraft.class_1936;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class DataStore
implements IStringSerializable {
    private static final String CLASS_ID = "007";
    private static DataStore INSTANCE;
    private static final File DATA_STORE_FILE;
    private final Map<String, ModSaveData> STORE;
    private String currentWorldId;

    private DataStore() {
        this.currentWorldId = null;
        this.STORE = new HashMap<String, ModSaveData>();
    }

    public static DataStore init() {
        INSTANCE = new DataStore();
        return INSTANCE;
    }

    private void loadData(String worldId) {
        this.currentWorldId = worldId;
        String json = HBUtil.FileIO.loadJsonConfigs(DATA_STORE_FILE, DATA_STORE_FILE, new DefaultDataStore());
        this.deserialize(json);
        this.save();
    }

    private DataStore(ModSaveData data) {
        this.STORE = new HashMap<String, ModSaveData>();
        this.STORE.put(data.getModId(), data);
    }

    public ModSaveData getOrCreateModSavedData(String modId) {
        ModSaveData data = this.STORE.getOrDefault(modId, new ModSaveData(modId));
        this.STORE.put(modId, data);
        return data;
    }

    public WorldSaveData getOrCreateWorldSaveData(String modId) {
        ModSaveData modData = this.getOrCreateModSavedData(modId);
        return modData.getOrCreateWorldSaveData(this.currentWorldId);
    }

    public LevelSaveData getOrCreateLevelSaveData(String modId, class_1936 level) {
        WorldSaveData worldData = this.getOrCreateWorldSaveData(modId);
        return worldData.getOrCreateLevelSaveData(level);
    }

    public boolean initWorldDataOnServerStart(ServerStartingEvent event) {
        ModSaveData modData = this.getOrCreateModSavedData("hbs_foundation");
        if (modData.worldSaveData.containsKey(this.currentWorldId)) {
            return false;
        }
        GeneralConfig config = GeneralConfig.getInstance();
        while (config == null || !config.isWorldConfigInit()) {
            config = GeneralConfig.getInstance();
        }
        WorldSaveData worldData = modData.getOrCreateWorldSaveData(this.currentWorldId);
        worldData.addProperty("worldSeed", DataStore.parse(config.getWorldSeed()));
        worldData.addProperty("totalTicks", DataStore.parse(0));
        return true;
    }

    private static JsonElement parse(Object o) {
        return JsonParser.parseString((String)GeneralConfig.GSON.toJson(o));
    }

    @Override
    public void deserialize(String jsonString) {
        if (jsonString == null || jsonString.isEmpty()) {
            return;
        }
        String malformedJson = null;
        try {
            JsonParser.parseString((String)jsonString);
        }
        catch (Exception e) {
            StringBuilder error = new StringBuilder();
            error.append("Error parsing JSON data from Datastore, file: ");
            error.append(DATA_STORE_FILE);
            error.append(".  The datastore will be configured with defaults values. Copy the file to save your data. ");
            malformedJson = new String(jsonString);
            jsonString = new DefaultDataStore().serialize();
        }
        JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
        JsonArray modSaveDataArray = json.getAsJsonArray("modSaveData");
        modSaveDataArray.forEach(modSaveData -> {
            ModSaveData data = new ModSaveData(modSaveData.getAsJsonObject());
            this.STORE.put(data.getModId(), data);
        });
        if (malformedJson != null) {
            ModSaveData utilData = this.STORE.get("hbs_foundation");
            String asString = malformedJson.replace('\"', '\'').replaceAll("\r\n", "");
            utilData.addProperty("malformedJson", DataStore.parse(asString));
            this.save();
        }
    }

    @Override
    public String serialize() {
        JsonObject json = new JsonObject();
        JsonArray modSaveDataArray = new JsonArray();
        this.STORE.forEach((modId, data) -> modSaveDataArray.add((JsonElement)data.toJson()));
        json.add("modSaveData", (JsonElement)modSaveDataArray);
        return json.toString();
    }

    public void save() {
        HBUtil.FileIO.serializeJsonConfigs(DATA_STORE_FILE, this.serialize());
    }

    public void onBeforeServerStarted(ServerStartingEvent serverStartedEvent) {
        this.initDatastoreOnServerStart(serverStartedEvent);
        new Thread(() -> this.initWorldDataOnServerStart(serverStartedEvent)).start();
    }

    private void initDatastoreOnServerStart(ServerStartingEvent event) {
        MinecraftServer s = event.getServer();
        Path path = s.method_27050(class_5218.field_24188);
        this.loadData(path.getParent().getFileName().toString());
    }

    public void onServerStopped(ServerStoppedEvent s) {
        this.shutdown(s);
    }

    public void shutdown(ServerStoppedEvent s) {
        WorldSaveData worldData = this.getOrCreateWorldSaveData("hbs_foundation");
        GeneralConfig config = GeneralConfig.getInstance();
        Long currentTicks = GeneralConfig.getInstance().getTotalTickCount();
        worldData.addProperty("totalTicks", DataStore.parse(currentTicks));
        GeneralConfig.getInstance().stopAutoSaveThread();
        this.save();
    }

    public static Long getTotalTickCount() {
        ModSaveData modData = INSTANCE.getOrCreateModSavedData("hbs_foundation");
        if (!modData.worldSaveData.containsKey(DataStore.INSTANCE.currentWorldId)) {
            return -1L;
        }
        WorldSaveData worldData = modData.getOrCreateWorldSaveData(DataStore.INSTANCE.currentWorldId);
        return worldData.get("totalTicks").getAsLong();
    }

    static {
        DATA_STORE_FILE = new File("hb_datastore.json");
    }

    private class DefaultDataStore
    extends DataStore
    implements IStringSerializable {
        public static final ModSaveData DATA = new ModSaveData("hbs_foundation");

        public DefaultDataStore() {
            super(DATA);
        }

        @Override
        public String serialize() {
            return super.serialize();
        }

        @Override
        public void deserialize(String jsonString) {
        }

        static {
            DATA.setComment("The purpose of this JSON file is to store data at the world save file level for supporting HB Utility Foundation mods. This data is not intended to be modified by the user.");
        }
    }
}

