/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.datastore;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.holybuckets.foundation.HBUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1936;

public class LevelSaveData {
    String levelId;
    class_1936 level;
    final Map<String, JsonElement> properties;

    public LevelSaveData(class_1936 level) {
        if (level == null) {
            throw new IllegalArgumentException("Level cannot be null");
        }
        this.level = level;
        this.levelId = HBUtil.LevelUtil.toLevelId(level);
        this.properties = new ConcurrentHashMap<String, JsonElement>();
    }

    public LevelSaveData(JsonObject json) {
        this.levelId = json.get("levelId").getAsString();
        this.level = null;
        this.properties = new ConcurrentHashMap<String, JsonElement>();
        this.fromJson(json);
    }

    public class_1936 getLevel() {
        return this.level;
    }

    public void addProperty(String key, JsonElement data) {
        this.properties.put(key, data);
    }

    public JsonElement get(String jsonProperty) {
        return this.properties.get(jsonProperty);
    }

    JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("levelId", this.levelId);
        this.properties.forEach((key, value) -> json.add(key, value));
        return json;
    }

    public void fromJson(JsonObject json) {
        this.properties.clear();
        this.levelId = json.get("levelId").getAsString();
        json.remove("levelId");
        this.properties.putAll(json.asMap());
    }
}

