/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.datastore;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.holybuckets.foundation.datastore.WorldSaveData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ModSaveData {
    private static final String CLASS_ID = "008";
    String MOD_ID;
    Map<String, JsonElement> properties;
    Map<String, WorldSaveData> worldSaveData;
    String comment;

    ModSaveData(String modId) {
        this.MOD_ID = modId;
        this.properties = new ConcurrentHashMap<String, JsonElement>();
        this.worldSaveData = new ConcurrentHashMap<String, WorldSaveData>();
    }

    ModSaveData(JsonObject worldSaveData) {
        this(worldSaveData.get("modId").getAsString());
        this.fromJson(worldSaveData);
    }

    public void createWorldSaveData(JsonElement json) {
        WorldSaveData w = new WorldSaveData(json.getAsJsonObject());
        this.worldSaveData.put(w.getWorldId(), w);
    }

    public String getModId() {
        return this.MOD_ID;
    }

    public WorldSaveData getOrCreateWorldSaveData(String worldId) {
        WorldSaveData data = this.worldSaveData.getOrDefault(worldId, new WorldSaveData(worldId));
        this.worldSaveData.put(worldId, data);
        return data;
    }

    public void addProperty(String key, JsonElement data) {
        this.properties.put(key, data);
    }

    public void clearWorldSaveData() {
        this.worldSaveData.clear();
    }

    JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("modId", this.MOD_ID);
        if (this.comment != null) {
            json.addProperty("comment", this.comment);
        }
        this.properties.forEach((arg_0, arg_1) -> ((JsonObject)json).add(arg_0, arg_1));
        JsonArray worldSaveDataArray = new JsonArray();
        this.worldSaveData.forEach((key, value) -> worldSaveDataArray.add((JsonElement)value.toJson()));
        json.add("worldSaves", (JsonElement)worldSaveDataArray);
        return json;
    }

    private void fromJson(JsonObject json) {
        this.properties.clear();
        this.MOD_ID = json.get("modId").getAsString();
        json.remove("modId");
        JsonElement comment = json.get("comment");
        if (comment != null) {
            this.comment = json.get("comment").getAsString();
            json.remove("comment");
        }
        JsonArray worldSaves = json.getAsJsonArray("worldSaves");
        worldSaves.forEach(this::createWorldSaveData);
        json.remove("worldSaves");
        this.properties.putAll(json.asMap());
    }

    public void setComment(String s) {
        this.comment = s;
    }
}

