/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.datastore;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.datastore.LevelSaveData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1936;

public class WorldSaveData {
    String worldId;
    final Map<String, JsonElement> properties;
    final Map<String, LevelSaveData> levelData;

    WorldSaveData(String worldId) {
        if (worldId == null) {
            throw new IllegalArgumentException("World ID cannot be null");
        }
        this.worldId = worldId;
        this.properties = new ConcurrentHashMap<String, JsonElement>();
        this.levelData = new ConcurrentHashMap<String, LevelSaveData>();
    }

    WorldSaveData(JsonObject json) {
        this.properties = new ConcurrentHashMap<String, JsonElement>();
        this.levelData = new ConcurrentHashMap<String, LevelSaveData>();
        this.fromJson(json);
    }

    public String getWorldId() {
        return this.worldId;
    }

    public LevelSaveData getOrCreateLevelSaveData(class_1936 level) {
        String id = HBUtil.LevelUtil.toLevelId(level);
        LevelSaveData data = this.levelData.getOrDefault(id, new LevelSaveData(level));
        this.levelData.put(id, data);
        return data;
    }

    public void removeLevelSaveData(class_1936 level) {
        this.levelData.remove(HBUtil.LevelUtil.toLevelId(level));
    }

    public void createLevelSaveData(JsonElement json) {
        LevelSaveData data = new LevelSaveData(json.getAsJsonObject());
        this.levelData.put(data.levelId, data);
    }

    public void addProperty(String key, JsonElement data) {
        this.properties.put(key, data);
    }

    public JsonElement get(String property) {
        return this.properties.get(property);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("worldId", this.worldId);
        this.properties.forEach((arg_0, arg_1) -> ((JsonObject)json).add(arg_0, arg_1));
        JsonArray levelDataArray = new JsonArray();
        this.levelData.forEach((levelId, levelSaveData) -> levelDataArray.add((JsonElement)levelSaveData.toJson()));
        json.add("levelData", (JsonElement)levelDataArray);
        return json;
    }

    void fromJson(JsonObject json) {
        this.properties.clear();
        this.worldId = json.get("worldId").getAsString();
        json.remove("worldId");
        JsonArray levelData = json.getAsJsonArray("levelData");
        levelData.forEach(this::createLevelSaveData);
        json.remove("levelData");
        this.properties.putAll(json.asMap());
    }
}

