/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.datastructure;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentSet<T>
implements Set<T> {
    private final ConcurrentHashMap<T, Object> map;
    private static final Object PRESENT = new Object();

    public ConcurrentSet() {
        this.map = new ConcurrentHashMap();
    }

    public ConcurrentSet(int initialCapacity) {
        this.map = new ConcurrentHashMap(initialCapacity);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        return ((ConcurrentHashMap.KeySetView)this.map.keySet()).iterator();
    }

    @Override
    public Object[] toArray() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.map.keySet())).toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return ((ConcurrentHashMap.CollectionView)((Object)this.map.keySet())).toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.map.put(t, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return ((ConcurrentHashMap.CollectionView)((Object)this.map.keySet())).containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean modified = false;
        for (T e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return ((ConcurrentHashMap.CollectionView)((Object)this.map.keySet())).retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return ((ConcurrentHashMap.KeySetView)this.map.keySet()).removeAll((Collection)c);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set s = (Set)o;
        return s.size() == this.map.size() && ((ConcurrentHashMap.CollectionView)((Object)this.map.keySet())).containsAll(s);
    }

    @Override
    public int hashCode() {
        return ((ConcurrentHashMap.KeySetView)this.map.keySet()).hashCode();
    }
}

