/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.event;

import com.holybuckets.foundation.datastructure.ConcurrentSet;
import com.holybuckets.foundation.event.CommandRegistry;
import com.holybuckets.foundation.event.EventRegistrar;
import java.util.Set;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.command.BalmCommands;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.balm.api.event.ChunkLoadingEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.balm.api.event.client.ClientStartedEvent;
import net.blay09.mods.balm.api.event.client.ConnectedToServerEvent;
import net.blay09.mods.balm.api.event.client.DisconnectedFromServerEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;

public class BalmEventRegister {
    private static final Set<Integer> registeredEvents = new ConcurrentSet<Integer>();
    private static EventRegistrar events;

    private static boolean notRegistered(Consumer<?> c) {
        return !registeredEvents.contains(c.hashCode());
    }

    public static EventPriority p(Consumer<?> func) {
        return BalmEventRegister.events.PRIORITIES.get(func.hashCode());
    }

    public static void registerEvents() {
        BalmEvents registry = Balm.getEvents();
        events = EventRegistrar.getInstance();
        BalmEventRegister.events.ON_CLIENT_STARTED_EVENT.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(ClientStartedEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.events.ON_CONNECTED_TO_SERVER.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(ConnectedToServerEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.events.ON_DISCONNECTED_FROM_SERVER.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(DisconnectedFromServerEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.events.ON_BEFORE_SERVER_START.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(ServerStartingEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.events.ON_SERVER_START.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(ServerStartedEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.events.ON_SERVER_STOP.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(ServerStoppedEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.events.ON_LEVEL_LOAD.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(LevelLoadingEvent.Load.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.events.ON_LEVEL_UNLOAD.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(LevelLoadingEvent.Unload.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.events.ON_CHUNK_LOAD.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(ChunkLoadingEvent.Load.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.events.ON_CHUNK_UNLOAD.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(ChunkLoadingEvent.Unload.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
        BalmEventRegister.events.ON_PLAYER_LOAD.stream().filter(BalmEventRegister::notRegistered).forEach(c -> {
            registry.onEvent(PlayerLoginEvent.class, c, BalmEventRegister.p(c));
            registeredEvents.add(c.hashCode());
        });
    }

    public static void registerCommands() {
        BalmCommands commands = Balm.getCommands();
        commands.register(CommandRegistry::register);
    }
}

