/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.event;

import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.LoggerBase;
import com.holybuckets.foundation.datastructure.ConcurrentSet;
import com.holybuckets.foundation.event.custom.DatastoreSaveEvent;
import com.holybuckets.foundation.event.custom.ServerTickEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.event.ChunkLoadingEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.balm.api.event.client.ClientStartedEvent;
import net.blay09.mods.balm.api.event.client.ConnectedToServerEvent;
import net.blay09.mods.balm.api.event.client.DisconnectedFromServerEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.minecraft.server.MinecraftServer;

public class EventRegistrar {
    public static final String CLASS_ID = "010";
    private static EventRegistrar instance;
    final Map<Integer, EventPriority> PRIORITIES = new HashMap<Integer, EventPriority>();
    final Set<Consumer<PlayerLoginEvent>> ON_PLAYER_LOAD = new ConcurrentSet<Consumer<PlayerLoginEvent>>();
    final Set<Consumer<LevelLoadingEvent.Load>> ON_LEVEL_LOAD = new ConcurrentSet<Consumer<LevelLoadingEvent.Load>>();
    final Set<Consumer<LevelLoadingEvent.Unload>> ON_LEVEL_UNLOAD = new ConcurrentSet<Consumer<LevelLoadingEvent.Unload>>();
    final Set<Consumer<ChunkLoadingEvent.Load>> ON_CHUNK_LOAD = new ConcurrentSet<Consumer<ChunkLoadingEvent.Load>>();
    final Set<Consumer<ChunkLoadingEvent.Unload>> ON_CHUNK_UNLOAD = new ConcurrentSet<Consumer<ChunkLoadingEvent.Unload>>();
    final Set<Consumer<ClientStartedEvent>> ON_CLIENT_STARTED_EVENT = new ConcurrentSet<Consumer<ClientStartedEvent>>();
    final Set<Consumer<ServerStartingEvent>> ON_BEFORE_SERVER_START = new ConcurrentSet<Consumer<ServerStartingEvent>>();
    final Set<Consumer<ServerStartedEvent>> ON_SERVER_START = new ConcurrentSet<Consumer<ServerStartedEvent>>();
    final Set<Consumer<ServerStoppedEvent>> ON_SERVER_STOP = new ConcurrentSet<Consumer<ServerStoppedEvent>>();
    final Set<Consumer<ConnectedToServerEvent>> ON_CONNECTED_TO_SERVER = new ConcurrentSet<Consumer<ConnectedToServerEvent>>();
    final Set<Consumer<DisconnectedFromServerEvent>> ON_DISCONNECTED_FROM_SERVER = new ConcurrentSet<Consumer<DisconnectedFromServerEvent>>();
    final Set<Consumer<ServerTickEvent.SingleTick>> ON_SINGLE_TICK = new ConcurrentSet<Consumer<ServerTickEvent.SingleTick>>();
    final Set<Consumer<ServerTickEvent.Every20Ticks>> ON_20_TICKS = new ConcurrentSet<Consumer<ServerTickEvent.Every20Ticks>>();
    final Set<Consumer<ServerTickEvent.Every120Ticks>> ON_120_TICKS = new ConcurrentSet<Consumer<ServerTickEvent.Every120Ticks>>();
    final Set<Consumer<ServerTickEvent.Every1200Ticks>> ON_1200_TICKS = new ConcurrentSet<Consumer<ServerTickEvent.Every1200Ticks>>();
    final Set<Consumer<ServerTickEvent.Every1200Ticks>> ON_6000_TICKS = new ConcurrentSet<Consumer<ServerTickEvent.Every1200Ticks>>();
    final Set<Consumer<ServerTickEvent.DailyTick>> ON_DAILY_TICK = new ConcurrentSet<Consumer<ServerTickEvent.DailyTick>>();
    final Set<Consumer<DatastoreSaveEvent>> ON_DATA_SAVE = new ConcurrentSet<Consumer<DatastoreSaveEvent>>();

    private EventRegistrar() {
        LoggerBase.logInit(null, "010000", this.getClass().getName());
        instance = this;
    }

    public static EventRegistrar getInstance() {
        return instance;
    }

    public static void init() {
        instance = new EventRegistrar();
    }

    public void dataSaveEvent() {
        DatastoreSaveEvent event = DatastoreSaveEvent.create();
        for (Consumer<DatastoreSaveEvent> saver : this.ON_DATA_SAVE) {
            saver.accept(event);
        }
        event.getDataStore().save();
    }

    public void onServerTick(MinecraftServer server) {
        long totalTicks = GeneralConfig.getInstance().getTotalTickCount();
        ServerTickEvent.SingleTick singleTickEvent = new ServerTickEvent.SingleTick(totalTicks);
        for (Consumer<ServerTickEvent.SingleTick> consumer : this.ON_SINGLE_TICK) {
            consumer.accept(singleTickEvent);
        }
        if (totalTicks % 20L == 0L) {
            ServerTickEvent.Every20Ticks event20 = new ServerTickEvent.Every20Ticks(totalTicks);
            for (Consumer<ServerTickEvent.Every20Ticks> consumer : this.ON_20_TICKS) {
                consumer.accept(event20);
            }
        }
        if (totalTicks % 120L == 0L) {
            ServerTickEvent.Every120Ticks event120 = new ServerTickEvent.Every120Ticks(totalTicks);
            for (Consumer<ServerTickEvent> consumer : this.ON_120_TICKS) {
                consumer.accept(event120);
            }
        }
        if (totalTicks % 1200L == 0L) {
            ServerTickEvent.Every1200Ticks event1200 = new ServerTickEvent.Every1200Ticks(totalTicks);
            for (Consumer<ServerTickEvent> consumer : this.ON_1200_TICKS) {
                consumer.accept(event1200);
            }
        }
        if (totalTicks % 6000L == 0L) {
            ServerTickEvent.Every1200Ticks event6000 = new ServerTickEvent.Every1200Ticks(totalTicks);
            for (Consumer<ServerTickEvent> consumer : this.ON_6000_TICKS) {
                consumer.accept(event6000);
            }
        }
        if (totalTicks % 24000L == 0L) {
            ServerTickEvent.DailyTick eventDaily = new ServerTickEvent.DailyTick(totalTicks);
            for (Consumer<ServerTickEvent> consumer : this.ON_DAILY_TICK) {
                consumer.accept(eventDaily);
            }
        }
    }

    private <T> void generalRegister(Consumer<T> function, Set<Consumer<T>> set, EventPriority priority) {
        set.add(function);
        this.PRIORITIES.put(function.hashCode(), priority);
    }

    public void registerOnPlayerLoad(Consumer<PlayerLoginEvent> function) {
        this.registerOnPlayerLoad(function, EventPriority.Normal);
    }

    public void registerOnPlayerLoad(Consumer<PlayerLoginEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_PLAYER_LOAD, priority);
    }

    public void registerOnLevelLoad(Consumer<LevelLoadingEvent.Load> function) {
        this.registerOnLevelLoad(function, EventPriority.Normal);
    }

    public void registerOnLevelLoad(Consumer<LevelLoadingEvent.Load> function, EventPriority priority) {
        this.generalRegister(function, this.ON_LEVEL_LOAD, priority);
    }

    public void registerOnLevelUnload(Consumer<LevelLoadingEvent.Unload> function) {
        this.registerOnLevelUnload(function, EventPriority.Normal);
    }

    public void registerOnLevelUnload(Consumer<LevelLoadingEvent.Unload> function, EventPriority priority) {
        this.generalRegister(function, this.ON_LEVEL_UNLOAD, priority);
    }

    public void registerOnChunkLoad(Consumer<ChunkLoadingEvent.Load> function) {
        this.registerOnChunkLoad(function, EventPriority.Normal);
    }

    public void registerOnChunkLoad(Consumer<ChunkLoadingEvent.Load> function, EventPriority priority) {
        this.generalRegister(function, this.ON_CHUNK_LOAD, priority);
    }

    public void registerOnChunkUnload(Consumer<ChunkLoadingEvent.Unload> function) {
        this.registerOnChunkUnload(function, EventPriority.Normal);
    }

    public void registerOnChunkUnload(Consumer<ChunkLoadingEvent.Unload> function, EventPriority priority) {
        this.generalRegister(function, this.ON_CHUNK_UNLOAD, priority);
    }

    public void registerOnClientStarted(Consumer<ClientStartedEvent> function) {
        this.registerOnClientStarted(function, EventPriority.Normal);
    }

    public void registerOnClientStarted(Consumer<ClientStartedEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_CLIENT_STARTED_EVENT, priority);
    }

    public void registerOnBeforeServerStarted(Consumer<ServerStartingEvent> function) {
        this.registerOnBeforeServerStarted(function, EventPriority.Normal);
    }

    public void registerOnBeforeServerStarted(Consumer<ServerStartingEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_BEFORE_SERVER_START, priority);
    }

    public void registerOnServerStarted(Consumer<ServerStartedEvent> function) {
        this.registerOnServerStarted(function, EventPriority.Normal);
    }

    public void registerOnServerStarted(Consumer<ServerStartedEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_SERVER_START, priority);
    }

    public void registerOnServerStopped(Consumer<ServerStoppedEvent> function) {
        this.registerOnServerStopped(function, EventPriority.Normal);
    }

    public void registerOnServerStopped(Consumer<ServerStoppedEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_SERVER_STOP, priority);
    }

    public void registerOnConnectedToServer(Consumer<ConnectedToServerEvent> function) {
        this.registerOnConnectedToServer(function, EventPriority.Normal);
    }

    public void registerOnConnectedToServer(Consumer<ConnectedToServerEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_CONNECTED_TO_SERVER, priority);
    }

    public void registerOnDisconnectedFromServer(Consumer<DisconnectedFromServerEvent> function) {
        this.registerOnDisconnectedFromServer(function, EventPriority.Normal);
    }

    public void registerOnDisconnectedFromServer(Consumer<DisconnectedFromServerEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_DISCONNECTED_FROM_SERVER, priority);
    }

    public <T extends ServerTickEvent> void registerOnServerTick(TickType type, Consumer<T> function) {
        this.registerOnServerTick(type, function, EventPriority.Normal);
    }

    public <T extends ServerTickEvent> void registerOnServerTick(TickType type, Consumer<T> function, EventPriority priority) {
        switch (type) {
            case ON_SINGLE_TICK: {
                this.generalRegister(function, this.ON_SINGLE_TICK, priority);
                break;
            }
            case ON_20_TICKS: {
                this.generalRegister(function, this.ON_20_TICKS, priority);
                break;
            }
            case ON_120_TICKS: {
                this.generalRegister(function, this.ON_120_TICKS, priority);
                break;
            }
            case ON_1200_TICKS: {
                this.generalRegister(function, this.ON_1200_TICKS, priority);
                break;
            }
            case ON_6000_TICKS: {
                this.generalRegister(function, this.ON_6000_TICKS, priority);
                break;
            }
            case DAILY_TICK: {
                this.generalRegister(function, this.ON_DAILY_TICK, priority);
            }
        }
    }

    public void registerOnDataSave(Consumer<DatastoreSaveEvent> function) {
        this.registerOnDataSave(function, EventPriority.Normal);
    }

    public void registerOnDataSave(Consumer<DatastoreSaveEvent> function, EventPriority priority) {
        this.generalRegister(function, this.ON_DATA_SAVE, priority);
    }

    public static enum TickType {
        ON_SINGLE_TICK,
        ON_20_TICKS,
        ON_120_TICKS,
        ON_1200_TICKS,
        ON_6000_TICKS,
        DAILY_TICK;

    }
}

