/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.mixin;

import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.util.MixinManager;
import java.util.function.BooleanSupplier;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public class MinecraftServerMixin {
    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    private void init(CallbackInfo info) {
    }

    @Inject(method={"tickChildren"}, at={@At(value="HEAD")})
    private void onTickChildren(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        MinecraftServer server = (MinecraftServer)this;
        if (MixinManager.isEnabled("MinecraftServerMixin::onTickChildren")) {
            try {
                EventRegistrar.getInstance().onServerTick(server);
            }
            catch (Exception e) {
                MixinManager.recordError("MinecraftServerMixin::onTickChildren", e);
            }
        }
    }
}

